# Generated by default/object.tt
package Paws::SecurityHub::AwsEc2NetworkAclEntry;
  use Moose;
  has CidrBlock => (is => 'ro', isa => 'Str');
  has Egress => (is => 'ro', isa => 'Bool');
  has IcmpTypeCode => (is => 'ro', isa => 'Paws::SecurityHub::IcmpTypeCode');
  has Ipv6CidrBlock => (is => 'ro', isa => 'Str');
  has PortRange => (is => 'ro', isa => 'Paws::SecurityHub::PortRangeFromTo');
  has Protocol => (is => 'ro', isa => 'Str');
  has RuleAction => (is => 'ro', isa => 'Str');
  has RuleNumber => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsEc2NetworkAclEntry

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsEc2NetworkAclEntry object:

  $service_obj->Method(Att1 => { CidrBlock => $value, ..., RuleNumber => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsEc2NetworkAclEntry object:

  $result = $service_obj->Method(...);
  $result->Att1->CidrBlock

=head1 DESCRIPTION

A rule for the network ACL. Each rule allows or denies access based on
the IP address, traffic direction, port, and protocol.

=head1 ATTRIBUTES


=head2 CidrBlock => Str

The IPV4 network range for which to deny or allow access.


=head2 Egress => Bool

Whether the rule is an egress rule. An egress rule is a rule that
applies to traffic that leaves the subnet.


=head2 IcmpTypeCode => L<Paws::SecurityHub::IcmpTypeCode>

The Internet Control Message Protocol (ICMP) type and code for which to
deny or allow access.


=head2 Ipv6CidrBlock => Str

The IPV6 network range for which to deny or allow access.


=head2 PortRange => L<Paws::SecurityHub::PortRangeFromTo>

For TCP or UDP protocols, the range of ports that the rule applies to.


=head2 Protocol => Str

The protocol that the rule applies to. To deny or allow access to all
protocols, use the value -1.


=head2 RuleAction => Str

Whether the rule is used to allow access or deny access.


=head2 RuleNumber => Int

The rule number. The rules are processed in order by their number.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

