# automatically generated file, don't edit



# Copyright 2023 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::AT;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20230614174400;

my $formatters = [
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '14',
                  'pattern' => '(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              11|
              [2-9]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '517',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '5[079]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,5})'
                },
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '[18]',
                  'pattern' => '(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            (?:
              31|
              4
            )6|
            51|
            6(?:
              5[0-3579]|
              [6-9]
            )|
            7(?:
              20|
              32|
              8
            )|
            [89]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [2-467]|
            5[2-6]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{3,9})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '5',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '5',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4,7})'
                }
              ];

my $validators = {
                'fixed_line' => '
          1(?:
            11\\d|
            [2-9]\\d{3,11}
          )|
          (?:
            316|
            463|
            (?:
              51|
              66|
              73
            )2
          )\\d{3,10}|
          (?:
            2(?:
              1[467]|
              2[13-8]|
              5[2357]|
              6[1-46-8]|
              7[1-8]|
              8[124-7]|
              9[1458]
            )|
            3(?:
              1[1-578]|
              3[23568]|
              4[5-7]|
              5[1378]|
              6[1-38]|
              8[3-68]
            )|
            4(?:
              2[1-8]|
              35|
              7[1368]|
              8[2457]
            )|
            5(?:
              2[1-8]|
              3[357]|
              4[147]|
              5[12578]|
              6[37]
            )|
            6(?:
              13|
              2[1-47]|
              4[135-8]|
              5[468]
            )|
            7(?:
              2[1-8]|
              35|
              4[13478]|
              5[68]|
              6[16-8]|
              7[1-6]|
              9[45]
            )
          )\\d{4,10}
        ',
                'geographic' => '
          1(?:
            11\\d|
            [2-9]\\d{3,11}
          )|
          (?:
            316|
            463|
            (?:
              51|
              66|
              73
            )2
          )\\d{3,10}|
          (?:
            2(?:
              1[467]|
              2[13-8]|
              5[2357]|
              6[1-46-8]|
              7[1-8]|
              8[124-7]|
              9[1458]
            )|
            3(?:
              1[1-578]|
              3[23568]|
              4[5-7]|
              5[1378]|
              6[1-38]|
              8[3-68]
            )|
            4(?:
              2[1-8]|
              35|
              7[1368]|
              8[2457]
            )|
            5(?:
              2[1-8]|
              3[357]|
              4[147]|
              5[12578]|
              6[37]
            )|
            6(?:
              13|
              2[1-47]|
              4[135-8]|
              5[468]
            )|
            7(?:
              2[1-8]|
              35|
              4[13478]|
              5[68]|
              6[16-8]|
              7[1-6]|
              9[45]
            )
          )\\d{4,10}
        ',
                'mobile' => '
          6(?:
            5[0-3579]|
            6[013-9]|
            [7-9]\\d
          )\\d{4,10}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(
          8(?:
            10|
            2[018]
          )\\d{6,10}|
          828\\d{5}
        )|(
          (?:
            8[69][2-68]|
            9(?:
              0[01]|
              3[019]
            )
          )\\d{6,10}
        )',
                'toll_free' => '800\\d{6,10}',
                'voip' => '
          5(?:
            0[1-9]|
            17|
            [79]\\d
          )\\d{2,10}|
          7[28]0\\d{6,10}
        '
              };
my %areanames = ();
$areanames{en} = {"432747", "Ober\-Grafendorf",
"437667", "St\.\ Georgen\ im\ Attergau",
"432955", "Grossweikersdorf",
"434824", "Heiligenblut",
"435519", "Schröcken",
"437357", "Kleinreifling",
"432942", "Retz",
"436247", "Grossgmain",
"433359", "Loipersdorf\-Kitzladen",
"437234", "Ottensheim",
"436457", "Flachau",
"437213", "Bad\ Leonfelden",
"436133", "Ebensee",
"432614", "Kleinwarasdorf",
"432843", "Dobersberg",
"432633", "Markt\ Piesting",
"437712", "Schärding",
"435556", "Schruns",
"433846", "Kalwang",
"433636", "Wildalpen",
"434354", "Preitenegg",
"432257", "Klausen\-Leopoldsdorf",
"433584", "Neumarkt\ in\ Steiermark",
"433140", "St\.\ Martin\ am\ Wöllmissberg",
"432953", "Nappersdorf",
"435246", "Achenkirch",
"432845", "Weikertschlag\ an\ der\ Thaya",
"432635", "Neunkirchen",
"432852", "Gmünd",
"436135", "Bad\ Goisern",
"4318", "Vienna",
"437215", "Hellmonsödt",
"434237", "Miklauzhof",
"437723", "Altheim",
"437412", "Ybbs\ an\ der\ Donau",
"437276", "Peuerbach",
"437479", "Ardagger",
"432165", "Hainburg\ a\.d\.\ Donau",
"435275", "Trins",
"433687", "Schladming",
"435472", "Prutz",
"436478", "Zederhaus",
"433477", "St\.\ Peter\ am\ Ottersbach",
"432815", "Grossschönau",
"433859", "Mürzsteg",
"434767", "Rothenthurn",
"437753", "Eberschwang",
"434286", "Weissbriach",
"432876", "Els",
"437442", "Waidhofen\ an\ der\ Ybbs",
"432822", "Zwettl\,\ Lower\ Austria",
"437245", "Lambach",
"435449", "Fliess",
"437252", "Steyr",
"432717", "Unter\-Meisling",
"433577", "Zeltweg",
"435273", "Matrei\ am\ Brenner",
"432278", "Absdorf",
"432163", "Petronell\-Carnuntum",
"432912", "Geras",
"437564", "Hinterstoder",
"437243", "Marchtrenk",
"435526", "Laterns",
"437947", "Kefermarkt",
"436217", "Mattsee",
"4313", "Vienna",
"433329", "Jennersdorf",
"437755", "Mettmach",
"437742", "Mattighofen",
"432662", "Gloggnitz",
"437764", "Riedau",
"432813", "Arbesbach",
"432644", "Grimmenstein",
"435572", "Dornbirn",
"432162", "Bruck\ an\ der\ Leitha",
"435272", "Steinach\ am\ Brenner",
"435475", "Feichten",
"432144", "Deutsch\ Jahrndorf",
"437279", "Haibach\ ob\ der\ Donau",
"435226", "Neustift\ im\ Stubaital",
"432913", "Hötzelsdorf",
"437264", "Windhaag\ bei\ Perg",
"435358", "Ellmau",
"437445", "Hollenstein\ an\ der\ Ybbs",
"432825", "Göpfritz\ an\ der\ Wild",
"437242", "Wels",
"437255", "Losenstein",
"433849", "Vordernberg",
"435573", "Hörbranz",
"432812", "Gross\ Gerungs",
"432663", "Schottwien",
"437743", "Maria\ Schmolln",
"436278", "Ostermiething",
"432915", "Drosendorf\-Zissersdorf",
"435559", "Brand",
"435473", "Nauders",
"433356", "Markt\ Allhau",
"437752", "Ried\ im\ Innkreis",
"436227", "St\.\ Gilgen",
"432688", "Steinbrunn",
"437745", "Lochen",
"435516", "Doren",
"432665", "Prein\ an\ der\ Rax",
"432527", "Wulzeshofen",
"435575", "Langen\ bei\ Bregenz",
"437253", "Wolfern",
"436417", "Hüttschlag",
"432823", "Grossglobnitz",
"434267", "Metnitz",
"437443", "Ybbsitz",
"432952", "Hollabrunn",
"433326", "Stegersbach",
"436471", "Tweng",
"432945", "Zellerndorf",
"432757", "Pöchlarn",
"4319", "Vienna",
"432853", "Schrems",
"437223", "Enns",
"435230", "Sellrain",
"437434", "Haag",
"437722", "Braunau\ am\ Inn",
"437413", "Marbach\ an\ der\ Donau",
"433136", "Dobl",
"432624", "Ebenfurth",
"432557", "Bernhardsthal",
"435256", "Untergurgl",
"435446", "St\.\ Anton\ am\ Arlberg",
"432247", "Deutsch\-Wagram",
"433856", "Veitsch",
"436547", "Kaprun",
"432943", "Obritz",
"433150", "Paldau",
"433174", "Birkfeld",
"437476", "Aschbach\-Markt",
"437212", "Zwettl\ an\ der\ Rodl",
"437415", "Altenmarkt\,\ Yspertal",
"432271", "Ried\ am\ Riederberg",
"432864", "Kautzen",
"437713", "Schardenberg",
"437734", "Hofkirchen\ an\ der\ Trattnach",
"432842", "Waidhofen\ an\ der\ Thaya",
"437225", "Hargelsberg",
"432632", "Pernitz",
"432855", "Waldenstein",
"436132", "Bad\ Ischl",
"433882", "Mariazell",
"432765", "Kaumberg",
"432754", "Loosdorf",
"435282", "Zell\ am\ Ziller",
"437289", "Rohrbach\ in\ Oberösterreich",
"433338", "Lafnitz",
"434212", "St\.\ Veit\ an\ der\ Glan",
"436462", "Bischofshofen",
"435583", "Lech",
"432554", "Stützenhofen",
"435675", "Tannheim",
"432627", "Pitten",
"434713", "Techendorf",
"434734", "Rennweg",
"435374", "Walchsee",
"434225", "Grafenstein",
"436562", "Mittersill",
"432244", "Langenzersdorf",
"432680", "St\.\ Margarethen\ im\ Burgenland",
"432262", "Korneuburg",
"436544", "Rauris",
"433141", "Hirschegg",
"433618", "Hohentauern",
"432986", "Irnfritz",
"432763", "St\.\ Veit\ an\ der\ Gölsen",
"434223", "Maria\ Saal",
"435336", "Alpbach",
"434715", "Kötschach\-Mauthen",
"433466", "Eibiswald",
"433177", "Puch\ bei\ Weiz",
"435673", "Ehrwald",
"435585", "Dalaas",
"433382", "Fürstenfeld",
"432214", "Kopfstetten",
"432233", "Pressbaum",
"435238", "Zirl",
"437586", "Pettenbach",
"437613", "Laakirchen",
"432732", "Krems\ an\ der\ Donau",
"432147", "Zurndorf",
"437267", "Mönchdorf",
"436232", "Mondsee",
"433861", "Aflenz",
"434253", "St\.\ Jakob\ im\ Rosental",
"432532", "Zistersdorf",
"437676", "Ottnang\ am\ Hausruck",
"434847", "Obertilliach",
"434279", "Sirnitz",
"437615", "Scharnstein",
"432235", "Maria\-Lanzendorf",
"432724", "Schwarzenbach\ an\ der\ Pielach",
"434264", "Klein\ St\.\ Paul",
"436414", "Grossarl",
"436433", "Dorfgastein",
"434255", "Arnoldstein",
"437954", "St\.\ Georgen\ am\ Walde",
"434242", "Villach",
"433184", "Wolfsberg\ im\ Schwarzautal",
"437486", "Lunz\ am\ See",
"436224", "Hintersee",
"433158", "St\.\ Anna\ am\ Aigen",
"432524", "Kautendorf",
"433684", "St\.\ Martin\ am\ Grimming",
"433536", "St\.\ Peter\ am\ Kammersberg",
"432735", "Hadersdorf\ am\ Kamp",
"433385", "Ilz",
"435339", "Wildschönau",
"433469", "St\.\ Oswald\ im\ Freiland",
"434243", "Bodensdorf",
"436235", "Thalgau",
"432989", "Brunn\ an\ der\ Wild",
"436432", "Bad\ Hofgastein",
"432535", "Hohenau\ an\ der\ March",
"433474", "Deutsch\ Goritz",
"433331", "St\.\ Lorenzen\ am\ Wechsel",
"432232", "Fischamend",
"433383", "Burgau",
"433574", "Pusterwald",
"432714", "Rossatz",
"432733", "Schönberg\ am\ Kamp",
"437612", "Gmunden",
"433148", "Kainach\ bei\ Voitsberg",
"437286", "Lembach\ im\ Mühlkreis",
"437767", "Eggerding",
"432647", "Krumbach\,\ Lower\ Austria",
"432533", "Neusiedl\ an\ der\ Zaya",
"433611", "Johnsbach",
"434252", "Wernberg",
"437944", "Sandl",
"436233", "Oberwang",
"436214", "Henndorf\ am\ Wallersee",
"434245", "Feistritz\ an\ der\ Drau",
"436470", "Atzmannsdorf",
"435285", "Mayrhofen",
"432263", "Grossrussbach",
"437489", "Purgstall\ an\ der\ Erlauf",
"436563", "Uttendorf",
"433885", "Greith",
"433868", "Tragöss",
"432762", "Lilienfeld",
"432744", "Kasten\ bei\ Böheimkirchen",
"437664", "Weyregg\ am\ Attersee",
"432617", "Drassmarkt",
"433118", "Sinabelkirchen",
"434215", "Liebenfels",
"436244", "Golling\ an\ der\ Salzach",
"434276", "Feldkirchen\ in\ Kärnten",
"435672", "Reutte",
"437237", "St\.\ Georgen\ an\ der\ Gusen",
"436454", "Mandling",
"433883", "Terz",
"434357", "St\.\ Paul\ im\ Lavanttal",
"436565", "Neukirchen\ am\ Grossvenediger",
"436588", "Lofer",
"432254", "Ebreichsdorf",
"433587", "Schönberg\-Lachtal",
"432265", "Hausleiten",
"433151", "Gnas",
"432288", "Auersthal",
"435283", "Kaltenbach",
"435582", "Klösterle",
"436463", "Annaberg\-Lungötz",
"434213", "Launsdorf",
"434234", "Ruden",
"434712", "Greifenburg",
"433461", "Trahütten",
"435331", "Brandenberg",
"435474", "Pfunds",
"432145", "Prellenkirchen",
"434843", "Ausservillgraten",
"433339", "Friedberg",
"437444", "Opponitz",
"437288", "Ulrichsberg",
"433146", "Modriach",
"437265", "Pabneukirchen",
"432824", "Allentsteig",
"437254", "Grossraming",
"432237", "Gaaden",
"432914", "Japons",
"437562", "Windischgarsten",
"435550", "Thüringen",
"432143", "Kittsee",
"434852", "Lienz",
"437617", "Traunkirchen",
"433366", "Kohfidisch",
"432664", "Semmering",
"437744", "Munderfing",
"432642", "Aspangberg\-St\.\ Peter",
"437762", "Raab",
"433619", "Oppenberg",
"435574", "Bregenz",
"437263", "Bad\ Zell",
"434257", "Fürnitz",
"434822", "Winklern",
"432944", "Haugsdorf",
"432767", "Hohenberg",
"434876", "Kals\ am\ Grossglockner",
"432286", "Obersiebenbrunn",
"432612", "Oberpullendorf",
"434227", "Ferlach",
"432863", "Eggern",
"437714", "Esternberg",
"437733", "Neumarkt\ im\ Hausruckkreis",
"435239", "Kühtai",
"437435", "St\.\ Valentin",
"437232", "St\.\ Martin\ im\ Mühlkreis",
"432625", "Bad\ Sauerbrunn",
"433173", "Ratten",
"435677", "Vils",
"433159", "Bad\ Gleichenberg",
"432176", "Tadten",
"435266", "Ötztal\-Bahnhof",
"433582", "Scheifling",
"434352", "Wolfsberg",
"433866", "Breitenau\ am\ Hochlantsch",
"433175", "Anger",
"432623", "Pottendorf",
"437414", "Weins\-Isperdorf",
"437433", "Wallsee",
"433116", "Kirchbach\ in\ Steiermark",
"437735", "Gaspoltshofen",
"434278", "Gnesau",
"432865", "Litschau",
"434717", "Steinfeld",
"437224", "St\.\ Florian",
"432854", "Kirchberg\ am\ Walde",
"437281", "Aigen\ im\ Mühlkreis",
"435510", "Damüls",
"434825", "Grosskirchheim",
"432954", "Göllersdorf",
"435287", "Tux",
"434353", "Prebl",
"432988", "Neupölla",
"433583", "Unzmarkt",
"433616", "Selzthal",
"435338", "Kundl",
"436467", "Mühlbach\ am\ Hochkönig",
"433468", "St\.\ Oswald\ ob\ Eibiswald",
"437432", "Strengberg",
"437724", "Mauerkirchen",
"437235", "Gallneukirchen",
"432622", "Wiener\ Neustadt",
"432615", "Lutzmannsburg",
"433585", "St\.\ Lambrecht",
"434355", "Gemmersdorf",
"432786", "Oberwölbling",
"434823", "Tresdorf\,\ Rangersdorf",
"432267", "Sierndorf",
"433336", "Waldbach",
"433149", "Geistthal",
"437732", "Haag\ am\ Hausruck",
"433126", "Frohnleiten",
"432862", "Heidenreichstein",
"432613", "Deutschkreutz",
"432634", "Gutenstein",
"432844", "Karlstein\ an\ der\ Thaya",
"436134", "Hallstatt",
"43732", "Linz",
"433172", "Weiz",
"437214", "Reichenthal",
"437233", "Feldkirchen\ an\ der\ Donau",
"437563", "Spital\ am\ Pyhrn",
"433387", "Söchau",
"432164", "Rohrau",
"435274", "Gries\ am\ Brenner",
"434853", "Ainet",
"433119", "St\.\ Marein\ bei\ Graz",
"432142", "Gattendorf",
"437763", "Kopfing\ im\ Innkreis",
"432643", "Lichtenegg",
"432814", "Langschlag",
"433869", "St\.\ Katharein\ an\ der\ Laming",
"437262", "Perg",
"437488", "Steinakirchen\ am\ Forst",
"437244", "Sattledt",
"434842", "Sillian",
"435236", "Gries\ im\ Sellrain",
"434855", "Assling",
"434271", "Steuerberg",
"437565", "St\.\ Pankraz",
"4346", "Klagenfurt",
"437588", "Ried\ im\ Traunkreis",
"4316", "Vienna",
"432289", "Matzen",
"434879", "St\.\ Veit\ in\ Defereggen",
"434247", "Afritz",
"436589", "Unken",
"437754", "Waldzell",
"432645", "Wiesmath",
"437765", "Lambrechten",
"433685", "Gröbming",
"433460", "Soboth",
"432167", "Neusiedl\ am\ See",
"432713", "Spitz",
"432734", "Langenlois",
"433573", "Fohnsdorf",
"432212", "Orth\ an\ der\ Donau",
"433358", "Litzelsdorf",
"436234", "Zell\ am\ Moos",
"437943", "Windhaag\ bei\ Freistadt",
"436213", "Oberhofen\ am\ Irrsee",
"435518", "Mellau",
"432686", "Drassburg",
"433631", "Unterlaussa",
"432534", "Niedersulz",
"437247", "Kematen\ am\ Innbach",
"433475", "Hürth",
"432722", "Kirchberg\ an\ der\ Pielach",
"435418", "Schönwies",
"433575", "St\.\ Johann\ am\ Tauern",
"432715", "Weissenkirchen\ in\ der\ Wachau",
"433516", "Kleinlobming",
"433683", "Donnersbach",
"437757", "Gurten",
"433182", "Wildon",
"433473", "Straden",
"435356", "Kitzbühel",
"432522", "Laa\ an\ der\ Thaya",
"434262", "Treibach",
"43662", "Salzburg",
"436276", "Nussdorf\ am\ Haunsberg",
"436412", "St\.\ Johann\ im\ Pongau",
"436215", "Strasswalchen",
"437945", "St\.\ Oswald\ bei\ Freistadt",
"432576", "Ernstbrunn",
"434244", "Bad\ Bleiberg",
"437952", "Weitersfelden",
"437355", "Weyer",
"435284", "Gerlos",
"435448", "Pettneu\ am\ Arlberg",
"4317", "Vienna",
"432957", "Hohenwarth",
"432253", "Oberwaltersdorf",
"433884", "Wegscheid",
"437665", "Unterach\ am\ Attersee",
"437480", "Langau\,\ Gaming",
"433858", "Mitterdorf\ im\ Mürztal",
"432745", "Pyhra",
"436479", "Muhr",
"432752", "Melk",
"434732", "Gmünd\ in\ Kärnten",
"4315", "Vienna",
"435372", "Kufstein",
"437478", "Oed\-Oehling",
"434233", "Griffen",
"434214", "Brückl",
"437727", "Ach",
"436245", "Hallein",
"432552", "Poysdorf",
"436455", "Untertauern",
"4314", "Vienna",
"432743", "Böheimkirchen",
"437663", "Steinbach\ am\ Attersee",
"433328", "Kukmirn",
"432255", "Deutsch\ Brodersdorf",
"436564", "Krimml",
"432242", "St\.\ Andrä\-Wördern",
"432264", "Rückersdorf\,\ Harmannsdorf",
"436542", "Zell\ am\ See",
"437353", "Gaflenz",
"437217", "St\.\ Veit\ im\ Mühlkreis",
"436453", "Filzmoos",
"436243", "Abtenau",
"434235", "Bleiburg",
"432279", "Kirchberg\ am\ Wagram",
"436137", "Strobl",
"432637", "Grünbach\ am\ Schneeberg",
"432847", "Gross\-Siegharts",
"437280", "Schwarzenberg\ am\ Böhmerwald",
"432764", "Hainfeld",
"437662", "Seewalchen\ am\ Attersee",
"432742", "St\.\ Pölten",
"433848", "Eisenerz",
"432755", "Mank",
"433638", "Palfau",
"436543", "Taxenbach",
"432947", "Theras",
"432243", "Klosterneuburg",
"435359", "Hochfilzen",
"435248", "Steinberg\ am\ Rofan",
"436242", "Russbach\ am\ Pass\ Gschütt",
"435674", "Bichlbach",
"432555", "Herrnbaumgarten",
"436452", "Radstadt",
"434735", "Kremsbrücke",
"437278", "Neukirchen\ am\ Walde",
"435375", "Kössen",
"434224", "Pischeldorf",
"437717", "St\.\ Aegidi",
"432252", "Baden",
"432245", "Wolkersdorf\ im\ Weinviertel",
"436545", "Bruck\ an\ der\ Grossglocknerstrasse",
"432753", "Gansbach",
"432689", "Hornstein",
"4312", "Vienna",
"435373", "Ebbs",
"433456", "Fresing",
"432857", "Bad\ Grosspertholz",
"434714", "Dellach\ im\ Drautal",
"434733", "Malta",
"437227", "Neuhofen\ an\ der\ Krems",
"435558", "Gaschurn",
"434232", "Völkermarkt",
"432276", "Reidling",
"432723", "Rabenstein\ an\ der\ Pielach",
"437471", "Neustadtl\ an\ der\ Donau",
"432215", "Probstdorf",
"433682", "Stainach",
"435477", "Tösens",
"432523", "Kirchstetten\,\ Neudorf\ bei\ Staatz",
"435441", "See",
"433472", "Mureck",
"433183", "St\.\ Georgen\ an\ der\ Stiefing",
"436223", "Anthering",
"434762", "Spittal\ an\ der\ Drau",
"437953", "Liebenau",
"436413", "Wagrain",
"437257", "Grünburg",
"436434", "Bad\ Gastein",
"434263", "Hüttenberg",
"432827", "Schönbach",
"433572", "Judenburg",
"432712", "Aggsbach",
"437614", "Vorchdorf",
"432213", "Lassee",
"432234", "Gramatneusiedl",
"432725", "Frankenfels",
"434265", "Weitensfeld\ im\ Gurktal",
"432878", "Traunstein",
"436415", "Schwarzach\ im\ Pongau",
"437942", "Freistadt",
"436212", "Seekirchen\ am\ Wallersee",
"434254", "Faak\ am\ See",
"436476", "St\.\ Margarethen\ im\ Lungau",
"437955", "Königswiesen",
"432667", "Schwarzau\ im\ Gebirge",
"437747", "Kirchberg\ bei\ Mattighofen",
"433185", "Preding",
"436225", "Eugendorf",
"435577", "Lustenau",
"432525", "Gnadendorf",
"433127", "Peggau",
"432628", "Felixdorf",
"435332", "Wörgl",
"433462", "Deutschlandsberg",
"434273", "Reifnitz",
"436566", "Bramberg\ am\ Wildkogel",
"432266", "Stockerau",
"433337", "Vorau",
"432982", "Horn",
"436466", "Werfenweng",
"434275", "Ebene\ Reichenau",
"437619", "Kirchham",
"432239", "Breitenfurt\ bei\ Wien",
"433178", "St\.\ Ruprecht\ an\ der\ Raab",
"433886", "Weichselboden",
"432641", "Kirchberg\ am\ Wechsel",
"435286", "Ginzling",
"43316", "Graz",
"433617", "Gaishorn\ am\ See",
"436274", "Lamprechtshausen",
"432769", "Türnitz",
"432574", "Gaweinstal",
"434246", "Radenthein",
"437482", "Scheibbs",
"435354", "Fieberbrunn",
"437285", "Hofkirchen\ im\ Mühlkreis",
"437268", "Grein",
"437672", "Vöcklabruck",
"433514", "Seckau",
"433533", "Turrach",
"432611", "Mannersdorf\ an\ der\ Rabnitz",
"432774", "Innermanzing",
"437231", "Herzogsdorf",
"434229", "Krumpendorf\ am\ Wörther\ See",
"437283", "Sarleinsbach",
"433157", "Kapfenstein",
"432684", "Schützen\ am\ Gebirge",
"432536", "Drösing",
"433581", "Oberwölz",
"433386", "Grosssteinbach",
"434848", "Kartitsch",
"437582", "Kirchdorf\ an\ der\ Krems",
"433535", "Krakaudorf",
"432736", "Paudorf",
"435289", "Häusling",
"437485", "Gaming",
"437282", "Neufelden",
"434256", "Nötsch\ im\ Gailtal",
"436474", "Tamsweg",
"432621", "Sieggraben",
"432236", "Mödling",
"436240", "Krispl",
"437675", "Ampflwang\ im\ Hausruckwald",
"437616", "Grünau\ im\ Almtal",
"437583", "Kremsmünster",
"433147", "Salla",
"432648", "Hochneukirchen",
"437483", "Oberndorf\ an\ der\ Melk",
"432269", "Niederfellabrunn",
"437585", "Klaus\ an\ der\ Pyhrnbahn",
"433532", "Murau",
"437673", "Schwanenstadt",
"434230", "Globasnitz",
"432274", "Sieghartskirchen",
"433171", "Gasen",
"434858", "Nikolsdorf",
"432618", "Markt\ St\.\ Martin",
"432739", "Tiefenfucha",
"435634", "Elbigenalp",
"433117", "Eggersdorf\ bei\ Graz",
"433454", "Leutschach",
"437238", "Mauthausen",
"435335", "Hopfgarten\ im\ Brixental",
"434716", "Lesachtal",
"433680", "Donnersbachwald",
"433465", "Pölfing\-Brunn",
"432985", "Gars\ am\ Kamp",
"432177", "Podersdorf\ am\ See",
"433867", "Pernegg\ an\ der\ Mur",
"437261", "Schönau\ im\ Mühlkreis",
"433463", "Stainz",
"435333", "Söll",
"434226", "St\.\ Margareten\ im\ Rosental",
"434272", "Pörtschach\ am\ Wörther\ See",
"435676", "Jungholz",
"432287", "Strasshof\ an\ der\ Nordbahn",
"434877", "Prägraten\ am\ Grossvenediger",
"432766", "Kleinzell",
"433588", "Katsch\ an\ der\ Mur",
"432983", "Sigmundsherberg",
"434358", "St\.\ Andrä",
"433457", "Gleinstätten",
"436458", "Hüttau",
"437226", "Wilhering",
"436484", "Lessach",
"432856", "Weitra",
"437475", "Hausmening\,\ Neuhofen\ an\ der\ Ybbs",
"432169", "Trautmannsdorf\ an\ der\ Leitha",
"435279", "St\.\ Jodok\ am\ Brenner",
"433133", "Nestelbach",
"437416", "Wieselburg",
"433114", "Markt\ Hartmannsdorf",
"437272", "Eferding",
"433842", "Leoben",
"433632", "St\.\ Gallen",
"433855", "Krieglach",
"432748", "Kilb",
"433864", "St\.\ Marein\ im\ Mürztal",
"433323", "Eberau",
"435242", "Schwaz",
"435255", "Umhausen",
"437249", "Bad\ Schallerbach",
"432174", "Wallern\ im\ Burgenland",
"435445", "Kappl",
"435264", "Mieming",
"433135", "Kalsdorf\ bei\ Graz",
"437473", "Blindenmarkt",
"434238", "Eisenkappel\-Vellach",
"437716", "Münzkirchen",
"435552", "Bludenz",
"433624", "Pichl\-Kainisch",
"435443", "Galtür",
"434874", "Virgen",
"432284", "Oberweiden",
"435253", "Längenfeld",
"432258", "Alland",
"436584", "Maria\ Alm\ am\ Steinernen\ Meer",
"436221", "Koppl",
"433325", "Heiligenkreuz\ im\ Lafnitztal",
"437759", "Antiesenhofen",
"432946", "Pulkau",
"437683", "Frankenburg\ am\ Hausruck",
"433853", "Spital\ am\ Semmering",
"434768", "Kleblach\-Lind",
"434785", "Ausserfragant",
"435522", "Feldkirch",
"436477", "St\.\ Michael\ im\ Lungau",
"43512", "Innsbruck",
"432959", "Sitzendorf\ an\ der\ Schmida",
"437746", "Friedburg",
"435515", "Au",
"432666", "Reichenau",
"435576", "Hohenems",
"437729", "Neukirchen\ an\ der\ Enknach",
"433355", "Stadtschlaining",
"432610", "Horitschon",
"433364", "Hannersdorf",
"435413", "St\.\ Leonhard\ im\ Pitztal",
"437230", "Altenberg\ bei\ Linz",
"432916", "Riegersburg\,\ Hardegg",
"435223", "Hall\ in\ Tirol",
"433688", "Tauplitz",
"437948", "Hirschbach\ im\ Mühlkreis",
"435513", "Hittisau",
"434282", "Hermagor",
"432872", "Ottenschlag",
"436541", "Saalbach",
"433144", "Köflach",
"434350", "Bad\ St\.\ Leonhard\ im\ Lavanttal",
"432826", "Rastenfeld",
"434783", "Reisseck",
"437256", "Ternberg",
"435225", "Fulpmes",
"432277", "Zwentendorf",
"432849", "Schwarzenau",
"432639", "Bad\ Fischau",
"432718", "Lichtenau\ im\ Waldviertel",
"433578", "Obdach",
"437219", "Vorderweissenbach",
"433353", "Oberschützen",
"435476", "Serfaus",
"435212", "Seefeld\ in\ Tirol",
"432873", "Kottes",
"432741", "Flinsbach",
"434283", "St\.\ Stefan\ im\ Gailtal",
"435512", "Egg",
"432949", "Niederfladnitz",
"435357", "Kirchberg\ in\ Tirol",
"434782", "Obervellach",
"436277", "St\.\ Pantaleon",
"435525", "Nenzing",
"432577", "Asparn\ an\ der\ Zaya",
"433834", "Wald\ am\ Schoberpass",
"432620", "Willendorf",
"437719", "Taufkirchen\ an\ der\ Pram",
"436241", "St\.\ Koloman",
"435213", "Scharnitz",
"435234", "Axams",
"433352", "Oberwart",
"435523", "Götzis",
"436228", "Faistenau",
"437246", "Gunskirchen",
"432687", "Siegendorf",
"432816", "Karlstift",
"436418", "Kleinarl",
"434268", "Friesach",
"434285", "Tröpolach",
"432875", "Grafenschlag",
"435412", "Imst",
"432166", "Parndorf",
"435276", "Gschnitz",
"432728", "Wienerbruck",
"434231", "Mittertrixen",
"437229", "Traun",
"433170", "Fischbach",
"432859", "Brand\-Nagelberg",
"437472", "Amstetten",
"437216", "Helfenberg",
"435553", "Raggal",
"433124", "Gratkorn",
"432846", "Raabs\ an\ der\ Thaya",
"432636", "Puchberg\ am\ Schneeberg",
"436136", "Gosau",
"433334", "Kaindorf",
"435245", "Hinterriss",
"435252", "Oetz",
"434761", "Stockenboi",
"432829", "Schweiggers",
"435442", "Landeck",
"437259", "Sierning",
"433845", "Mautern\ in\ Steiermark",
"433635", "Radmer",
"432758", "Pöggstall",
"433852", "Mürzzuschlag",
"437682", "Vöcklamarkt",
"432784", "Perschling",
"437260", "Waldhausen",
"433571", "Möderbrugg",
"432674", "Weissenbach\ an\ der\ Triesting",
"432711", "Dürnstein",
"437273", "Aschach\ an\ der\ Donau",
"433132", "Kumberg",
"432956", "Ziersdorf",
"433322", "Güssing",
"437941", "Neumarkt\ im\ Mühlkreis",
"433614", "Rottenmann",
"435579", "Alberschwende",
"433633", "Landl",
"433843", "St\.\ Michael\ in\ Obersteiermark",
"436548", "Niedernsill",
"432248", "Markgrafneusiedl",
"435243", "Maurach",
"435517", "Riezlern",
"437484", "Göstling\ an\ der\ Ybbs",
"437248", "Grieskirchen",
"436226", "Fuschl\ am\ See",
"435352", "St\.\ Johann\ in\ Tirol",
"432526", "Stronsdorf",
"434266", "Strassburg",
"436272", "Oberndorf\ bei\ Salzburg",
"436416", "Lend",
"432572", "Mistelbach",
"432749", "Prinzersdorf",
"435280", "Hochfügen",
"436475", "Ramingstein",
"437956", "Unterweissenbach",
"435278", "Navis",
"432726", "Puchenstuben",
"432168", "Mannersdorf\ am\ Leithagebirge",
"432273", "Tulbing",
"433357", "Pinkafeld",
"437674", "Attnang\-Puchheim",
"437711", "Suben",
"433512", "Knittelfeld",
"432772", "Neulengbach",
"436473", "Mariapfarr",
"432682", "Eisenstadt",
"437758", "Obernberg\ am\ Inn",
"432259", "Münchendorf",
"437584", "Molln",
"437221", "Hörsching",
"435417", "Roppen",
"434239", "St\.\ Kanzian\ am\ Klopeiner\ See",
"432275", "Atzenbrugg",
"432216", "Leopoldsdorf\ im\ Marchfelde",
"433689", "St\.\ Nikolai\ im\ Sölktal",
"437477", "St\.\ Peter\ in\ der\ Au",
"435635", "Elmen",
"433455", "Arnfels",
"437728", "Schwand\ im\ Innkreis",
"433464", "Gross\ St\.\ Florian",
"435334", "Westendorf",
"432984", "Eggenburg",
"435447", "Flirsch",
"432958", "Maissau",
"433857", "Neuberg\ an\ der\ Mürz",
"437251", "Schiedlberg",
"432246", "Gerasdorf\ bei\ Wien",
"434769", "Möllbrücke",
"436546", "Fusch\ an\ der\ Grossglocknerstrasse",
"434736", "Innerkrems",
"437218", "Grosstraberg",
"433453", "Ehrenhausen",
"435376", "Thiersee",
"435633", "Hägerau",
"436138", "St\.\ Wolfgang\ im\ Salzkammergut",
"433137", "Söding",
"433579", "Pöls",
"432848", "Pfaffenschlag\ bei\ Waidhofen",
"432638", "Winzendorf\-Muthmannsdorf",
"432719", "Dross",
"432556", "Grosskrut",
"434240", "Bad\ Kleinkirchheim",
"433327", "St\.\ Michael\ im\ Burgenland",
"436219", "Obertrum\ am\ See",
"437949", "Rainbach\ im\ Mühlkreis",
"432756", "St\.\ Leonhard\ am\ Forst",
"433452", "Leibnitz",
"437718", "Waldkirchen\ am\ Wesen",
"437277", "Waizenkirchen",
"435632", "Stanzach",
"434236", "Eberndorf",
"432256", "Leobersdorf",
"437241", "Steinerkirchen\ an\ der\ Traun",
"433847", "Trofaiach",
"433637", "Gams\ bei\ Hieflau",
"432948", "Weitersfeld",
"432858", "Moorbad\ Harbach",
"436246", "Grödig",
"437228", "Kematen\ an\ der\ Krems",
"432230", "Schwadorf",
"434274", "Velden\ am\ Wörther\ See",
"436456", "Obertauern",
"435557", "St\.\ Gallenkirch",
"434269", "Flattnitz",
"437751", "St\.\ Martin\ im\ Innkreis",
"437666", "Attersee",
"432746", "Wilhelmsburg",
"436229", "Hof\ bei\ Salzburg",
"432683", "Purbach\ am\ Neusiedler\ See",
"436216", "Neumarkt\ am\ Wallersee",
"437946", "Gutau",
"432951", "Guntersdorf",
"432575", "Ladendorf",
"436472", "Mauterndorf",
"437258", "Bad\ Hall",
"432828", "Rappottenstein",
"437448", "Kematen\ an\ der\ Ybbs",
"435355", "Jochberg",
"437284", "Oberkappel",
"434220", "Köttmannsdorf",
"433576", "Bretstein",
"432716", "Gföhl",
"433515", "St\.\ Lorenzen\ bei\ Knittelfeld",
"435353", "Waidring",
"432249", "Gross\-Enzersdorf",
"433476", "Bad\ Radkersburg",
"432877", "Grainbrunn",
"434766", "Millstatt",
"436549", "Piesendorf",
"435578", "Höchst",
"432573", "Wilfersdorf",
"432685", "Rust",
"437748", "Eggelsberg",
"432272", "Tulln\ an\ der\ Donau",
"437211", "Reichenau\ im\ Mühlkreis",
"433686", "Haus",
"434710", "Oberdrauburg",
"432773", "Eichgraben",
"432631", "Pöttsching",
"432841", "Vitis",
"436131", "Obertraun",
"433534", "Stadl\ an\ der\ Mur",
"433513", "Bischoffeld",
"432646", "Kirchschlag\ in\ der\ Buckligen\ Welt",
"437766", "Andorf",
"437287", "Peilstein\ im\ Mühlviertel",
"435524", "Satteins",
"433153", "Riegersburg",
"437566", "Rosenau\ am\ Hengstpass",
"436461", "Dienten\ am\ Hochkönig",
"432629", "Warth\,\ Lower\ Austria",
"433362", "Grosspetersdorf",
"433155", "Fehring",
"433142", "Voitsberg",
"434258", "Gummern",
"434284", "Kirchbach",
"432874", "Martinsberg",
"433537", "St\.\ Georgen\ ob\ Murau",
"433179", "Passail",
"432238", "Kaltenleutgeben",
"435214", "Leutasch",
"437618", "Neukirchen\,\ Altmünster",
"433833", "Traboch",
"434228", "Feistritz\ im\ Rosental",
"433112", "Gleisdorf",
"437274", "Alkoven",
"432731", "Idolsberg",
"432673", "Altenmarkt\ an\ der\ Triesting",
"433125", "Übelbach",
"435678", "Weissenbach\ am\ Lech",
"433335", "Pöllau",
"435244", "Jenbach",
"437269", "Baumgartenberg",
"432172", "Frauenkirchen",
"435262", "Telfs",
"437250", "Maria\ Neustift",
"433634", "Hieflau",
"433844", "Kammern\ im\ Liesingtal",
"433613", "Admont",
"433586", "Mühlen",
"434356", "Lavamünd",
"432768", "St\.\ Aegyd\ am\ Neuwalde",
"433862", "Bruck\ an\ der\ Mur",
"432616", "Lockenhaus",
"433123", "St\.\ Oswald\ bei\ Plankenwarth",
"435554", "Sonntag",
"434718", "Dellach",
"437236", "Pregarten",
"434277", "Glanegg",
"434826", "Mörtschach",
"432783", "Traismauer",
"433615", "Trieben",
"433622", "Bad\ Aussee",
"434872", "Huben",
"432282", "Gänserndorf",
"436582", "Saalfelden\ am\ Steinernen\ Meer",
"433333", "Sebersdorf",
"437736", "Pram",
"436468", "Werfen",
"433467", "Schwanberg",
"435337", "Brixlegg",
"432160", "Jois",
"437474", "Euratsfeld",
"433176", "Stubenberg",
"433115", "Studenzen",
"437684", "Frankenmarkt",
"433854", "Langenwang",
"437240", "Sipbachzell",
"432782", "Herzogenburg",
"433865", "Kindberg",
"433332", "Hartberg",
"436583", "Leogang",
"432987", "St\.\ Leonhard\ am\ Hornerwald",
"435254", "Sölden",
"434873", "St\.\ Jakob\ in\ Defereggen",
"432283", "Angern\ an\ der\ March",
"432175", "Apetlon",
"435265", "Nassereith",
"435288", "Fügen",
"435444", "Ischgl",
"433623", "Bad\ Mitterndorf",
"433134", "Heiligenkreuz\ am\ Waasen",
"433113", "Pischelsdorf\ in\ der\ Steiermark",
"432626", "Mattersburg",
"432231", "Purkersdorf",
"436483", "Göriach",
"432672", "Berndorf",
"435263", "Silz",
"432268", "Grossmugl",
"432173", "Gols",
"432285", "Marchegg",
"434875", "Matrei\ in\ Osttirol",
"437750", "Andrichsfurt",
"433863", "Turnau",
"433324", "Strem",
"432649", "Mönichkirchen",
"433612", "Liezen",
"434784", "Mallnitz",
"433143", "Krottendorf",
"432538", "Velm\-Götzendorf",
"437487", "Gresten",
"435514", "Bezau",
"434846", "Abfaltersbach",
"435232", "Kematen\ in\ Tirol",
"434221", "Gallizien",
"433354", "Bernstein",
"437239", "Lichtenberg",
"433365", "Deutsch\ Schützen\-Eisenberg",
"433832", "Kraubath\ an\ der\ Mur",
"432619", "Lackendorf",
"432738", "Fels\ am\ Wagram",
"434248", "Treffen",
"434359", "Reichenfels",
"433152", "Feldbach",
"433145", "Edelschrott",
"437266", "Bad\ Kreuzen",
"435224", "Wattens",
"433363", "Rechnitz",
"435414", "Wenns",
"437587", "Wartberg\ an\ der\ Krems",
"432630", "Ternitz",
"432146", "Nickelsdorf",};
$areanames{de} = {"434783", "Reißeck",
"434350", "Bad\ Sankt\ Leonhard\ im\ Lavanttal",
"437219", "Vorderweißenbach",
"436477", "Sankt\ Michael\ im\ Lungau",
"434785", "Außerfragant",
"435413", "Sankt\ Leonhard\ im\ Pitztal",
"435279", "Sankt\ Jodok\ am\ Brenner",
"433864", "Sankt\ Marein\ im\ Mürztal",
"433632", "Sankt\ Gallen",
"432674", "Weißenbach\ an\ der\ Triesting",
"433843", "Sankt\ Michael\ in\ Obersteiermark",
"435245", "Hinterriß",
"434283", "Sankt\ Stefan\ im\ Gailtal",
"436277", "Sankt\ Pantaleon",
"436241", "Sankt\ Koloman",
"433834", "Wald\ am\ Schoberpaß",
"433386", "Großsteinbach",
"433178", "Sankt\ Ruprecht\ an\ der\ Raab",
"434226", "Sankt\ Margareten\ im\ Rosental",
"434358", "Sankt\ Andrä",
"434877", "Prägraten\ am\ Großvenediger",
"432618", "Markt\ Sankt\ Martin",
"433123", "Sankt\ Oswald\ bei\ Plankenwarth",
"435678", "Weißenbach\ am\ Lech",
"432768", "Sankt\ Aegyd\ am\ Neuwalde",
"433537", "Sankt\ Georgen\ ob\ Murau",
"437566", "Rosenau\ am\ Hengstpaß",
"433362", "Großpetersdorf",
"432629", "Warth\,\ Niederösterreich",
"432268", "Großmugl",
"434873", "Sankt\ Jakob\ in\ Defereggen",
"432987", "Sankt\ Leonhard\ am\ Hornerwald",
"437218", "Großtraberg",
"432556", "Großkrut",
"432719", "Droß",
"436138", "Sankt\ Wolfgang\ im\ Salzkammergut",
"433327", "Sankt\ Michael\ im\ Burgenland",
"432756", "Sankt\ Leonhard\ am\ Forst",
"437477", "Sankt\ Peter\ in\ der\ Au",
"433689", "Sankt\ Nikolai\ im\ Sölktal",
"433464", "Groß\ Sankt\ Florian",
"436546", "Fusch\ an\ der\ Großglocknerstraße",
"434239", "Sankt\ Kanzian\ am\ Klopeiner\ See",
"435352", "Sankt\ Johann\ in\ Tirol",
"437956", "Unterweißenbach",
"434266", "Straßburg",
"432249", "Groß\-Enzersdorf",
"433515", "Sankt\ Lorenzen\ bei\ Knittelfeld",
"435557", "Sankt\ Gallenkirch",
"437751", "Sankt\ Martin\ im\ Innkreis",
"437954", "Sankt\ Georgen\ am\ Walde",
"436414", "Großarl",
"434264", "Klein\ Sankt\ Paul",
"433158", "Sankt\ Anna\ am\ Aigen",
"432233", "Preßbaum",
"434253", "Sankt\ Jakob\ im\ Rosental",
"432680", "Sankt\ Margarethen\ im\ Burgenland",
"432763", "Sankt\ Veit\ an\ der\ Gölsen",
"434212", "Sankt\ Veit\ an\ der\ Glan",
"436565", "Neukirchen\ am\ Großvenediger",
"434357", "Sankt\ Paul\ im\ Lavanttal",
"432263", "Großrußbach",
"433868", "Tragöß",
"432617", "Draßmarkt",
"437237", "Sankt\ Georgen\ an\ der\ Gusen",
"432647", "Krumbach\,\ Niederösterreich",
"433536", "Sankt\ Peter\ am\ Kammersberg",
"433684", "Sankt\ Martin\ am\ Grimming",
"433469", "Sankt\ Oswald\ im\ Freiland",
"433331", "Sankt\ Lorenzen\ am\ Wechsel",
"4313", "Wien",
"434286", "Weißbriach",
"432815", "Großschönau",
"433477", "Sankt\ Peter\ am\ Ottersbach",
"435449", "Fließ",
"432822", "Zwettl\-Niederösterreich",
"433140", "Sankt\ Martin\ am\ Wöllmißberg",
"4318", "Wien",
"437667", "Sankt\ Georgen\ im\ Attergau",
"432955", "Großweikersdorf",
"436247", "Großgmain",
"435446", "Sankt\ Anton\ am\ Arlberg",
"4319", "Wien",
"436227", "Sankt\ Gilgen",
"432823", "Großglobnitz",
"432812", "Groß\ Gerungs",
"4314", "Wien",
"432242", "Sankt\ Andrä\-Wördern",
"437217", "Sankt\ Veit\ im\ Mühlkreis",
"432847", "Groß\-Siegharts",
"4317", "Wien",
"4315", "Wien",
"432715", "Weißenkirchen\ in\ der\ Wachau",
"433575", "Sankt\ Johann\ am\ Tauern",
"436215", "Straßwalchen",
"437945", "Sankt\ Oswald\ bei\ Freistadt",
"436412", "Sankt\ Johann\ im\ Pongau",
"436276", "Nußdorf\ am\ Haunsberg",
"432686", "Draßburg",
"436476", "Sankt\ Margarethen\ im\ Lungau",
"433183", "Sankt\ Georgen\ an\ der\ Stiefing",
"436545", "Bruck\ an\ der\ Großglocknerstraße",
"4312", "Wien",
"432857", "Bad\ Großpertholz",
"432742", "Sankt\ Pölten",
"436242", "Rußbach\ am\ Paß\ Gschütt",
"437717", "Sankt\ Aegidi",
"437224", "Sankt\ Florian",
"434876", "Kals\ am\ Großglockner",
"437232", "Sankt\ Martin\ im\ Mühlkreis",
"437435", "Sankt\ Valentin",
"432642", "Aspangberg\-Sankt\ Peter",
"434843", "Außervillgraten",
"437254", "Großraming",
"437565", "Sankt\ Pankraz",
"434879", "Sankt\ Veit\ in\ Defereggen",
"4316", "Wien",
"433119", "Sankt\ Marein\ bei\ Graz",
"433869", "Sankt\ Katharein\ an\ der\ Laming",
"433585", "Sankt\ Lambrecht",
"434825", "Großkirchheim",
"433468", "Sankt\ Oswald\ ob\ Eibiswald",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+43|\D)//g;
      my $self = bless({ country_code => '43', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '43', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;