#!/usr/bin/perl

package eBay::API::XML::Call::SendInvoice;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. SendInvoice.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::SendInvoice

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::SendInvoice inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::SendInvoice::SendInvoiceRequestType;
use eBay::API::XML::Call::SendInvoice::SendInvoiceResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'SendInvoice';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::SendInvoice::SendInvoiceRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::SendInvoice::SendInvoiceResponseType';
}

#
# input properties
#

=head2 setCODCost()

Italy site (site ID 101) only.
Enables you to specify the cash-on-delivery (COD) cost, for COD shipping.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=CODInShippingDetails
Title: Specifying the Cash on Delivery Option in Shipping Details

  RequiredInput: No
#    Argument: 'ns:AmountType'

=cut
       
sub setCODCost {
   my $self   = shift;
   my $pCODCost = shift;
   $self->getRequestDataType()->setCODCost($pCODCost);
}

=head2 setCheckoutInstructions()

Seller's Payment instructions/message to the buyer and return policy.
Default is null.

MaxLength: 500

  RequiredInput: No
#    Argument: 'xs:string'

=cut
       
sub setCheckoutInstructions {
   my $self   = shift;
   my $sCheckoutInstructions = shift;
   $self->getRequestDataType()->setCheckoutInstructions($sCheckoutInstructions);
}

=head2 setEmailCopyToSeller()

Specifies whether the seller wishes to be copied on the invoice email that
will be sent to the buyer. Default will be true.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut
       
sub setEmailCopyToSeller {
   my $self   = shift;
   my $sEmailCopyToSeller = shift;
   $self->getRequestDataType()->setEmailCopyToSeller($sEmailCopyToSeller);
}

=head2 setInsuranceFee()

Insurance cost, as set by seller, if ShippingType = 1.
Specify if InsuranceOption is optional or required. Must
be greater than zero value if a value of Optional or Required is passed in
InsuranceOption. Value specified should be the total cost of insuring the
item.<br>
<br>
Not applicable to invoices for digital listings.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ShippingGettingCosts
Title: Determining Shipping Costs for a Listing
Default: 0.0

  RequiredInput: No
#    Argument: 'ns:AmountType'

=cut
       
sub setInsuranceFee {
   my $self   = shift;
   my $pInsuranceFee = shift;
   $self->getRequestDataType()->setInsuranceFee($pInsuranceFee);
}

=head2 setInsuranceOption()

Specifies whether insurance fee is required. An InsuranceOption value of
IncludedInShippingHandling cannot be used if the item will use calculated
shipping. Some shipping carriers automatically include shipping insurance
for qualifying items.<br>
<br>
Not applicable to invoices for digital listings.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ShippingGettingCosts
Title: Determining Shipping Costs for a Listing

  RequiredInput: No
  AllValuesExcept: NotOfferedOnSite
#    Argument: 'ns:InsuranceOptionCodeType'

=cut
       
sub setInsuranceOption {
   my $self   = shift;
   my $sInsuranceOption = shift;
   $self->getRequestDataType()->setInsuranceOption($sInsuranceOption);
}

=head2 setInternationalShippingServiceOptions()

If the buyer's shipping address is international, use this to offer up to
three shipping services, and omit all domestic ShippingServiceOptions. Any
shipping insurance cost specified should be the same for all services
offered.
<br><br>
Not applicable to invoices for digital listings.

  RequiredInput: No
#    Argument: reference to an array  
                      of 'ns:InternationalShippingServiceOptionsType'

=cut
       
sub setInternationalShippingServiceOptions {
   my $self   = shift;
   my $pInternationalShippingServiceOptions = shift;
   $self->getRequestDataType()->setInternationalShippingServiceOptions($pInternationalShippingServiceOptions);
}

=head2 setItemID()

Item ID. If OrderID is not provided, both ItemID and
TransactionID must be provided.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, Item IDs are usually 9 to 12 digits)

  RequiredInput: Conditionally
#    Argument: 'ns:ItemIDType'

=cut
       
sub setItemID {
   my $self   = shift;
   my $pItemID = shift;
   $self->getRequestDataType()->setItemID($pItemID);
}

=head2 setOrderID()

Unique ID for a multi-item order. Either this OrderID must
be specified or ItemID plus TransactionID must be specified.
If OrderID is specified, ItemID and
TransactionID are ignored if present in the same request. Changes to the
checkout status are applied to the specified order as a whole
(and thus to the child transactions associated with the order).

  RequiredInput: Conditionally
#    Argument: 'ns:OrderIDType'

=cut
       
sub setOrderID {
   my $self   = shift;
   my $pOrderID = shift;
   $self->getRequestDataType()->setOrderID($pOrderID);
}

=head2 setPayPalEmailAddress()

Provide PayPal email address if the payment method added is PayPal.
For digital listings, this must be an email address associated with
a verified PayPal Premier or Business account.

  RequiredInput: No
#    Argument: 'xs:string'

=cut
       
sub setPayPalEmailAddress {
   my $self   = shift;
   my $sPayPalEmailAddress = shift;
   $self->getRequestDataType()->setPayPalEmailAddress($sPayPalEmailAddress);
}

=head2 setPaymentMethods()

Optional ability for the seller to add certain payment methods on
transaction if they were not originally specified on the item.  Valid
values are PayPal in the US, and MoneyXferAcceptedInCheckout (CIP+) in
Germany.

  RequiredInput: No
#    Argument: reference to an array  
                      of 'ns:BuyerPaymentMethodCodeType'

=cut
       
sub setPaymentMethods {
   my $self   = shift;
   my $sPaymentMethods = shift;
   $self->getRequestDataType()->setPaymentMethods($sPaymentMethods);
}

=head2 setSalesTax()

The details of the sales tax added to the invoice.

  RequiredInput: No
#    Argument: 'ns:SalesTaxType'

=cut
       
sub setSalesTax {
   my $self   = shift;
   my $pSalesTax = shift;
   $self->getRequestDataType()->setSalesTax($pSalesTax);
}

=head2 setShippingServiceOptions()

If the buyer's shipping address is domestic, use this to offer up to
three shipping services, and omit all InternationalShippingServiceOptions. Any
shipping insurance cost specified should be the same for all services
offered.
<br><br>
Not applicable to invoices for digital listings.

  RequiredInput: No
#    Argument: reference to an array  
                      of 'ns:ShippingServiceOptionsType'

=cut
       
sub setShippingServiceOptions {
   my $self   = shift;
   my $pShippingServiceOptions = shift;
   $self->getRequestDataType()->setShippingServiceOptions($pShippingServiceOptions);
}

=head2 setTransactionID()

ID for the transaction with which the item was sold.
If OrderID is not provided, both ItemID and
TransactionID must be provided.
For Chinese auctions, the value passed in the TransactionId
argument must be 0 or the call will fail with an error.
Call GetItemTransactions or GetSellerTransactions to
determine the correct transaction ID.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, transaction IDs are usually 9 to 12 digits.)

  RequiredInput: Conditionally
#    Argument: 'xs:string'

=cut
       
sub setTransactionID {
   my $self   = shift;
   my $sTransactionID = shift;
   $self->getRequestDataType()->setTransactionID($sTransactionID);
}



#
# output properties
#





1;   
