/*
 * Decompiled with CFR 0.152.
 */
package opennlp.common.xml;

import java.io.File;
import java.io.IOException;
import opennlp.common.xml.ValidityErrorHandler;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SchemaBasedValidator {
    private SAXParser parser = new SAXParser();
    private ValidityErrorHandler errorTracker = new ValidityErrorHandler();
    private boolean isVerbose = true;
    private File schema;

    public SchemaBasedValidator(File _schema) {
        this.parser.setErrorHandler((ErrorHandler)this.errorTracker);
        this.schema = _schema;
        try {
            this.parser.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", (Object)this.schema.getAbsolutePath());
            SAXParser reader = this.parser;
            reader.setFeature("http://xml.org/sax/features/validation", true);
            reader.setFeature("http://xml.org/sax/features/namespaces", true);
            reader.setFeature("http://apache.org/xml/features/validation/schema", true);
            reader.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
        }
        catch (Exception exception) {}
    }

    public SchemaBasedValidator(File schema, boolean _isVerbose) {
        this(schema);
        this.isVerbose = _isVerbose;
        this.errorTracker.setVerbose(this.isVerbose);
    }

    public boolean checkValidity(String file) throws IOException {
        InputSource xmlToValidate = new InputSource(file);
        this.errorTracker.reset();
        try {
            this.parser.reset();
        }
        catch (Exception e) {
            System.err.println("Unable to reset validator: " + e.getMessage());
        }
        try {
            this.parser.parse(xmlToValidate);
        }
        catch (SAXException sAXException) {}
        int numErrors = this.errorTracker.getNumOfErrors();
        if (numErrors == 0) {
            this.printMessage("'" + file + "' is valid with repect to schema '" + this.schema.getName() + "'.");
            return true;
        }
        if (numErrors == 1) {
            this.printMessage("\n1 error found in '" + file + "'.");
        } else {
            this.printMessage("\n" + numErrors + " error(s) found in '" + file + "'.");
        }
        return false;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.out.println("Usage: java opennlp.common.xml.SchemaBasedValidator 'schema-file' 'file-to-validate'");
            return;
        }
        SchemaBasedValidator validator = new SchemaBasedValidator(new File(args[0]));
        validator.checkValidity(args[1]);
    }

    private void printMessage(String message) {
        if (this.isVerbose) {
            System.out.println(message);
        }
    }

    public void setVerbose(boolean _isVerbose) {
        this.isVerbose = _isVerbose;
        this.errorTracker.setVerbose(this.isVerbose);
    }
}

