#!perl
#
#
package  Docs::US_DOD::IDD;

use strict;
use warnings;
use warnings::register;

use vars qw($VERSION $DATE);
$VERSION = '1.07';
$DATE = '2003/09/15';

use vars qw($IDENTIFICATION_NUMBER $TITLE $REVISION $REVISION_DATE);
$IDENTIFICATION_NUMBER  = 'DI-IPSC-81436';
$TITLE = 'Interface Design Document (IDD)';
$REVISION = '-';
$REVISION_DATE = '12/05/1994';

1


__END__

=head1 DATA ITEM DESCRIPTION

The following establishes the data general and content
requirements for the identified data item. 

=head1 1. TITLE

Interface Design Document (IDD)

=head1 2. IDENTIFICATION NUMBER

DI-IPSC-81436

=head1 3. DESCRIPTION/PURPOSE

=head2 3.1

The Interface Design Description (IDD) describes the interface
characteristics of one or more systems, subsystems, Hardware Configuration
Items (HWCIs), Computer Software Configuration Items (CSCIs),
manual operations, or other system components. An IDD may describe
any number of interfaces.

=head2 3.2

The IDD can be used to supplement the System/Subsystem Design
Description (SSDD) (DIIPSC-81432), Software Design Description
(SDD) (DI-IPSC-81435), and Database Design Description (DBDD)
(DI-IPSC-81437). The IDD and its companion Interface Requirements
Specification (IRS) (DI-IPSC-81434) serve to communicate and control
interface design decisions.

=head1 4. APPROVAL DATE (YYMMDD)

941205

=head1 5. OFFICE OF PRIMARY RESPONSIBILITY

EC

6a. DTIC APPLICABLE

6b. GIDEP APPLICABLE

=head1 7. APPLICATION/INTERRELATIONSHIP

=head2 7.1 

This Data Item Description (DID) contains the format and content
preparation instructions for the data product generated by specific
and discrete task requirements as delineated in the contract.

=head2 7.2 

This DID is used when the developer is tasked to define and
record the interface design of one or more systems, subsystems,
HWCIs, CSCIs, manual operations, or other system components.

=head2 7.3

The IRS specifies interface requirements; the IDD describes
interface characteristics selected to meet those requirements.
The IDD may reference the IRS to avoid repeating information.
The IDD can be used to supplement the SSDD, SDD, or DBDD.

=head2 7.4 

The Contract Data Requirements List (CDRL) (DD 1423) should
specify whether deliverable data are to be delivered on paper
or electronic media; are to be in a given electronic form (such
as ASCII, CALS, or compatible with a specified word processor
or other support software); may be delivered in developer format
rather than in the format specified herein; and may reside in
a computer-aided software engineering (CASE) or other automated
tool rather than in the form of a traditional document.

=head2 7.5 

This DID supersedes DI-MCCR-80027A.

=head1 8. APPROVAL LIMITATION

Limited Approval from 12/5/94 through 12/5/96

9a. APPLICABLE FORMS

9b. AMSC NUMBER

N7079

=head1 10. PREPARATION INSTRUCTIONS

=head2 10.1 General instructions.

=over 4

=item a. Automated techniques.

Use of automated techniques is
encouraged. The term 'document' in this DID means a
collection of data regardless of its medium.

=item b. Alternate presentation styles. 

Diagrams, tables, matrices,
and other presentation styles are acceptable substitutes for text
when data required by this DID can be made more readable using
these styles

=item c. Title page or identifier with signature blocks.

The document shall include a title page containing, as applicable:
document number; volume number; version/revision indicator; security
markings or other restrictions on the handling of the document;
date; document title; name, abbreviation, and any other identifier
for the systems, subsystems, or items to which the document applies;
contract number; CDRL item number; organization for which the
document has been prepared; name and address of the preparing
organization; distribution statement; and signature blocks for
the developer representative authorized to release the document,
the acquirer representative authorized to approve the document,
and the dates of release/approval. For data in a database or other
alternative form, this information shall be included on external
and internal labels or by equivalent identification methods.

=item d. Table of contents. 

The document shall contain a table
of contents providing the number, title, and page number of each
titled paragraph, figure, table, and appendix. For data in a database
or other alternative form, this information shall consist of an
internal or external table of contents containing pointers to,
or instructions for accessing, each paragraph, figure, table,
and appendix or their equivalents.

=item  e. Page numbering/labeling. 

Each page shall contain a unique
page number and display the document number, including version,
volume, and date, as applicable. For data in a database or other
alternative form, files, screens, or other entities shall be assigned
names or numbers in such a way that desired data can be indexed
and accessed.

=item f. Response to tailoring instructions.

If a paragraph is
tailored out of this DID, the resulting document shall contain
the corresponding paragraph number and title, followed by &quot;This
paragraph has been tailored out.&quot; For data in a database
or other alternative form, this representation need occur only
in the table of contents or equivalent.

=item g. Multiple paragraphs and subparagraphs.

Any section,
paragraph, or subparagraph in this DID may be written as multiple
paragraphs or subparagraphs to enhance readability.

=item h. Standard data descriptions.

If a data description required
by this DID has been published in a standard data element dictionary
specified in the contract, reference to an entry in that dictionary
is preferred over including the description itself.

=item i. Substitution of existing documents.

Commercial or other existing documents may be substituted for all or part of the document
if they contain the required data.

=back

=head2 10.2 Content requirements.

Content requirements begin on the following page. The numbers
shown designate the paragraph numbers to be used in the document.
Each such number is understood to have the prefix '10.2'
within this DID. For example, the paragraph numbered 1.1 is understood
to be paragraph 10.2.1.1 within this DID.

=head2 1. Scope<

This section shall be divided into the following paragraphs.

=head2 1.1 Identification.

This paragraph shall contain a full identification of the system(s),
the interfacing entities, and interfaces to which this document
applies, including, as applicable, identification number(s), title(s),
abbreviation(s), version number(s), and release number(s).

=head2 2.2 System overview.

This paragraph shall briefly state the purpose of the system(s)
and software to which this document applies. It shall describe
the general nature of the system and software; summarize the history
of system development, operation, and maintenance; identify the
project sponsor, acquirer, user, developer, and support agencies;
identify current and planned operating sites; and list other relevant
documents.

=head2 1.3 Document overview.

This paragraph shall summarize the purpose and contents of this
document and shall describe any security or privacy considerations
associated with its use.

=head2 2. Referenced documents.

This section shall list the number, title, revision, and date
of all documents referenced in this document. This section shall
also identify the source for all documents not available through
normal Government stocking activities.

=head2 3. Interface design.

This section shall be divided into the following paragraphs to
describe the interface characteristics of one or more systems,
subsystems, configuration items, manual operations, or other system
components. If part or all of the design depends upon system states
or modes, this dependency shall be indicated. If design information
falls into more than one paragraph, it may be presented once and
referenced from the other paragraphs. If part or all of this information
is documented elsewhere, it may be referenced. Design conventions
needed to understand the design shall be presented or referenced.

=head2 3.1 Interface identification and diagrams.

For each interface identified in 1.1, this paragraph shall state
the project-unique identifier assigned to the interface and shall
identify the interfacing entities (systems, configuration items,
users, etc.) by name, number, version, and documentation references,
as applicable. The identification shall state which entities have
fixed interface characteristics (and therefore impose interface
requirements on interfacing entities) and which are being developed
or modified (thus having interface requirements imposed on them).
One or more interface diagrams shall be provided, as appropriate,
to depict the interfaces.

=head2 3.x (Project-unique identifier of interface).

This paragraph (beginning with 3.2) shall identify an interface
by project-unique identifier, shall briefly identify the interfacing
entities, and shall be divided into subparagraphs as needed to
describe the interface characteristics of one or both of the interfacing
entities. If a given interfacing entity is not covered by this
IDD (for example, an external system) but its interface characteristics
need to be mentioned to describe interfacing entities that are,
these characteristics shall be stated as assumptions or as &quot;When
[the entity not covered] does this, [the entity that is covered]
will ....&quot; This paragraph may reference other documents (such
as data dictionaries, standards for protocols, and standards for
user interfaces) in place of stating the information here. The
design description shall include the following, as applicable,
presented in any order suited to the information to be provided,
and shall note any differences in these characteristics from the
point of view of the interfacing entities (such as different expectations
about the size, frequency, or other characteristics of data elements):

=over

=item 1

Priority assigned to the interface by the interfacing entity(ies)

=item 2

Type of interface (such as real-time data transfer, storage-and-retrieval
of data, etc.) to be implemented

=item 3 

Characteristics of individual data elements that the interfacing
entity(ies) will provide, store, send, access, receive, etc.,
such as:

=over 4

=item *

Names/identifiers

=over 4

=item 1

Project-unique identifier

=item 2

Non-technical (natural-language) name

=item 3

DoD standard data element name

=item 4 

Technical name (e.g., variable or field name in code or database)

=item 5

Abbreviation or synonymous names

=back 

=item *

Data type (alphanumeric, integer, etc.)

=item *

Size and format (such as length and punctuation of a character
string)

=item *

Units of measurement (such as meters, dollars, nanoseconds)

=item *

Range or enumeration of possible values (such as 0-99)

=item *

Accuracy (how correct) and precision (number of significant
digits)

=item *

Priority, timing, frequency, volume, sequencing, and other
constraints, such as whether the data element may be updated and
whether business rules apply

=item *

Security and privacy constraints

=item *

Sources (setting/sending entities) and recipients (using/receiving
entities)

=back

=item 4

Characteristics of data element assemblies (records, messages,
files, arrays, displays, reports, etc.) that the interfacing entity(ies)
will provide, store, send, access, receive, etc., such as:

=over 4

=item *

Names/identifiers

=over 4

=item 1

Project-unique identifier

=item 2 

Non-technical (natural language) name

=item 3 

Technical name (e.g., record or data structure name in
code or database)

=item 4

Abbreviations or synonymous names

=back

=item *

Data elements in the assembly and their structure (number,
order, grouping)

=item *

Medium (such as disk) and structure of data elements/assemblies
on the medium

=item *

Visual and auditory characteristics of displays and other
outputs (such as colors, layouts, fonts, icons and other display
elements, beeps, lights)

=item *

Relationships among assemblies, such as sorting/access
characteristics

=item *

Priority, timing, frequency, volume, sequencing, and other
constraints, such as whether the assembly may be updated and whether
business rules apply

=item *

Security and privacy constraints

=item *

Sources (setting/sending entities) and recipients (using/receiving
entities)

=back

=item 5

Characteristics of communication methods that the interfacing
entity(ies) will use for the interface, such as:

=over 4

=item *

Project-unique identifier(s)

=item *

Communication links/bands/frequencies/media and their characteristics

=item *

Message formatting

=item *

Flow control (such as sequence numbering and buffer allocation)

=item *

Data transfer rate, whether periodic/aperiodic, and interval
between transfers

=item *

Routing, addressing, and naming conventions

=item *

Transmission services, including priority and grade

=item * 

Safety/security/privacy considerations, such as encryption,
user authentication, compartmentalization, and auditing

=back

=item 6

Characteristics of protocols the interfacing entity(ies) will
use for the interface, such as:

=over 4

=item *

Project-unique identifier(s)

=item *

Priority/layer of the protocol

=item *

 Packeting, including fragmentation and reassembly, routing,
and addressing

=item *

 Legality checks, error control, and recovery procedures

=item *

Synchronization, including connection establishment, maintenance,
termination

=item *

Status, identification, and any other reporting features

=back

=item 7

Other characteristics, such as physical compatibility of the
interfacing entity(ies) (dimensions, tolerances, loads, voltages,
plug compatibility, etc.)

=back

=head2 4. Requirements traceability.

This paragraph shall contain: 

=over

=item 1

Traceability from each interfacing
entity covered by this IDD to the system or CSCI requirements
addressed by the entity's interface design.

=item 2

Traceability from each system or CSCI requirement that affects an interface covered
in this IDD to the interfacing entities that address it.

=back

=head1 5. Notes.

This section shall contain any general information that aids in
understanding this document (e.g., background information, glossary,
rationale). This section shall include an alphabetical listing
of all acronyms, abbreviations, and their meanings as used in
this document and a list of any terms and definitions needed to
understand this document.

=head1 A. Appendixes.

Appendixes may be used to provide information published separately
for convenience in document maintenance (e.g., charts, classified
data). As applicable, each appendix shall be referenced in the
main body of the document where the data would normally have been
provided. Appendixes may be bound as separate documents for ease
in handling. Appendixes shall be lettered alphabetically (A, B,
etc.). 




## end of file ##
