# Generated by default/object.tt
package Paws::S3::DeleteMarkerReplication;
  use Moose;
  has Status => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::S3::DeleteMarkerReplication

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::S3::DeleteMarkerReplication object:

  $service_obj->Method(Att1 => { Status => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::S3::DeleteMarkerReplication object:

  $result = $service_obj->Method(...);
  $result->Att1->Status

=head1 DESCRIPTION

Specifies whether Amazon S3 replicates delete markers. If you specify a
C<Filter> in your replication configuration, you must also include a
C<DeleteMarkerReplication> element. If your C<Filter> includes a C<Tag>
element, the C<DeleteMarkerReplication> C<Status> must be set to
Disabled, because Amazon S3 does not support replicating delete markers
for tag-based rules. For an example configuration, see Basic Rule
Configuration
(https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-config-min-rule-config).

For more information about delete marker replication, see Basic Rule
Configuration
(https://docs.aws.amazon.com/AmazonS3/latest/dev/delete-marker-replication.html).

If you are using an earlier version of the replication configuration,
Amazon S3 handles replication of delete markers differently. For more
information, see Backward Compatibility
(https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-backward-compat-considerations).

=head1 ATTRIBUTES


=head2 Status => Str

Indicates whether to replicate delete markers.

Indicates whether to replicate delete markers.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::S3>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

