package YAML::Manual;
use 5.005003;
use strict;
$YAML::Manual::VERSION = '0.10';

1;

=encoding utf8

=head1 NAME

YAML::Manual - Documentation for YAML within Perl

=head1 SYNOPSIS

    > perldoc YAML::Manual
    > perldoc YAML::Manual::SpecificTopic

=head1 DESCRIPTION

Using YAML within Perl is a rich topic. This set of manuals will help
you understand all the things you need to know to use YAML effectively
in Perl and beyond.

=head1 TABLE OF CONTENTS

This manual is divided up into many POD files. Here is a top level view
of the contents of this manual:

=over

=item L<YAML::Manual::Intro> - Introduction to YAML in Perl.

=item L<YAML::Manual::Modules> - Comparison of the YAML Perl modules.

=item L<YAML::Manual::Syntax> - Detailed explanation of the YAML syntax.

=item L<YAML::Manual::RefCard> - Handy reference card of the YAML syntax.

=item L<YAML::Manual::FAQ> - Fortuitously Answered Questions about YAML.

=item L<YAML::Manual::Usage> - Perl APIs for YAML modules.

=item L<YAML::Manual::Tutorial> - Soup to nuts tutorial for YAML in Perl.

=item L<YAML::Manual::Cookbook> - Recipes for your everyday YAML dishes.

=item L<YAML::Manual::RoadMap> - Guide to the future of YAML in Perl.

=back

=head1 AUTHOR

Ingy döt Net <ingy@cpan.org>

=head1 COPYRIGHT

Copyright (c) 2008. Ingy döt Net.

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

See http://www.perl.com/perl/misc/Artistic.html

=cut
