#
# Patch given file with DATA hunks and print to STDOUT.
#
#
# Patching types in pack.c.
#
use strict;
use warnings;
use Text::Patch 'patch';

my $in = $ARGV[0];

my ($txt, $patch);
{
    local $/;
    open my $fh, '<', $in or die "open: $in: $!";
    $txt   = <$fh>;
    $patch = <DATA>;
}

#print $txt;
#print $patch;
#exit;

my $out = patch( $txt, $patch, STYLE => 'Unified' );

print $out;
exit 0;

__END__
diff -aurN usrcP/uuid/pack.c usrcP.targ/uuid/pack.c
--- usrcP/uuid/pack.c	2023-12-02 17:58:13.891969000 +0200
+++ usrcP.targ/uuid/pack.c	2023-12-02 15:28:29.183074000 +0200
@@ -38,7 +38,7 @@
 
 void uuid_pack(const struct uuid *uu, uuid_t ptr)
 {
-	uint32_t	tmp;
+	myuint32_t	tmp;
 	unsigned char	*out = ptr;
 
 	tmp = uu->time_low;
