/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.poi.common.usermodel.fonts.FontInfo;
import org.apache.poi.hslf.record.FontEntityAtom;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.RecordContainer;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.hslf.usermodel.HSLFFontInfo;

public final class FontCollection
extends RecordContainer {
    private final Map<String, HSLFFontInfo> fonts = new LinkedHashMap<String, HSLFFontInfo>();
    private byte[] _header = new byte[8];

    protected FontCollection(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        for (Record r : this._children = Record.findChildRecords(source, start + 8, len - 8)) {
            if (r instanceof FontEntityAtom) {
                HSLFFontInfo fi = new HSLFFontInfo((FontEntityAtom)r);
                this.fonts.put(fi.getTypeface(), fi);
                continue;
            }
            logger.log(5, "Warning: FontCollection child wasn't a FontEntityAtom, was " + r.getClass().getSimpleName());
        }
    }

    @Override
    public long getRecordType() {
        return RecordTypes.FontCollection.typeID;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        this.writeOut(this._header[0], this._header[1], this.getRecordType(), this._children, out);
    }

    public HSLFFontInfo addFont(FontInfo fontInfo) {
        HSLFFontInfo fi = this.getFontInfo(fontInfo.getTypeface());
        if (fi != null) {
            return fi;
        }
        fi = new HSLFFontInfo(fontInfo);
        fi.setIndex(this.fonts.size());
        this.fonts.put(fi.getTypeface(), fi);
        FontEntityAtom fnt = fi.createRecord();
        this.appendChildRecord(fnt);
        return fi;
    }

    public HSLFFontInfo getFontInfo(String typeface) {
        return this.fonts.get(typeface);
    }

    public HSLFFontInfo getFontInfo(int index) {
        for (HSLFFontInfo fi : this.fonts.values()) {
            if (fi.getIndex() != index) continue;
            return fi;
        }
        return null;
    }

    public int getNumberOfFonts() {
        return this.fonts.size();
    }
}

