package Graphics::ColorNamesCMYK::ToutesLesCouleursCom::Red;

use strict;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-05-06'; # DATE
our $DIST = 'Graphics-ColorNamesCMYK-ToutesLesCouleursCom'; # DIST
our $VERSION = '0.001'; # VERSION

our $NAMES_CMYK_TABLE = {
  'red' => 0x00646400, # 0,100,100,0
  'amarante' => 0x00483b2b, # 0,72,59,43
  'bordeaux' => 0x005e4c39, # 0,94,76,57
  'brick' => 0x00415030, # 0,65,80,48
  'cherry' => 0x005e5e1b, # 0,94,94,27
  'reef' => 0x00496409, # 0,73,100,9
  'scarlet' => 0x00646407, # 0,100,100,7
  'strawberry' => 0x004b4b19, # 0,75,75,25
  'strawberry crushed' => 0x004e4e24, # 0,78,78,36
  'raspberry' => 0x004e4016, # 0,78,64,22
  'fuchsia' => 0x004b2a01, # 0,75,42,1
  'grenadine' => 0x004c4909, # 0,76,73,9
  'garnet' => 0x005a5239, # 0,90,82,57
  'watermelon' => 0x00292500, # 0,41,37,0
  'crimson' => 0x00383300, # 0,56,51,0
  'magenta' => 0x00640000, # 0,100,0,0
  'dark magenta' => 0x00640032, # 0,100,0,50
  'magenta fuchsia' => 0x00642f0e, # 0,100,47,14
  'purple' => 0x002e0011, # 0,46,0,17
  'nacarat' => 0x003f3f01, # 0,63,63,1
  'red ochre' => 0x001f3a0d, # 0,31,58,13
  'pass velvet' => 0x00483b2b, # 0,72,59,43
  'purple' => 0x005b3b26, # 0,91,59,38
  'prune' => 0x00542431, # 0,84,36,49
  'hot pink' => 0x00643200, # 0,100,50,0
  'alizarin red' => 0x00606416, # 0,96,100,22
  'english red' => 0x00565f03, # 0,86,95,3
  'red bismarck' => 0x004d5e23, # 0,77,94,35
  'red burgundy' => 0x0058583a, # 0,88,88,58
  'red nasturtium' => 0x003f4600, # 0,63,70,0
  'cardinal red' => 0x00535b1c, # 0,83,91,28
  'carmine red' => 0x00645429, # 0,100,84,41
  'red cinnabar' => 0x0059630e, # 0,89,99,14
  'red cinnabar' => 0x00485501, # 0,72,85,1
  'red poppy' => 0x00606416, # 0,96,100,22
  'crimson' => 0x00645429, # 0,100,84,41
  'crimson' => 0x005b490e, # 0,91,73,14
  'red adrianople' => 0x005a6322, # 0,90,99,34
  'red aniline' => 0x00646408, # 0,100,100,8
  'red gong' => 0x00515132, # 0,81,81,50
  'march rouge' => 0x00565f03, # 0,86,95,3
  'red crayfish' => 0x0053631a, # 0,83,99,26
  'red fire' => 0x00596400, # 0,89,100,0
  'red fire' => 0x00476400, # 0,71,100,0
  'red madder' => 0x005d5d07, # 0,93,93,7
  'red currant' => 0x005f5613, # 0,95,86,19
  'red culvert' => 0x00606416, # 0,96,100,22
  'ruby red' => 0x005c3a0c, # 0,92,58,12
  'red blood' => 0x005f5f30, # 0,95,95,48
  'red tomato' => 0x00525a0d, # 0,82,90,13
  'red tomette' => 0x00394620, # 0,57,70,32
  'turkish red' => 0x005a6322, # 0,90,99,34
  'red vermilion' => 0x0059630e, # 0,89,99,14
  'red vermilion' => 0x00485501, # 0,72,85,1
  'red-violet' => 0x00592116, # 0,89,33,22
  'rust' => 0x002b5528, # 0,43,85,40
  'beef blood' => 0x005d6437, # 0,93,100,55
  'senois' => 0x00374a2d, # 0,55,74,45
  'terracotta' => 0x003e3714, # 0,62,55,20
  'vermeil' => 0x0060570d, # 0,96,87,13
  'zizolin' => 0x09620035, # 9,98,0,53
};


1;
# ABSTRACT: CMYK colors from http://toutes-les-couleurs.com/ (red)

__END__

=pod

=encoding UTF-8

=head1 NAME

Graphics::ColorNamesCMYK::ToutesLesCouleursCom::Red - CMYK colors from http://toutes-les-couleurs.com/ (red)

=head1 VERSION

This document describes version 0.001 of Graphics::ColorNamesCMYK::ToutesLesCouleursCom::Red (from Perl distribution Graphics-ColorNamesCMYK-ToutesLesCouleursCom), released on 2024-05-06.

=head1 DESCRIPTION

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Graphics-ColorNamesCMYK-ToutesLesCouleursCom>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Graphics-ColorNamesCMYK-ToutesLesCouleursCom>.

=head1 SEE ALSO

Other C<Graphics::ColorNamesCMYK::ToutesLesCoulersCom::*> modules.

Other C<Graphics::ColorNamesCMYK::*> modules.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Graphics-ColorNamesCMYK-ToutesLesCouleursCom>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
