use Unicode::Collate::CJK::Korean;
+{
   locale_version => 1.30,
   overrideCJK => \&Unicode::Collate::CJK::Korean::weightKorean,
   entry => <<'ENTRY', # for DUCET v13.0.0
F967      ; [.417C.0021.0002.4E0D][.4200.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F967
FA70      ; [.417C.0032.0002.4E26][.41F9.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA70
F905      ; [.4175.0021.0002.4E32][.41FB.0020.0002][.4266.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F905
2F801     ; [.4187.0021.0002.4E38][.41FC.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F801
F95E      ; [.4178.0021.0002.4E39][.41F3.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95E
F91B      ; [.417A.0021.0002.4E82][.41F3.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91B
F9BA      ; [.417A.0021.0002.4E86][.41FF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BA
F977      ; [.417A.0021.0002.4EAE][.41F5.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F977
F9FD      ; [.417E.0021.0002.4EC0][.4207.0020.0002][.4261.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FD
F9A8      ; [.417A.0021.0002.4EE4][.41F9.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A8
F92D      ; [.417A.0021.0002.4F86][.41F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92D
F9B5      ; [.417A.0021.0002.4F8B][.41FA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B5
FA30      ; [.417B.0021.0002.4FAE][.41FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA30
2F805     ; [.417B.0021.0002.4FAE][.41FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F805
2F806     ; [.4185.0023.0002.4FBB][.41F3.0020.0002][.4258.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F806
F965      ; [.4186.0021.0002.4FBF][.41F9.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F965
2F807     ; [.417C.0022.0002.5002][.41F9.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F807
F9D4      ; [.417A.0022.0002.502B][.4204.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D4
2F809     ; [.417C.0022.0002.5099][.4207.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F809
2F80B     ; [.417E.0023.0002.50CF][.41F3.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F80B
F9BB      ; [.417A.0022.0002.50DA][.41FF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BB
FA31      ; [.417E.0023.0002.50E7][.4205.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA31
2F80A     ; [.417E.0023.0002.50E7][.4205.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F80A
FA0C      ; [.4180.0021.0002.5140][.41FB.0020.0002][.4258.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA0C
FA74      ; [.4183.0021.0002.5145][.4200.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA74
FA32      ; [.417B.0021.0002.514D][.41F9.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA32
2F80E     ; [.417B.0021.0002.514D][.41F9.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F80E
2F814     ; [.4177.0022.0002.5167][.41F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F814
FA72      ; [.4181.0024.0002.5168][.41F7.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA72
F978      ; [.417A.0023.0002.5169][.41F5.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F978
F9D1      ; [.417A.0021.0002.516D][.4204.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D1
2F811     ; [.4175.0026.0002.5177][.4200.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F811
FA75      ; [.4175.0024.0002.5180][.4207.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA75
2F815     ; [.4181.0021.0002.518D][.41F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F815
2F8D2     ; [.417B.0022.0002.5192][.41FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D2
2F8D3     ; [.417B.0022.0002.5195][.41F9.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D3
2F817     ; [.4180.0023.0002.5197][.41FF.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F817
2F818     ; [.4180.003B.0002.51A4][.4201.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F818
2F81A     ; [.4178.0022.0002.51AC][.41FB.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F81A
F92E      ; [.417A.0021.0002.51B7][.41F4.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92E
F979      ; [.417A.0024.0002.51C9][.41F5.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F979
F955      ; [.417A.0021.0002.51CC][.4205.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F955
F954      ; [.417A.0021.0002.51DC][.4205.0020.0002][.4260.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F954
FA15      ; [.4187.0022.0002.51DE][.4206.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA15
2F81E     ; [.4180.0023.0002.5203][.4207.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F81E
FA00      ; [.4181.0021.0002.5207][.41F7.0020.0002][.4258.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA00
2F850     ; [.4181.0021.0002.5207][.41F7.0020.0002][.4258.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F850
F99C      ; [.417A.0022.0002.5217][.41F9.0020.0002][.4258.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99C
F9DD      ; [.417A.0022.0002.5229][.4207.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DD
F9FF      ; [.4181.0022.0002.523A][.41F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FF
2F820     ; [.4175.0021.0002.523B][.41F3.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F820
2F822     ; [.4187.0021.0002.5272][.41F3.0020.0002][.4258.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F822
2F823     ; [.417E.002D.0002.5277][.41F3.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F823
F9C7      ; [.417A.0021.0002.5289][.4204.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C7
F98A      ; [.417A.0021.0002.529B][.41F9.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98A
F99D      ; [.417A.0023.0002.52A3][.41F9.0020.0002][.4258.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99D
FA76      ; [.4180.0024.0002.52C7][.41FF.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA76
2F825     ; [.4180.0024.0002.52C7][.41FF.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F825
FA33      ; [.417B.0023.0002.52C9][.41F9.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA33
2F826     ; [.417B.0023.0002.52C9][.41F9.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F826
F952      ; [.417A.0021.0002.52D2][.4205.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F952
F92F      ; [.417A.0021.0002.52DE][.41FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92F
FA34      ; [.4175.0023.0002.52E4][.4205.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA34
2F827     ; [.4175.0023.0002.52E4][.4205.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F827
F97F      ; [.417A.0023.0002.52F5][.41F9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97F
FA77      ; [.4181.0022.0002.52FA][.41F3.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA77
2F828     ; [.4181.0022.0002.52FA][.41F3.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F828
2F829     ; [.4186.0022.0002.5305][.41FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F829
F963      ; [.417C.0021.0002.5317][.4200.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F963
2F82B     ; [.417C.0021.0002.5317][.4200.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82B
F9EB      ; [.4177.0021.0002.533F][.4207.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EB
2F82C     ; [.4187.0021.0002.5349][.4202.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82C
FA35      ; [.417C.0025.0002.5351][.4207.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA35
2F82D     ; [.417C.0025.0002.5351][.4207.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82D
2F82E     ; [.417C.0022.0002.535A][.41F3.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82E
2F82F     ; [.4181.0022.0002.5373][.4205.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82F
F91C      ; [.417A.0022.0002.5375][.41F3.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91C
2F830     ; [.4181.0021.0002.537D][.4205.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F830
2F831     ; [.4175.0028.0002.537F][.41F9.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F831
2F832     ; [.4175.0028.0002.537F][.41F9.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F832
2F833     ; [.4175.0028.0002.537F][.41F9.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F833
F96B      ; [.4183.0022.0002.53C3][.41F3.0020.0002][.4260.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96B
2F836     ; [.4175.0022.0002.53CA][.4205.0020.0002][.4261.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F836
2F837     ; [.417E.005E.0002.53DF][.4200.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F837
F906      ; [.4175.002A.0002.53E5][.4200.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F906
2F839     ; [.4175.0021.0002.53EB][.4204.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F839
2F83A     ; [.4181.0022.0002.53F1][.4207.0020.0002][.4258.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83A
F9DE      ; [.417A.0024.0002.540F][.4207.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DE
F9ED      ; [.417A.0021.0002.541D][.4207.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9ED
2F83D     ; [.4187.0021.0002.5438][.4205.0020.0002][.4261.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83D
F980      ; [.417A.0024.0002.5442][.41F9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F980
2F83E     ; [.4181.0026.0002.5448][.41F7.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83E
2F83F     ; [.4181.0028.0002.5468][.4200.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83F
2F840     ; [.4180.0031.0002.54A2][.41F3.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F840
F99E      ; [.4180.0025.0002.54BD][.4207.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99E
2F842     ; [.4178.0021.0002.5510][.41F3.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F842
2F843     ; [.4175.0022.0002.5553][.41FA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F843
2F844     ; [.4187.0024.0002.5563][.41F3.0020.0002][.4260.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F844
2F845     ; [.417E.0024.0002.5584][.41F7.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F845
2F846     ; [.417E.0024.0002.5584][.41F7.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F846
F90B      ; [.417A.0021.0002.5587][.41F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90B
FA7A      ; [.4187.0022.0002.5599][.4202.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7A
2F847     ; [.4187.0022.0002.5599][.4202.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F847
FA36      ; [.4175.0022.0002.559D][.41F3.0020.0002][.4258.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA36
FA78      ; [.4175.0022.0002.559D][.41F3.0020.0002][.4258.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA78
2F848     ; [.4176.0021.0002.55AB][.4207.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F848
FA7B      ; [.4180.0022.0002.55E2][.41FB.0020.0002][.4258.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7B
FA37      ; [.4185.0022.0002.5606][.41F3.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA37
2F84C     ; [.4185.0022.0002.5606][.41F3.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F84C
FA38      ; [.4175.0026.0002.5668][.4207.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA38
2F84F     ; [.417C.0023.0002.5674][.4200.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F84F
F9A9      ; [.417A.0023.0002.56F9][.41F9.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A9
2F84B     ; [.4178.0024.0002.5716][.41FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F84B
2F855     ; [.4187.0024.0002.578B][.41F9.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F855
2F852     ; [.417E.0021.0002.57CE][.41F7.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F852
2F853     ; [.417E.0021.0002.57F4][.4207.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F853
2F857     ; [.417C.0023.0002.5831][.41FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F857
FA39      ; [.417C.0033.0002.5840][.41F9.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA39
FA10      ; [.4183.0022.0002.585A][.41FB.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA10
FA7C      ; [.4183.0022.0002.585A][.41FB.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7C
F96C      ; [.417E.0021.0002.585E][.41F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96C
FA3A      ; [.417B.0021.0002.58A8][.4200.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3A
FA7D      ; [.417C.0024.0002.58B3][.4200.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7D
F94A      ; [.417A.0021.0002.58D8][.4200.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94A
F942      ; [.417A.0021.0002.58DF][.41FB.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F942
2F85C     ; [.417C.0032.0002.5906][.41FB.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85C
2F85D     ; [.4178.0021.0002.591A][.41F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85D
2F85E     ; [.417B.0021.0002.5922][.41FB.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85E
FA7E      ; [.4180.0024.0002.5944][.41F7.0020.0002][.4260.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7E
F90C      ; [.4177.0023.0002.5948][.41F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90C
F909      ; [.4175.0024.0002.5951][.41FA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F909
FA7F      ; [.417C.0025.0002.5954][.4200.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7F
2F85F     ; [.417E.0030.0002.5962][.41F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85F
F981      ; [.4177.0021.0002.5973][.41F9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F981
2F862     ; [.4187.0026.0002.59EC][.4206.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F862
2F863     ; [.4180.002C.0002.5A1B][.41FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F863
2F864     ; [.4185.0030.0002.5A27][.41F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F864
FA80      ; [.417C.0027.0002.5A62][.4207.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA80
2F866     ; [.417C.002B.0002.5A66][.4200.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F866
2F986     ; [.4180.0025.0002.5AB5][.4207.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F986
2F869     ; [.4180.0041.0002.5B08][.41FF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F869
FA81      ; [.4181.003C.0002.5B28][.41F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA81
2F86A     ; [.417A.0029.0002.5B3E][.41F3.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86A
2F86B     ; [.417A.0029.0002.5B3E][.41F3.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86B
FA04      ; [.4178.0021.0002.5B85][.41F4.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA04
2F86D     ; [.4180.0029.0002.5BC3][.4201.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86D
2F86E     ; [.4183.003B.0002.5BD8][.4207.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86E
F95F      ; [.4177.0021.0002.5BE7][.41F9.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95F
F9AA      ; [.4177.0021.0002.5BE7][.41F9.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AA
2F86F     ; [.4177.0021.0002.5BE7][.41F9.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86F
F9BC      ; [.417A.0023.0002.5BEE][.41FF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BC
F9BD      ; [.4177.0021.0002.5C3F][.41FF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BD
2F877     ; [.4178.0028.0002.5C60][.41FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F877
F94B      ; [.417A.0023.0002.5C62][.4200.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94B
FA3B      ; [.4183.0021.0002.5C64][.4205.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3B
F9DF      ; [.417A.0026.0002.5C65][.4207.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DF
2F879     ; [.417E.002A.0002.5CC0][.4200.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F879
F9D5      ; [.417A.0023.0002.5D19][.4204.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D5
F921      ; [.417A.0021.0002.5D50][.41F3.0020.0002][.4260.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F921
F9AB      ; [.417A.0025.0002.5DBA][.41F9.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AB
2F881     ; [.417E.0021.0002.5DE1][.4200.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F881
2F882     ; [.417E.0027.0002.5DE2][.41FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F882
2F884     ; [.417E.0022.0002.5DFD][.41FB.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F884
2F885     ; [.417E.0029.0002.5E28][.41F8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F885
2F886     ; [.417B.0025.0002.5E3D][.41FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F886
F98E      ; [.4177.0021.0002.5E74][.41F9.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98E
FA01      ; [.4178.002B.0002.5EA6][.41FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA01
2F88C     ; [.417C.0052.0002.5EB3][.4207.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F88C
2F88D     ; [.417E.0025.0002.5EB6][.41F7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F88D
F9A2      ; [.417A.0021.0002.5EC9][.41F9.0020.0002][.4260.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A2
F928      ; [.417A.0021.0002.5ECA][.41F3.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F928
2F88E     ; [.417A.0021.0002.5ECA][.41F3.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F88E
FA0B      ; [.4175.0021.0002.5ED3][.41FC.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA0B
F982      ; [.417A.0025.0002.5EEC][.41F9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F982
F943      ; [.417A.0022.0002.5F04][.41FB.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F943
2F894     ; [.4178.004B.0002.5F22][.41FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F894
2F895     ; [.4178.004B.0002.5F22][.41FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F895
2F899     ; [.4187.0025.0002.5F62][.41F9.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F899
FA84      ; [.4183.0025.0002.5F69][.41F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA84
2F89A     ; [.4181.0027.0002.5F6B][.41FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F89A
F9D8      ; [.417A.0021.0002.5F8B][.4204.0020.0002][.4258.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D8
F966      ; [.417C.0026.0002.5FA9][.41FB.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F966
FA85      ; [.4180.0043.0002.5FAD][.41FF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA85
2F89D     ; [.4180.002A.0002.5FCD][.4207.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F89D
2F89E     ; [.4181.0026.0002.5FD7][.4207.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F89E
F9A3      ; [.4177.0021.0002.5FF5][.41F9.0020.0002][.4260.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A3
F960      ; [.4177.0024.0002.6012][.41FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F960
F9AC      ; [.417A.0026.0002.601C][.41F9.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AC
2F8A0     ; [.4180.0042.0002.6081][.41F9.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A0
FA3D      ; [.4187.0026.0002.6094][.41FE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3D
2F8A3     ; [.4187.0026.0002.6094][.41FE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A3
2F8A5     ; [.4178.0022.0002.60C7][.41FB.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A5
FA86      ; [.417B.002D.0002.60D8][.41F3.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA86
F9B9      ; [.4180.0025.0002.60E1][.41F3.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B9
FA88      ; [.4180.002E.0002.6108][.4204.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA88
F9D9      ; [.417A.0022.0002.6144][.4204.0020.0002][.4258.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D9
2F8A6     ; [.4181.002A.0002.6148][.41F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A6
2F8A7     ; [.4187.0027.0002.614C][.41FC.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A7
2F8A9     ; [.4187.0027.0002.614C][.41FC.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A9
FA8A      ; [.4180.0047.0002.6160][.41FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8A
FA3E      ; [.4175.0028.0002.6168][.41F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3E
2F8AA     ; [.417A.0031.0002.617A][.4200.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AA
FA3F      ; [.4181.0022.0002.618E][.4205.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3F
FA89      ; [.4181.0022.0002.618E][.4205.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA89
2F8AB     ; [.4181.0022.0002.618E][.4205.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AB
F98F      ; [.417A.0021.0002.6190][.41F9.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98F
2F8AD     ; [.417C.0028.0002.61A4][.4200.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AD
2F8AE     ; [.4183.0030.0002.61AF][.41F3.0020.0002][.4260.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AE
2F8AC     ; [.4187.0021.0002.61B2][.41F7.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AC
2F8AF     ; [.417B.0025.0002.61DE][.41FB.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AF
FA40      ; [.4181.0022.0002.61F2][.4207.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA40
FA8B      ; [.4181.0022.0002.61F2][.4207.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8B
2F8B0     ; [.4181.0022.0002.61F2][.4207.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B0
F90D      ; [.417A.0022.0002.61F6][.41F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90D
2F8B1     ; [.417A.0022.0002.61F6][.41F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B1
F990      ; [.417A.0022.0002.6200][.41F9.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F990
2F8B2     ; [.417E.0026.0002.6210][.41F7.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B2
F9D2      ; [.417A.0022.0002.622E][.4204.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D2
FA8C      ; [.4178.0029.0002.6234][.41F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8C
2F8B5     ; [.4186.002B.0002.62B1][.41FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B5
F925      ; [.417A.0021.0002.62C9][.41F3.0020.0002][.4261.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F925
F95B      ; [.4177.0024.0002.62CF][.41F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95B
FA02      ; [.4183.0026.0002.62D3][.41F7.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA02
2F8B6     ; [.417C.0022.0002.62D4][.41F3.0020.0002][.4258.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B6
F973      ; [.417E.0022.0002.62FE][.4205.0020.0002][.4261.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F973
2F8B9     ; [.417B.0027.0002.633D][.41F3.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B9
2F8B7     ; [.4180.0027.0002.6350][.41F9.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B7
2F8BB     ; [.417E.0039.0002.6368][.41F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8BB
F9A4      ; [.4177.0024.0002.637B][.41F9.0020.0002][.4260.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A4
2F8BC     ; [.417E.0029.0002.6383][.41FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8BC
F975      ; [.417A.0021.0002.63A0][.41F5.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F975
2F8C1     ; [.4180.0025.0002.63A9][.41F7.0020.0002][.4260.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C1
FA8D      ; [.4180.0030.0002.63C4][.4204.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8D
FA8E      ; [.417E.0030.0002.641C][.4200.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8E
2F8BF     ; [.4181.0025.0002.6422][.4207.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8BF
2F8C3     ; [.417B.0021.0002.6469][.41F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C3
F991      ; [.4177.0022.0002.649A][.41F9.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F991
2F8C5     ; [.4187.0029.0002.649D][.4203.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C5
F930      ; [.417A.0023.0002.64C4][.41FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F930
FA41      ; [.417B.0025.0002.654F][.4207.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA41
2F8C8     ; [.417B.0025.0002.654F][.4207.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C8
FA90      ; [.4180.0030.0002.6556][.41FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA90
2F8C9     ; [.4175.0030.0002.656C][.41F9.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C9
F969      ; [.417E.0032.0002.6578][.4200.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F969
F9BE      ; [.417A.0025.0002.6599][.41FF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BE
F983      ; [.417A.0028.0002.65C5][.41F9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F983
2F8CB     ; [.4175.0035.0002.65E3][.4207.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8CB
F9E0      ; [.4180.0024.0002.6613][.41F9.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E0
2F8CD     ; [.4181.0026.0002.6649][.4207.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8CD
FA12      ; [.4183.0022.0002.6674][.41F7.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA12
FA91      ; [.4183.0022.0002.6674][.41F7.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA91
F9C5      ; [.4187.002A.0002.6688][.4200.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C5
FA43      ; [.417E.002B.0002.6691][.41F7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA43
2F8CF     ; [.417E.002B.0002.6691][.41F7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8CF
FA06      ; [.4186.0022.0002.66B4][.41FB.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA06
F98B      ; [.417A.0022.0002.66C6][.41F9.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98B
F901      ; [.4175.0033.0002.66F4][.41F9.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F901
2F8CC     ; [.417E.002D.0002.66F8][.41F7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8CC
2F8D4     ; [.4183.0023.0002.6700][.41FE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D4
F929      ; [.417A.0022.0002.6717][.41F3.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F929
FA92      ; [.417A.0022.0002.6717][.41F3.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA92
2F8D8     ; [.417A.0022.0002.6717][.41F3.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D8
FA93      ; [.417B.0025.0002.671B][.41F3.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA93
2F8D9     ; [.417B.0025.0002.671B][.41F3.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D9
F9E1      ; [.417A.0028.0002.674E][.4207.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E1
2F8DC     ; [.4186.0025.0002.6753][.41FF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8DC
FA94      ; [.4181.002E.0002.6756][.41F3.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA94
2F8DB     ; [.4175.0038.0002.675E][.4207.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8DB
F9C8      ; [.4177.0021.0002.677B][.4204.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C8
F9F4      ; [.417A.0021.0002.6797][.4207.0020.0002][.4260.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F4
F9C9      ; [.417A.0023.0002.67F3][.4204.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C9
F9DA      ; [.417A.0023.0002.6817][.4204.0020.0002][.4258.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DA
F97A      ; [.417A.0025.0002.6881][.41F5.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97A
FA44      ; [.417B.0027.0002.6885][.41F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA44
2F8E2     ; [.417B.0027.0002.6885][.41F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E2
F9E2      ; [.417A.0029.0002.68A8][.4207.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E2
2F8E8     ; [.417E.0062.0002.6942][.41F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E8
2F8EA     ; [.4175.002A.0002.69EA][.41F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8EA
F914      ; [.4180.0028.0002.6A02][.41F3.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F914
F95C      ; [.4180.0028.0002.6A02][.41F3.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95C
F9BF      ; [.4180.0028.0002.6A02][.41F3.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BF
F94C      ; [.417A.0024.0002.6A13][.4200.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94C
F931      ; [.417A.0024.0002.6AD3][.41FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F931
2F8ED     ; [.4181.0021.0002.6ADB][.4205.0020.0002][.4258.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8ED
F91D      ; [.417A.0023.0002.6B04][.41F3.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91D
2F8EF     ; [.4183.0028.0002.6B21][.41F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8EF
2F8F1     ; [.4187.0025.0002.6B54][.41F7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8F1
2F8F3     ; [.417E.0023.0002.6B72][.41F8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8F3
F98C      ; [.417A.0023.0002.6B77][.41F9.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98C
F9A5      ; [.417A.0023.0002.6BAE][.41F9.0020.0002][.4260.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A5
F970      ; [.417E.0023.0002.6BBA][.41F3.0020.0002][.4258.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F970
FA96      ; [.417E.0023.0002.6BBA][.41F3.0020.0002][.4258.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA96
2F8F5     ; [.417E.0023.0002.6BBA][.41F3.0020.0002][.4258.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8F5
2F8FA     ; [.417C.0025.0002.6C4E][.41F7.0020.0002][.4260.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8FA
F972      ; [.4183.0024.0002.6C88][.4207.0020.0002][.4260.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F972
2F8FC     ; [.4180.002B.0002.6CBF][.41F9.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8FC
F968      ; [.4186.0024.0002.6CCC][.4207.0020.0002][.4258.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F968
F9E3      ; [.4177.0022.0002.6CE5][.4207.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E3
F915      ; [.417A.0021.0002.6D1B][.41F3.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F915
FA05      ; [.4178.002A.0002.6D1E][.41FB.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA05
2F900     ; [.4186.0029.0002.6D3E][.41F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F900
F9CA      ; [.417A.0025.0002.6D41][.4204.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CA
FA97      ; [.417A.0025.0002.6D41][.4204.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA97
2F902     ; [.417A.0025.0002.6D41][.4204.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F902
2F903     ; [.4187.002E.0002.6D69][.41FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F903
F92A      ; [.417A.0023.0002.6D6A][.41F3.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92A
FA45      ; [.4187.002A.0002.6D77][.41F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA45
2F901     ; [.4187.002A.0002.6D77][.41F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F901
2F904     ; [.4183.0025.0002.6D78][.4207.0020.0002][.4260.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F904
2F905     ; [.4180.0022.0002.6D85][.41F9.0020.0002][.4258.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F905
F9F5      ; [.417A.0022.0002.6DCB][.4207.0020.0002][.4260.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F5
F94D      ; [.417A.0025.0002.6DDA][.4200.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94D
F9D6      ; [.417A.0024.0002.6DEA][.4204.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D6
2F90E     ; [.4180.0026.0002.6DF9][.41F7.0020.0002][.4260.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F90E
FA46      ; [.4181.002C.0002.6E1A][.41F7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA46
2F908     ; [.4187.002B.0002.6E2F][.41F3.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F908
2F909     ; [.4180.002B.0002.6E6E][.4207.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F909
F9CB      ; [.417A.0026.0002.6E9C][.4204.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CB
F9EC      ; [.4177.0022.0002.6EBA][.4207.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EC
FA99      ; [.4181.002B.0002.6ECB][.41F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA99
2F90B     ; [.4181.002B.0002.6ECB][.41F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F90B
F904      ; [.4187.0022.0002.6ED1][.41FC.0020.0002][.4258.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F904
F94E      ; [.417A.0026.0002.6F0F][.4200.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94E
FA47      ; [.4187.0026.0002.6F22][.41F3.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA47
FA9A      ; [.4187.0026.0002.6F22][.41F3.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9A
F992      ; [.417A.0024.0002.6F23][.41F9.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F992
2F90F     ; [.4181.0033.0002.6F6E][.41FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F90F
2F912     ; [.417C.003C.0002.6FC6][.4200.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F912
F922      ; [.417A.0025.0002.6FEB][.41F3.0020.0002][.4260.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F922
F984      ; [.417A.002A.0002.6FFE][.41F9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F984
2F915     ; [.4180.002D.0002.701B][.41F9.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F915
FA9B      ; [.4181.003D.0002.701E][.41F7.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9B
2F914     ; [.4181.003D.0002.701E][.41F7.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F914
2F835     ; [.4187.002D.0002.7070][.41FE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F835
2F918     ; [.4181.002B.0002.707D][.41F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F918
F9FB      ; [.4181.002C.0002.7099][.41F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FB
2F91A     ; [.4185.0028.0002.70AD][.41F3.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F91A
F99F      ; [.417A.0025.0002.70C8][.41F9.0020.0002][.4258.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99F
F916      ; [.417A.0022.0002.70D9][.41F3.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F916
F993      ; [.417A.0025.0002.7149][.41F9.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F993
FA48      ; [.4181.002D.0002.716E][.41F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA48
FA9C      ; [.4181.002D.0002.716E][.41F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9C
F9C0      ; [.417A.0026.0002.71CE][.41FF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C0
F9EE      ; [.417A.0023.0002.71D0][.4207.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EE
F932      ; [.417A.0027.0002.7210][.41FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F932
F91E      ; [.417A.0026.0002.721B][.41F3.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91E
2F920     ; [.4183.0036.0002.7228][.41F3.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F920
FA9E      ; [.4181.0028.0002.7235][.41F3.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9E
2F921     ; [.4181.0028.0002.7235][.41F3.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F921
F946      ; [.417A.0023.0002.7262][.41FE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F946
2F924     ; [.417E.0030.0002.7280][.41F7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F924
FA9F      ; [.417C.0027.0002.72AF][.41F7.0020.0002][.4260.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9F
F9FA      ; [.417E.0035.0002.72C0][.41F3.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FA
F92B      ; [.417A.0024.0002.72FC][.41F3.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92B
FA16      ; [.4181.002E.0002.732A][.41F7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA16
FAA0      ; [.4181.002E.0002.732A][.41F7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA0
F9A7      ; [.417A.0021.0002.7375][.41F9.0020.0002][.4261.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A7
2F928     ; [.4178.0023.0002.737A][.41F3.0020.0002][.4258.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F928
F961      ; [.417E.0021.0002.7387][.41FB.0020.0002][.4258.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F961
F9DB      ; [.417E.0021.0002.7387][.41FB.0020.0002][.4258.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DB
2F929     ; [.4180.0025.0002.738B][.41FC.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F929
F9AD      ; [.417A.0027.0002.73B2][.41F9.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AD
F917      ; [.417A.0023.0002.73DE][.41F3.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F917
F9E4      ; [.417A.002D.0002.7406][.4207.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E4
F9CC      ; [.417A.0028.0002.7409][.4204.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CC
FA4A      ; [.4185.002B.0002.7422][.41F3.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4A
2F92F     ; [.4180.003D.0002.745C][.4204.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F92F
F9AE      ; [.4187.002D.0002.7469][.41F9.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AE
FAA1      ; [.4181.0057.0002.7471][.41F7.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA1
2F930     ; [.4181.0057.0002.7471][.41F7.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F930
F994      ; [.417A.0026.0002.7489][.41F9.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F994
F9EF      ; [.417A.0024.0002.7498][.4207.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EF
2F932     ; [.4175.003A.0002.74CA][.41F9.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F932
F9CD      ; [.417A.002A.0002.7559][.4204.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CD
F976      ; [.417A.0022.0002.7565][.41F5.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F976
F962      ; [.4180.002C.0002.7570][.4207.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F962
2F938     ; [.4180.002C.0002.7570][.4207.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F938
F9E5      ; [.417A.002F.0002.75E2][.4207.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E5
2F93A     ; [.4180.0059.0002.7610][.4204.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F93A
FAA5      ; [.4180.0023.0002.761F][.41FB.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA5
F9C1      ; [.417A.0027.0002.7642][.41FF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C1
F90E      ; [.417A.0023.0002.7669][.41F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90E
FA17      ; [.4180.0022.0002.76CA][.4207.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA17
FAA6      ; [.4180.0022.0002.76CA][.4207.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA6
FAA7      ; [.417E.002B.0002.76DB][.41F7.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA7
F933      ; [.417A.0028.0002.76E7][.41FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F933
FAA8      ; [.4181.0021.0002.76F4][.4207.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA8
2F940     ; [.4181.0021.0002.76F4][.4207.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F940
F96D      ; [.417E.002C.0002.7701][.41F7.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96D
2F945     ; [.4181.0033.0002.771E][.4207.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F945
FAAA      ; [.4183.0023.0002.7740][.41F3.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAAA
2F94A     ; [.4181.0034.0002.778B][.4207.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F94A
F9CE      ; [.417A.002C.0002.786B][.4204.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CE
F93B      ; [.417A.0021.0002.788C][.41FB.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93B
2F94F     ; [.417A.0021.0002.788C][.41FB.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F94F
FA4B      ; [.417C.0038.0002.7891][.4207.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4B
F947      ; [.417A.0024.0002.78CA][.41FE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F947
F964      ; [.417C.0032.0002.78FB][.41F3.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F964
F985      ; [.417A.002B.0002.792A][.41F9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F985
FA4C      ; [.417E.0046.0002.793E][.41F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4C
FA4E      ; [.4175.004C.0002.7948][.4207.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4E
FA4D      ; [.4181.0035.0002.7949][.4207.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4D
FA4F      ; [.4180.0032.0002.7950][.4200.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4F
FA50      ; [.4181.0039.0002.7956][.41FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA50
2F953     ; [.4181.0039.0002.7956][.41FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F953
FA51      ; [.4183.0023.0002.795D][.4200.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA51
FA19      ; [.417E.002C.0002.795E][.4207.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA19
FA1A      ; [.417E.0037.0002.7965][.41F3.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1A
F93C      ; [.417A.0022.0002.797F][.41FB.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93C
FA52      ; [.4187.0027.0002.798D][.41FC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA52
FA53      ; [.4181.0044.0002.798E][.41F7.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA53
FA1B      ; [.417C.0028.0002.798F][.41FB.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1B
2F956     ; [.417C.0028.0002.798F][.41FB.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F956
F9B6      ; [.417A.0023.0002.79AE][.41FA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B6
F995      ; [.4177.0023.0002.79CA][.41F9.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F995
2F957     ; [.4183.0024.0002.79EB][.4200.0020.0002][.4258.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F957
F956      ; [.417A.0023.0002.7A1C][.4205.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F956
FA54      ; [.4175.0025.0002.7A40][.41FB.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA54
2F959     ; [.4175.0025.0002.7A40][.41FB.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F959
FA55      ; [.4178.0022.0002.7A81][.41FB.0020.0002][.4258.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA55
F9F7      ; [.417A.0022.0002.7ACB][.4207.0020.0002][.4261.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F7
F9F8      ; [.417A.0023.0002.7B20][.4207.0020.0002][.4261.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F8
FA56      ; [.4181.0027.0002.7BC0][.41F7.0020.0002][.4258.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA56
FAAD      ; [.4181.0027.0002.7BC0][.41F7.0020.0002][.4258.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAAD
2F962     ; [.4181.003D.0002.7BC6][.41F7.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F962
2F963     ; [.4183.0026.0002.7BC9][.4200.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F963
F9A6      ; [.417A.0025.0002.7C3E][.41F9.0020.0002][.4260.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A6
F944      ; [.417A.0026.0002.7C60][.41FB.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F944
F9F9      ; [.417A.0024.0002.7C92][.4207.0020.0002][.4261.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F9
FA1D      ; [.4181.0047.0002.7CBE][.41F7.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1D
FA03      ; [.4178.0029.0002.7CD6][.41F3.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA03
F97B      ; [.417A.0029.0002.7CE7][.41F5.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97B
2F96A     ; [.4175.004F.0002.7D00][.4207.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F96A
F9CF      ; [.4177.0022.0002.7D10][.4204.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CF
F96A      ; [.417E.0023.0002.7D22][.41F4.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96A
F94F      ; [.417A.0028.0002.7D2F][.4200.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94F
FAAF      ; [.4181.0063.0002.7D5B][.41FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAAF
2F96C     ; [.417C.0034.0002.7D63][.41F9.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F96C
F93D      ; [.417A.0023.0002.7DA0][.41FB.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93D
F957      ; [.417A.0024.0002.7DBE][.4205.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F957
2F96E     ; [.4183.0030.0002.7DC7][.4207.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F96E
F996      ; [.417A.0027.0002.7DF4][.41F9.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F996
FA57      ; [.417A.0027.0002.7DF4][.41F9.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA57
FAB0      ; [.417A.0027.0002.7DF4][.41F9.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB0
FA58      ; [.4181.0036.0002.7E09][.4207.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA58
F950      ; [.417A.0029.0002.7E37][.4200.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F950
FA59      ; [.417C.0026.0002.7E41][.41F7.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA59
2F970     ; [.417E.0052.0002.7E45][.41FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F970
FAB1      ; [.417C.0035.0002.7F3E][.41F9.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB1
FA5A      ; [.417E.0035.0002.7F72][.41F7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5A
F9E6      ; [.417A.0031.0002.7F79][.4207.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E6
F90F      ; [.417A.0024.0002.7F85][.41F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90F
F9AF      ; [.417A.0029.0002.7F9A][.41F9.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AF
FA1E      ; [.4180.0036.0002.7FBD][.4200.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1E
2F979     ; [.4175.005A.0002.7FFA][.41FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F979
F934      ; [.417A.0029.0002.8001][.41FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F934
FA5B      ; [.4181.0033.0002.8005][.41F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5B
FAB2      ; [.4181.0033.0002.8005][.41F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB2
2F97A     ; [.4181.0033.0002.8005][.41F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F97A
F9B0      ; [.417A.002B.0002.8046][.41F9.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B0
F997      ; [.417A.0028.0002.806F][.41F9.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F997
2F97F     ; [.4183.0028.0002.8070][.41FB.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F97F
F945      ; [.417A.0027.0002.807E][.41FB.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F945
F953      ; [.417A.0022.0002.808B][.4205.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F953
2F8D6     ; [.4177.0023.0002.80AD][.4200.0020.0002][.4258.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D6
2F982     ; [.4180.0024.0002.80B2][.4204.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F982
2F985     ; [.417C.003F.0002.813E][.4207.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F985
F926      ; [.417A.0022.0002.81D8][.41F3.0020.0002][.4261.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F926
F9F6      ; [.417A.0024.0002.81E8][.4207.0020.0002][.4260.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F6
FA5C      ; [.4183.002A.0002.81ED][.4203.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5C
2F893     ; [.4180.002E.0002.8201][.41F9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F893
2F98B     ; [.4180.002E.0002.8201][.41F9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F98B
F97C      ; [.417A.002A.0002.826F][.41F5.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97C
2F990     ; [.4180.0037.0002.828B][.4200.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F990
2F991     ; [.4181.003B.0002.829D][.4207.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F991
2F993     ; [.4187.0029.0002.82B1][.41FC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F993
2F994     ; [.417C.0035.0002.82B3][.41F3.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F994
2F995     ; [.4180.0029.0002.82BD][.41F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F995
F974      ; [.4180.0023.0002.82E5][.41F5.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F974
2F998     ; [.4180.0023.0002.82E5][.41F5.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F998
2F996     ; [.4175.003A.0002.82E6][.41FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F996
2F999     ; [.4183.002E.0002.831D][.41F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F999
2F99C     ; [.4180.004C.0002.8323][.41FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F99C
F9FE      ; [.4178.0022.0002.8336][.41F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FE
FAB3      ; [.4187.0034.0002.8352][.41FC.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB3
2F99D     ; [.417B.002A.0002.83BD][.41F3.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F99D
F93E      ; [.417A.0024.0002.83C9][.41FB.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93E
2F9A1     ; [.4175.0023.0002.83CA][.4200.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A1
2F9A2     ; [.4175.0025.0002.83CC][.4204.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A2
2F9A3     ; [.4183.0029.0002.83DC][.41F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A3
FAB4      ; [.4187.002A.0002.83EF][.41FC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB4
F958      ; [.417A.0025.0002.83F1][.4205.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F958
F918      ; [.417A.0025.0002.843D][.41F3.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F918
F96E      ; [.4180.0023.0002.8449][.41F9.0020.0002][.4261.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96E
FA5F      ; [.4181.0034.0002.8457][.41F7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5F
2F99F     ; [.4181.0034.0002.8457][.41F7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F99F
F999      ; [.417A.0029.0002.84EE][.41F9.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F999
2F9A8     ; [.4186.002A.0002.84F1][.41F9.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A8
F9C2      ; [.417A.002A.0002.84FC][.41FF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C2
2F9AC     ; [.4180.0062.0002.8564][.4204.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9AC
F923      ; [.417A.0028.0002.85CD][.41F3.0020.0002][.4260.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F923
F9F0      ; [.417A.0025.0002.85FA][.4207.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F0
F935      ; [.417A.002A.0002.8606][.41FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F935
F91F      ; [.417A.0027.0002.862D][.41F3.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91F
F910      ; [.417A.0025.0002.863F][.41F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F910
2F9B3     ; [.4187.0023.0002.8650][.41F3.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B3
F936      ; [.417A.002B.0002.865C][.41FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F936
2F9B4     ; [.417A.002B.0002.865C][.41FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B4
2F9B5     ; [.4187.0025.0002.8667][.4204.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B5
2F9B7     ; [.4183.0034.0002.86A9][.4207.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B7
2F9BC     ; [.4181.0026.0002.8728][.41F7.0020.0002][.4261.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9BC
F911      ; [.417A.0026.0002.87BA][.41F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F911
F927      ; [.417A.0023.0002.881F][.41F3.0020.0002][.4261.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F927
FA08      ; [.4187.0025.0002.884C][.41F4.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA08
2F9C4     ; [.4180.0030.0002.8863][.4206.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9C4
F9A0      ; [.417A.0026.0002.88C2][.41F9.0020.0002][.4258.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A0
F9E7      ; [.417A.0034.0002.88CF][.4207.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E7
F9E8      ; [.417A.0035.0002.88E1][.4207.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E8
F912      ; [.417A.0027.0002.88F8][.41F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F912
FA60      ; [.4175.0028.0002.8910][.41F3.0020.0002][.4258.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA60
FAB6      ; [.4175.0034.0002.8941][.41F3.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB6
F924      ; [.417A.0029.0002.8964][.41F3.0020.0002][.4260.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F924
FAB7      ; [.417C.002D.0002.8986][.41FB.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB7
FA0A      ; [.4175.0028.0002.898B][.41F9.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA0A
FA61      ; [.417E.0037.0002.8996][.4207.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA61
FAB8      ; [.417E.0037.0002.8996][.4207.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB8
2F9CF     ; [.417E.0031.0002.8AA0][.41F7.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9CF
F96F      ; [.417E.002B.0002.8AAA][.41F7.0020.0002][.4258.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96F
F9A1      ; [.417E.002B.0002.8AAA][.41F7.0020.0002][.4258.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A1
FAB9      ; [.4181.0046.0002.8ABF][.41FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB9
FABB      ; [.4183.0026.0002.8ACB][.41F7.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABB
F97D      ; [.417A.002B.0002.8AD2][.41F5.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97D
F941      ; [.417A.0021.0002.8AD6][.41FB.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F941
FABE      ; [.4180.0046.0002.8AED][.4204.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABE
2F9D0     ; [.4180.0046.0002.8AED][.4204.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D0
FA22      ; [.4181.0030.0002.8AF8][.41F8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA22
FABA      ; [.4181.0030.0002.8AF8][.41F8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABA
F95D      ; [.4177.0021.0002.8AFE][.41F3.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95D
FABD      ; [.4177.0021.0002.8AFE][.41F3.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABD
FA62      ; [.4180.0022.0002.8B01][.41F3.0020.0002][.4258.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA62
FABC      ; [.4180.0022.0002.8B01][.41F3.0020.0002][.4258.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABC
FA63      ; [.4175.002D.0002.8B39][.4205.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA63
FABF      ; [.4175.002D.0002.8B39][.4205.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABF
F9FC      ; [.417E.002C.0002.8B58][.4207.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FC
F95A      ; [.4178.002A.0002.8B80][.41FB.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95A
FAC0      ; [.417C.0023.0002.8B8A][.41F9.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC0
2F9D1     ; [.417C.0023.0002.8B8A][.41F9.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D1
F900      ; [.4175.0057.0002.8C48][.4207.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F900
2F9D2     ; [.417E.003B.0002.8C55][.4207.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D2
2F9D4     ; [.4175.002E.0002.8CAB][.41FC.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D4
2F9D5     ; [.417C.0032.0002.8CC1][.4200.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D5
F948      ; [.417A.0025.0002.8CC2][.41FE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F948
F903      ; [.4175.0039.0002.8CC8][.41F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F903
FA64      ; [.417C.002D.0002.8CD3][.4207.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA64
FA65      ; [.4181.002B.0002.8D08][.4205.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA65
FAC1      ; [.4181.002B.0002.8D08][.4205.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC1
2F9D6     ; [.4175.0039.0002.8D1B][.41FB.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D6
2F9D7     ; [.4175.0058.0002.8D77][.4207.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D7
2F9DA     ; [.417C.0027.0002.8DCB][.41F3.0020.0002][.4258.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9DA
F937      ; [.417A.002C.0002.8DEF][.41FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F937
F902      ; [.4183.002D.0002.8ECA][.41F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F902
F998      ; [.417A.002A.0002.8F26][.41F9.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F998
F9D7      ; [.417A.0026.0002.8F2A][.4204.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D7
FAC2      ; [.417E.004F.0002.8F38][.4200.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC2
2F9DF     ; [.417E.004F.0002.8F38][.4200.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9DF
FA07      ; [.417C.002F.0002.8F3B][.41FB.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA07
F98D      ; [.417A.0026.0002.8F62][.41F9.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98D
F971      ; [.4181.003E.0002.8FB0][.4207.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F971
F99A      ; [.417A.002B.0002.9023][.41F9.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99A
FA25      ; [.4180.0027.0002.9038][.4207.0020.0002][.4258.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA25
FA67      ; [.4180.0027.0002.9038][.4207.0020.0002][.4258.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA67
FAC3      ; [.4181.0041.0002.9072][.4207.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC3
F9C3      ; [.417A.002B.0002.907C][.41FF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C3
F913      ; [.417A.0028.0002.908F][.41F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F913
FA2E      ; [.417A.0028.0002.90DE][.41F3.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2E
FA26      ; [.4178.0045.0002.90FD][.41FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA26
F919      ; [.417A.0026.0002.916A][.41F3.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F919
F9B7      ; [.417A.0024.0002.91B4][.41FA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B7
F9E9      ; [.417A.0036.0002.91CC][.4207.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E9
F97E      ; [.417A.002D.0002.91CF][.41F5.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97E
F90A      ; [.4175.0021.0002.91D1][.4207.0020.0002][.4260.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90A
F9B1      ; [.417A.002D.0002.9234][.41F9.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B1
2F9E7     ; [.417C.002F.0002.9238][.41F3.0020.0002][.4258.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9E7
2F9EA     ; [.417C.0039.0002.927C][.41F9.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9EA
2F9E8     ; [.4187.003F.0002.92D7][.41F9.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9E8
F93F      ; [.417A.0025.0002.9304][.41FB.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93F
F99B      ; [.417A.002C.0002.934A][.41F9.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99B
2F9EE     ; [.4175.0033.0002.958B][.41F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9EE
F986      ; [.417A.002E.0002.95AD][.41F9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F986
F9C6      ; [.4180.0031.0002.962E][.41FC.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C6
F951      ; [.417A.002D.0002.964B][.4200.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F951
FA09      ; [.4175.0037.0002.964D][.41F3.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA09
F959      ; [.417A.0026.0002.9675][.4205.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F959
F9D3      ; [.417A.0023.0002.9678][.4204.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D3
FAC6      ; [.4181.004E.0002.967C][.41F7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC6
F9DC      ; [.417A.0021.0002.9686][.4204.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DC
F9F1      ; [.417A.0027.0002.96A3][.4207.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F1
FA2F      ; [.417A.0025.0002.96B7][.41FA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2F
F9B8      ; [.417A.0026.0002.96B8][.41FA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B8
F9EA      ; [.417A.0038.0002.96E2][.4207.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EA
FA68      ; [.4177.0023.0002.96E3][.41F3.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA68
FAC7      ; [.4177.0023.0002.96E3][.41F3.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC7
F9B2      ; [.417A.002E.0002.96F6][.41F9.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B2
F949      ; [.417A.0028.0002.96F7][.41FE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F949
2F9F5     ; [.4180.0031.0002.9723][.4200.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9F5
F938      ; [.417A.002E.0002.9732][.41FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F938
F9B3      ; [.417A.002F.0002.9748][.41F9.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B3
FA1C      ; [.4181.0054.0002.9756][.41F7.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1C
FAC8      ; [.4181.0054.0002.9756][.41F7.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC8
2F9FA     ; [.4186.0034.0002.97E0][.4207.0020.0002][.4258.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9FA
FA69      ; [.4187.0026.0002.97FF][.41F5.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA69
FACA      ; [.4187.0026.0002.97FF][.41F5.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACA
F9B4      ; [.417A.0030.0002.9818][.41F9.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B4
FA6A      ; [.417C.002E.0002.983B][.4207.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA6A
FACC      ; [.417C.002E.0002.983B][.4207.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACC
F9D0      ; [.417A.002E.0002.985E][.4204.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D0
2FA02     ; [.4175.005B.0002.98E2][.4207.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA02
FA2A      ; [.417C.0039.0002.98EF][.41F3.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2A
FA2B      ; [.417E.005A.0002.98FC][.41F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2B
FA2C      ; [.4175.0030.0002.9928][.41FC.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2C
F91A      ; [.417A.0027.0002.99F1][.41F3.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91A
F987      ; [.417A.0030.0002.9A6A][.41F9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F987
FACD      ; [.4181.004C.0002.9B12][.4207.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACD
2FA0A     ; [.4181.004C.0002.9B12][.4207.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA0A
F939      ; [.417A.002F.0002.9B6F][.41FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F939
F9F2      ; [.417A.0028.0002.9C57][.4207.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F2
FA2D      ; [.4187.0025.0002.9DB4][.41F3.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2D
F93A      ; [.417A.0030.0002.9DFA][.41FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93A
F920      ; [.417A.0028.0002.9E1E][.41F3.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F920
F940      ; [.417A.0026.0002.9E7F][.41FB.0020.0002][.4251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F940
F988      ; [.417A.0031.0002.9E97][.41F9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F988
F9F3      ; [.417A.0029.0002.9E9F][.4207.0020.0002][.4254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F3
2FA15     ; [.417B.0028.0002.9EBB][.41F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA15
F989      ; [.417A.0032.0002.9ECE][.41F9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F989
2FA1C     ; [.417C.004A.0002.9F3B][.4207.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA1C
F9C4      ; [.417A.0021.0002.9F8D][.41FF.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C4
FAD9      ; [.417A.002E.0002.9F8E][.41FB.0020.0002][.4265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAD9
F907      ; [.4175.0056.0002.9F9C][.4200.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F907
F908      ; [.4175.0056.0002.9F9C][.4200.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F908
FACE      ; [.4175.0056.0002.9F9C][.4200.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACE
ENTRY
};
