
use strict;
use Test::More qw(no_plan);
use Set::IntSpan::Island 0.10;

my @sets = (
	    ["1-5",0,"1-5"],
	    ["1-5",1,"1-5"],
	    ["1-5",5,"1-5"],
	    ["1-5",6,"-"],
	    ["1-5,7",1,"1-5,7"],
	    ["1-5,7",2,"1-5"],
	    ["1-5,7-8",1,"1-5,7-8"],
	    ["1-5,7-8",3,"1-5"],
	    ["1-5,7-8",6,"-"],
	    ["1-5,7,9-10",0,"1-5,7,9-10"],
	    ["1-5,7,9-10",10,"-"],
	    ["1-5,7","1-2","1-5"],
	    ["1-5,7","0-2","1-5"],
	    ["1-5,7","(-2","1-5"],
	    ["1-5,7,9-10","1-2","1-5"],
	    ["1-5,7,9-11","1-2","1-5,9-11"],
	    ["","1-2",""],
	    ["",0,""],
	    ["","-",""],
	    ["1,3,5,7-8,10-11,20-40,100-200","2-)","1,3,5"],
	    ["1,3,5,7-8,10-11,20-40,100-200","3-)","1,3,5,7-8,10-11"],
	    ["1,3,5,7-8,10-11,20-40,100-200","50-)","1,3,5,7-8,10-11,20-40"],
	    ["1,3,5,7-8,10-11,20-40,100-200","100-)","1,3,5,7-8,10-11,20-40"],
	    ["1,3,5,7-8,10-11,20-40,100-200","101-)","1,3,5,7-8,10-11,20-40"],
	    ["1,3,5,7-8,10-11,20-40,100-200","102-)","1,3,5,7-8,10-11,20-40,100-200"],
	    ["1-5,7,9-11","2-)","7"],
	    ["1-5,7,9-11","1-)","-"],
	    ["1-5,7,9-11","(-)","-"],
	    ["(-0,5-10","1-10","(-0"],
	    ["(-0,5-10,20-)","1-10","(-0,20-)"],
	    ["(-)","1-10","(-)"],
	    );

excise();

sub excise {
  for my $setdata (@sets) {
    my $set1         = Set::IntSpan::Island->new($setdata->[0]);
    my $expected_set = Set::IntSpan::Island->new($setdata->[2]);
    my $excised_set;
    if($setdata->[1] =~ /[-,]/) {
      $excised_set = $set1->excise(Set::IntSpan::Island->new($setdata->[1]));
    } else {
      $excised_set = $set1->excise($setdata->[1]);
    }
    is($excised_set->run_list,$expected_set->run_list,
       "Removed islands from $set1 using size $setdata->[1] and got $excised_set but expected $expected_set");
  }
}
