=head1 NAME

Sample::Pod

=head1 SYNOPSIS

    perldoc Sample::Pod

=head1 DESCRIPTION

This is dummy copy used to test Pod::Multi.

=head2 Unordered List with Named Bullet Points

=over 4

=item * Bullet Point One

Text for Bullet Point One

=item * Bullet Point Two

Text for Bullet Point Two

=back

=head2 Unordered List with Only Bullet Points

=over 4

=item *

Text for Bullet Point A

=item *

Text for Bullet Point B

=back

=head2 Ordered List

=over 4

=item 1

Text for Point 1

=item 2

Text for Point 2

=back

=head2 Paragraphs

This paragraph will contain a variety of elements typically found in Pod.  For
example, some text will be I<italicized>.  Other text will be presented in
B<bold>.  Yet other text will be C<source code>.  Paths and programs are
typically represented like this:  F</usr/bin/perl> is the
F</path/to/prosperity>.

That's enough for now.  We'll deal with such features as B<links> later.  Just
remember:

    #!/usr/bin/perl
    use strict;
    use warnings;

Smile and say, C<Hello, world!>.

=cut



