package Maypole::Session;

=head1 NAME

Maypole::Session - Session related functionality for maypole

=head1 SYNOPSIS

use Maypole::Session;

my $uid = Maypole::Session::generate_unique_id()

=head1 DESCRIPTION

This class provides session related methods for Maypole such as unique id's for
requests.

Currently it provides only the generate_unique_id() function, by checking the
id's generated by this function and included in submitted forms, it is possible
to see if a form has been submitted before.. implementing these checks is left
to the developer of that application.

Further functionality is to be added here in later versions to provide easy
access to sessions, either through plugins or builtin methods.

=head1 FUNCTIONS

=head2 generate_unique_id()

my $uid = Maypole::Session::generate_unique_id()

generates a unique id and returns it, requires no arguments but accepts size,
default is 32.

=cut

use strict;
use Digest::MD5;
our $VERSION = 0.01;

sub generate_unique_id {
    my $length = shift || 32;
    my $id = substr(Digest::MD5::md5_hex(Digest::MD5::md5_hex(time(). {}. rand(). $$)), 0, $length);
    return $id;
}


################################################################################
################################################################################

=head1 TODO

Currently implementing uniqueness tests of form submissions is left to the
Maypole user, we plan to provide an optional default behaviour to automate this
if required.

=head1 SEE ALSO

L<Maypole>

=head1 MAINTAINER

Aaron Trevena, c<teejay@droogs.org>

=head1 AUTHOR

Simon Cozens, C<simon@cpan.org>

=head1 LICENSE

You may distribute this code under the same terms as Perl itself.

=cut


1;
