# Generated by default/object.tt
package Paws::NetworkFirewall::RuleGroup;
  use Moose;
  has RulesSource => (is => 'ro', isa => 'Paws::NetworkFirewall::RulesSource', required => 1);
  has RuleVariables => (is => 'ro', isa => 'Paws::NetworkFirewall::RuleVariables');

1;

### main pod documentation begin ###

=head1 NAME

Paws::NetworkFirewall::RuleGroup

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::NetworkFirewall::RuleGroup object:

  $service_obj->Method(Att1 => { RulesSource => $value, ..., RuleVariables => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::NetworkFirewall::RuleGroup object:

  $result = $service_obj->Method(...);
  $result->Att1->RulesSource

=head1 DESCRIPTION

The object that defines the rules in a rule group. This, along with
RuleGroupResponse, define the rule group. You can retrieve all objects
for a rule group by calling DescribeRuleGroup.

AWS Network Firewall uses a rule group to inspect and control network
traffic. You define stateless rule groups to inspect individual packets
and you define stateful rule groups to inspect packets in the context
of their traffic flow.

To use a rule group, you include it by reference in an Network Firewall
firewall policy, then you use the policy in a firewall. You can
reference a rule group from more than one firewall policy, and you can
use a firewall policy in more than one firewall.

=head1 ATTRIBUTES


=head2 B<REQUIRED> RulesSource => L<Paws::NetworkFirewall::RulesSource>

The stateful rules or stateless rules for the rule group.


=head2 RuleVariables => L<Paws::NetworkFirewall::RuleVariables>

Settings that are available for use in the rules in the rule group. You
can only use these for stateful rule groups.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::NetworkFirewall>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

