# Generated by default/object.tt
package Paws::Kendra::ConfluenceConfiguration;
  use Moose;
  has AttachmentConfiguration => (is => 'ro', isa => 'Paws::Kendra::ConfluenceAttachmentConfiguration');
  has BlogConfiguration => (is => 'ro', isa => 'Paws::Kendra::ConfluenceBlogConfiguration');
  has ExclusionPatterns => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has InclusionPatterns => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has PageConfiguration => (is => 'ro', isa => 'Paws::Kendra::ConfluencePageConfiguration');
  has SecretArn => (is => 'ro', isa => 'Str', required => 1);
  has ServerUrl => (is => 'ro', isa => 'Str', required => 1);
  has SpaceConfiguration => (is => 'ro', isa => 'Paws::Kendra::ConfluenceSpaceConfiguration');
  has Version => (is => 'ro', isa => 'Str', required => 1);
  has VpcConfiguration => (is => 'ro', isa => 'Paws::Kendra::DataSourceVpcConfiguration');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Kendra::ConfluenceConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Kendra::ConfluenceConfiguration object:

  $service_obj->Method(Att1 => { AttachmentConfiguration => $value, ..., VpcConfiguration => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Kendra::ConfluenceConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->AttachmentConfiguration

=head1 DESCRIPTION

Provides configuration information for data sources that connect to
Confluence.

=head1 ATTRIBUTES


=head2 AttachmentConfiguration => L<Paws::Kendra::ConfluenceAttachmentConfiguration>

Specifies configuration information for indexing attachments to
Confluence blogs and pages.


=head2 BlogConfiguration => L<Paws::Kendra::ConfluenceBlogConfiguration>

Specifies configuration information for indexing Confluence blogs.


=head2 ExclusionPatterns => ArrayRef[Str|Undef]

A list of regular expression patterns that apply to a URL on the
Confluence server. An exclusion pattern can apply to a blog post, a
page, a space, or an attachment. Items that match the pattern are
excluded from the index. Items that don't match the pattern are
included in the index. If a item matches both an exclusion pattern and
an inclusion pattern, the item isn't included in the index.


=head2 InclusionPatterns => ArrayRef[Str|Undef]

A list of regular expression patterns that apply to a URL on the
Confluence server. An inclusion pattern can apply to a blog post, a
page, a space, or an attachment. Items that match the patterns are
included in the index. Items that don't match the pattern are excluded
from the index. If an item matches both an inclusion pattern and an
exclusion pattern, the item isn't included in the index.


=head2 PageConfiguration => L<Paws::Kendra::ConfluencePageConfiguration>

Specifies configuration information for indexing Confluence pages.


=head2 B<REQUIRED> SecretArn => Str

The Amazon Resource Name (ARN) of an AWS Secrets Manager secret that
contains the key/value pairs required to connect to your Confluence
server. The secret must contain a JSON structure with the following
keys:

=over

=item *

username - The user name or email address of a user with administrative
privileges for the Confluence server.

=item *

password - The password associated with the user logging in to the
Confluence server.

=back



=head2 B<REQUIRED> ServerUrl => Str

The URL of your Confluence instance. Use the full URL of the server.
For example, C<https://server.example.com:port/>. You can also use an
IP address, for example, C<https://192.168.1.113/>.


=head2 SpaceConfiguration => L<Paws::Kendra::ConfluenceSpaceConfiguration>

Specifies configuration information for indexing Confluence spaces.


=head2 B<REQUIRED> Version => Str

Specifies the version of the Confluence installation that you are
connecting to.


=head2 VpcConfiguration => L<Paws::Kendra::DataSourceVpcConfiguration>

Specifies the information for connecting to an Amazon VPC.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Kendra>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

