# Generated by default/object.tt
package Paws::AppRunner::CustomDomain;
  use Moose;
  has CertificateValidationRecords => (is => 'ro', isa => 'ArrayRef[Paws::AppRunner::CertificateValidationRecord]');
  has DomainName => (is => 'ro', isa => 'Str', required => 1);
  has EnableWWWSubdomain => (is => 'ro', isa => 'Bool', required => 1);
  has Status => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AppRunner::CustomDomain

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AppRunner::CustomDomain object:

  $service_obj->Method(Att1 => { CertificateValidationRecords => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AppRunner::CustomDomain object:

  $result = $service_obj->Method(...);
  $result->Att1->CertificateValidationRecords

=head1 DESCRIPTION

Describes a custom domain that's associated with an AWS App Runner
service.

=head1 ATTRIBUTES


=head2 CertificateValidationRecords => ArrayRef[L<Paws::AppRunner::CertificateValidationRecord>]

A list of certificate CNAME records that's used for this domain name.


=head2 B<REQUIRED> DomainName => Str

An associated custom domain endpoint. It can be a root domain (for
example, C<example.com>), a subdomain (for example,
C<login.example.com> or C<admin.login.example.com>), or a wildcard (for
example, C<*.example.com>).


=head2 B<REQUIRED> EnableWWWSubdomain => Bool

When C<true>, the subdomain C<www.I<DomainName> > is associated with
the App Runner service in addition to the base domain.


=head2 B<REQUIRED> Status => Str

The current state of the domain name association.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AppRunner>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

