#!perl -T

#
# $Id: 5a58017a60aea0284e0f2e2ec3058dc67c34c4c3 $
#

use Test::More tests => 11;

use File::Basename;

use Log::Fine;
use Log::Fine::Handle::Syslog;
use Log::Fine::Levels::Syslog;

use Sys::Syslog qw( :standard :macros );

{

        my $msg =
"This is a test message generated by the Log::Fine unit tests.  Please disregard";

        # add a handle.  Note we use the default formatter.
        my $handle = Log::Fine::Handle::Syslog->new();

        # do some validation
        isa_ok($handle, "Log::Fine::Handle");
        can_ok($handle, "name");
        can_ok($handle, "levelMap");

        ok($handle->name() =~ /\w\d+$/);

        # these should be set to their default values
        ok($handle->{mask} == $handle->levelMap()->bitmaskAll());
        ok($handle->{formatter}->isa("Log::Fine::Formatter::Basic"));

        # Syslog-specific attributes
        ok($handle->{ident} eq basename $0);
        ok($handle->{logopts} =~ /pid/);
        ok($handle->{facility} == LOG_LOCAL0);

        # write a test message
        $handle->msgWrite(INFO, $msg, 1);

        # Make sure we can't define more than one handle
        eval {
                open STDERR, '>/dev/null';
                my $console =
                    Log::Fine::Handle::Syslog->new(facility => LOG_USER,
                                                   ident    => "badhandle");
                close STDERR;
        };

        ok(defined $@);
        ok($@ =~ /One and _only_ one/);

}
