# Generated by default/object.tt
package Paws::WorkMailMessageFlow::RawMessageContent;
  use Moose;
  has S3Reference => (is => 'ro', isa => 'Paws::WorkMailMessageFlow::S3Reference', request_name => 's3Reference', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::WorkMailMessageFlow::RawMessageContent

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::WorkMailMessageFlow::RawMessageContent object:

  $service_obj->Method(Att1 => { S3Reference => $value, ..., S3Reference => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::WorkMailMessageFlow::RawMessageContent object:

  $result = $service_obj->Method(...);
  $result->Att1->S3Reference

=head1 DESCRIPTION

Provides the MIME content of the updated email message as an S3 object.
All MIME content must meet the following criteria:

=over

=item *

Each part of a multipart MIME message must be formatted properly.

=item *

Attachments must be of a content type that Amazon SES supports. For
more information, see Unsupported Attachment Types
(https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mime-types-appendix.html).

=item *

If any of the MIME parts in a message contain content that is outside
of the 7-bit ASCII character range, we recommend encoding that content.

=item *

Per RFC 5321 (https://tools.ietf.org/html/rfc5321#section-4.5.3.1.6),
the maximum length of each line of text, including the E<lt>CRLFE<gt>,
must not exceed 1,000 characters.

=item *

The message must contain all the required header fields. Check the
returned error message for more information.

=item *

The value of immutable headers must remain unchanged. Check the
returned error message for more information.

=item *

Certain unique headers can only appear once. Check the returned error
message for more information.

=back


=head1 ATTRIBUTES


=head2 B<REQUIRED> S3Reference => L<Paws::WorkMailMessageFlow::S3Reference>

The S3 reference of an email message.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::WorkMailMessageFlow>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

