
package ZCS::Admin::Elements::AuthRequest;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'urn:zimbraAdmin' }

__PACKAGE__->__set_name('AuthRequest');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    SOAP::WSDL::XSD::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %name_of :ATTR(:get<name>);
my %account_of :ATTR(:get<account>);
my %password_of :ATTR(:get<password>);

__PACKAGE__->_factory(
    [ qw(        name
        account
        password

    ) ],
    {
        'name' => \%name_of,
        'account' => \%account_of,
        'password' => \%password_of,
    },
    {
        'name' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'account' => 'ZCS::Admin::Types::Account',
        'password' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'name' => 'name',
        'account' => 'account',
        'password' => 'password',
    }
);

} # end BLOCK






} # end of BLOCK



1;


=pod

=head1 NAME

ZCS::Admin::Elements::AuthRequest

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
AuthRequest from the namespace urn:zimbraAdmin.







=head1 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * name

 $element->set_name($data);
 $element->get_name();




=item * account

 $element->set_account($data);
 $element->get_account();




=item * password

 $element->set_password($data);
 $element->get_password();





=back


=head1 METHODS

=head2 new

 my $element = ZCS::Admin::Elements::AuthRequest->new($data);

Constructor. The following data structure may be passed to new():

 {
   name =>  $some_value, # string
   account =>  { # ZCS::Admin::Types::Account
     a =>  { value => $some_value },
   },
   password =>  $some_value, # string
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

