/*
 * Unicode-Precis-Preparation
 *
 * Copyright (C) 2015, 2025 by Hatuka*nezumi - IKEDA Soji
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the same terms as Perl. For more details, see the full text of
 * the licenses at <http://dev.perl.org/licenses/>.
 *
 * This program is distributed in the hope that it will be
 * useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 */

#include <assert.h>
#include "precis_preparation.h"

/* Lines below are automatically generated.  Don't edit them manually. */
#define PROP_BLKWIDTH (6)
#define AGE_BLKWIDTH (5)
#define XPROP_BLKWIDTH (7)

#define JT_T (0x80)
#define JT_R (0x40)
#define JT_L (0x20)
#define JT_D (JT_R | JT_L)
#define JT_MASK (JT_T | JT_R | JT_L)

typedef enum {
    CCC_VIRAMA = 1,
    CH_Arabic_Indic_digits,
    CH_extended_Arabic_Indic_digits,
    CH_GERESH,
    CH_GERSHAYIM,
    CH_KERAIA,
    CH_NAKAGURO,
    CH_MIDDLEDOT,
    CH_SMALLL,
    CH_ZWJ,
    CH_ZWNJ,
    SC_Greek,
    SC_Han,
    SC_Hebrew,
    SC_Hiragana,
    SC_Katakana
} xprop_t;


/* Lines below are automatically generated. Don't edit them manually. */
static U16 precis_prop_index[] = {
    0, 33, 96, 160, 216, 279, 343, 403, 343, 343, 359, 465, 343, 527, 591,
    639, 343, 343, 701, 343, 717, 766, 823, 885, 949, 1013, 343, 1070,
    1134, 1187, 1201, 1265, 1329, 1393, 1449, 1479, 343, 1519, 1579, 1639,
    1702, 1764, 1827, 1887, 1951, 2011, 2073, 2135, 2199, 2259, 2323, 2383,
    2447, 2506, 2570, 2634, 2697, 2761, 2824, 2888, 2952, 3014, 3077, 3139,
    343, 3203, 3237, 3295, 3359, 3359, 3359, 3359, 343, 3423, 3478, 3540,
    3587, 3624, 3688, 3720, 32, 343, 343, 343, 343, 343, 343, 343, 343,
    3222, 3784, 3816, 3880, 3944, 4008, 4062, 4126, 4158, 4222, 4270, 4334,
    4398, 4462, 4516, 4580, 4613, 4676, 4739, 343, 4803, 343, 4867, 4931,
    4995, 5059, 5123, 5187, 5247, 5304, 343, 343, 343, 5368, 343, 5410,
    5468, 5532, 5594, 5658, 5705, 5757, 5820, 5884, 5920, 5981, 5997, 5997,
    5997, 5997, 5997, 5997, 5997, 5997, 5997, 6019, 6083, 5997, 5997, 5997,
    5997, 5997, 5997, 5997, 5997, 5997, 5997, 5997, 5997, 5997, 5997, 5997,
    5997, 5997, 5997, 5997, 5997, 5997, 5997, 5997, 5997, 5997, 5997, 5997,
    6115, 6169, 5997, 343, 6233, 343, 6295, 6359, 6407, 6470, 6502, 5887,
    6566, 6630, 6009, 5997, 5997, 5997, 6672, 6731, 6795, 6836, 6869, 6933,
    6982, 7031, 7095, 7159, 5997, 5997, 5997, 5997, 5997, 5997, 5997, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 5997, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 7223, 7280, 343, 343, 343, 343, 7329, 7393, 6265, 7456, 7520, 294,
    7543, 7593, 7651, 7715, 343, 7779, 3221, 7840, 343, 7904, 7968, 8032,
    343, 8093, 8156, 8204, 343, 8252, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 8316,
    8373, 3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359,
    3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359,
    3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359,
    3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359,
    3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359,
    3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359,
    3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359,
    3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359,
    3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359,
    3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359,
    3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359, 3359,
    3359, 5997, 5997, 5997, 5997, 8437, 6121, 5997, 8479, 8543, 8607, 5997,
    8668, 5997, 5997, 5997, 5997, 5997, 5997, 8716, 8772, 8836, 8884, 5997,
    8938, 5996, 5997, 9002, 9065, 9129, 9192, 343, 9256, 9320, 5997, 9375,
    9423, 9485, 9485, 9549, 9596, 9660, 9723, 9787, 9847, 343, 343, 9911,
    9959, 10023, 10071, 10119, 10183, 343, 343, 343, 343, 7968, 10247,
    10311, 9485, 10375, 10438, 10502, 10550, 10614, 9485, 10678, 8716,
    10740, 10804, 10836, 10900, 10964, 11028, 11092, 9485, 343, 11156,
    1200, 11220, 11284, 11348, 11406, 9485, 9485, 11438, 11502, 11564,
    11624, 11672, 11730, 11789, 343, 11853, 11916, 11978, 712, 12042, 343,
    12106, 12170, 12232, 12296, 12344, 12408, 12467, 12531, 12594, 343,
    12658, 343, 12722, 9485, 9485, 12786, 12849, 343, 12913, 12977, 13041,
    13105, 13169, 9485, 9485, 13233, 9485, 9224, 13297, 13360, 13420,
    13452, 13494, 344, 13558, 13596, 4158, 13660, 9485, 9485, 13724, 13788,
    13851, 13901, 9485, 13965, 14028, 14077, 9485, 9485, 9485, 9485, 14119,
    14183, 14245, 14272, 14336, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 14400, 9485, 5997, 14464, 343, 343, 343,
    14528, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 7377, 14592, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 48, 14656,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 9256, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 13169, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    14688, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 343, 343, 343, 343, 343, 343, 343, 343,
    4158, 14752, 6796, 14806, 352, 14870, 14931, 9485, 9485, 9485, 9485,
    9485, 9485, 14995, 9485, 9485, 9485, 343, 15059, 9485, 343, 15123,
    15179, 15211, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    15275, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 15309, 11156, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 15373, 343, 343, 343, 343, 15437, 15488, 343, 343, 343,
    343, 343, 15536, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 343, 15553, 15605, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 5997, 5997, 5997, 6003,
    5997, 5997, 5997, 5997, 5997, 5997, 6009, 9485, 1152, 15669, 5997,
    15729, 5997, 5997, 5997, 6007, 8693, 15793, 15854, 6018, 5997, 15916,
    9485, 15980, 5997, 16044, 9485, 9485, 5997, 16108, 16143, 16204, 16262,
    16326, 5997, 5997, 5997, 5997, 8694, 5997, 5997, 5997, 5997, 16378,
    5997, 5997, 5997, 5997, 5997, 5997, 5997, 5997, 16442, 16501, 16561,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 16625, 9485, 9485, 9485, 16689, 6015,
    15357, 9485, 16753, 16805, 9485, 9485, 9485, 9485, 16853, 9257, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 16901, 9485, 9485, 9485, 16959,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 17023, 343, 343, 343, 17081,
    343, 17145, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 15744, 6008, 9485, 8937, 9485, 9485, 9485, 17209, 17271, 17335,
    17395, 9485, 9485, 9485, 9485, 17459, 5997, 17507, 17555, 5997, 5997,
    6015, 11432, 17606, 17657, 9485, 9485, 5997, 5997, 5997, 5997, 5997,
    5997, 5997, 5997, 5997, 5997, 5997, 5997, 5997, 5997, 5997, 17721,
    5997, 17785, 5997, 17844, 17908, 17964, 18020, 18078, 5997, 5997, 5997,
    5997, 5997, 18142, 18193, 18250, 5997, 5997, 18314, 6003, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 18378, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 15299, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 14688, 343, 343, 343, 1168, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 1217, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 18442, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 15301, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 5997, 5997, 5997, 5997,
    5997, 5997, 5997, 5997, 6566, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 18378, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 4254, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 15283, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485, 9485,
    18378
};

/* Lines below are automatically generated. Don't edit them manually. */
static U8 precis_prop_array[] = {
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_DISALLOWED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_CONTEXTO, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_DISALLOWED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_CONTEXTO,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_CONTEXTO, PRECIS_CONTEXTO, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_DISALLOWED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_DISALLOWED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_CONTEXTO,
    PRECIS_CONTEXTO, PRECIS_CONTEXTO, PRECIS_CONTEXTO, PRECIS_CONTEXTO,
    PRECIS_CONTEXTO, PRECIS_CONTEXTO, PRECIS_CONTEXTO, PRECIS_CONTEXTO,
    PRECIS_CONTEXTO, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_DISALLOWED, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_CONTEXTO, PRECIS_CONTEXTO, PRECIS_CONTEXTO, PRECIS_CONTEXTO,
    PRECIS_CONTEXTO, PRECIS_CONTEXTO, PRECIS_CONTEXTO, PRECIS_CONTEXTO,
    PRECIS_CONTEXTO, PRECIS_CONTEXTO, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_DISALLOWED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_DISALLOWED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_DISALLOWED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_DISALLOWED, PRECIS_CONTEXTJ, PRECIS_CONTEXTJ,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_UNASSIGNED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_ID_DIS, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_DISALLOWED, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_CONTEXTO, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_DISALLOWED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_DISALLOWED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_DISALLOWED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_DISALLOWED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_DISALLOWED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID
};

static U8 precis_prop_lookup(U32 cp)
{
    if ((cp & 0x00FFFE) == 0x00FFFE
	|| cp == 0x0E0001 || (0x0E0020 <= cp && cp <= 0x0E007F)
	|| (0x0E0100 <= cp && cp <= 0x0E01EF)
	|| (0x0F0000 <= cp && cp <= 0x0FFFFD)
	|| (0x100000 <= cp && cp <= 0x10FFFD))
	return PRECIS_DISALLOWED;
    else if (0x040000 <= cp)
	return PRECIS_UNASSIGNED;

    return precis_prop_array[precis_prop_index[cp >> PROP_BLKWIDTH] +
			     (cp & ((1 << PROP_BLKWIDTH) - 1))
	];
}

/* Lines below are automatically generated. Don't edit them manually. */
static U16 precis_age_index[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 36, 68, 98, 0, 0, 121,
    1, 143, 0, 0, 175, 207, 0, 0, 239, 269, 301, 0, 317, 0, 347, 0, 374,
    394, 426, 454, 0, 486, 510, 540, 568, 471, 600, 632, 664, 696, 0, 712,
    744, 762, 794, 813, 834, 852, 884, 899, 931, 936, 968, 986, 1018, 1050,
    1067, 1099, 1129, 1158, 1190, 1196, 1224, 1248, 1280, 1283, 1313, 1328,
    1359, 0, 1374, 1392, 1415, 0, 0, 1446, 0, 1291, 1478, 1508, 0, 1532,
    1375, 1548, 1580, 1592, 1622, 1652, 1684, 1689, 1719, 1749, 1781, 1804,
    1834, 1866, 1898, 1924, 1956, 1988, 0, 0, 0, 0, 2014, 2038, 2065, 0,
    2097, 2097, 2121, 2143, 2163, 2188, 2218, 0, 884, 2250, 2282, 2308,
    2314, 0, 2346, 2360, 0, 0, 2392, 0, 0, 2415, 0, 2423, 2455, 884, 2480,
    884, 2512, 2472, 2543, 2567, 2584, 884, 2608, 2639, 2671, 884, 884,
    2703, 2735, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884,
    884, 884, 884, 884, 884, 884, 2744, 2776, 884, 884, 2808, 2840, 2872,
    2875, 2907, 884, 884, 2939, 2971, 3003, 884, 884, 3035, 884, 3067, 968,
    3083, 3115, 3147, 3179, 3197, 3229, 3251, 3273, 3305, 3337, 968, 969,
    971, 3369, 3401, 3432, 0, 931, 931, 3464, 3480, 2308, 3512, 3544, 3556,
    2308, 3588, 3602, 2308, 3634, 3650, 3682, 3698, 3305, 3305, 3305, 3325,
    3229, 3229, 3730, 3755, 0, 0, 0, 0, 3787, 0, 0, 3819, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 744, 3851, 3882, 3900, 3929, 3961, 3991, 0, 4008, 4037, 0,
    4066, 0, 0, 4087, 0, 0, 0, 0, 0, 0, 0, 4119, 4151, 0, 0, 4156, 4185,
    4212, 4229, 4257, 0, 4289, 0, 0, 0, 0, 0, 4310, 0, 0, 0, 0, 4299, 0, 0,
    4342, 4374, 0, 0, 4400, 4432, 4464, 4489, 4519, 4551, 4575, 4595, 4626,
    4648, 4672, 4704, 4724, 884, 884, 884, 884, 884, 884, 884, 884, 4212,
    4212, 4212, 4212, 4212, 4212, 4212, 4212, 4212, 4212, 4212, 4212, 4212,
    4212, 4212, 4212, 4756, 4779, 4798, 4824, 4846, 4870, 4899, 4919, 3229,
    4951, 4967, 4999, 3229, 3229, 3229, 5031, 3229, 5057, 3229, 5083, 5115,
    5147, 5147, 2308, 5179, 5209, 5238, 0, 5270, 884, 884, 5297, 884, 884,
    884, 884, 884, 884, 5329, 5351, 0, 5383, 0, 0, 5414, 5445, 0, 5446, 0,
    5478, 0, 0, 0, 5510, 850, 5542, 5574, 0, 5605, 5637, 0, 4304, 5668,
    5684, 0, 0, 0, 5716, 0, 0, 5743, 1281, 884, 884, 884, 884, 884, 884,
    884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884,
    884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884,
    884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884,
    884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884,
    884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884,
    884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884,
    884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884,
    884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884,
    884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884,
    884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884,
    884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884,
    884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884,
    884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884,
    884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884,
    884, 884, 884, 5775, 3305, 3305, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5807, 5835, 5857, 884,
    884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884,
    884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884, 884,
    884, 884, 884, 884, 884, 884, 884, 1908, 5889, 5920, 968, 2308, 2308,
    2308, 2308, 2308, 2308, 2308, 2308, 2308, 5952, 2308, 5984, 6012, 968,
    968, 6044, 6076, 6101, 2308, 2308, 6120, 6152, 6184, 6213, 3229, 6245,
    931, 6277, 2308, 2308, 6309, 6341, 2308, 2308, 6373, 6405, 968, 968,
    6437, 6469, 2308, 6501, 6533, 6565, 968, 968, 6597, 6629, 6660, 6692,
    6708, 6740, 6756, 6756, 968, 6788, 2097, 2097, 2097, 2097, 2097, 2097,
    2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097,
    2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097,
    2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097,
    2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097,
    2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097,
    2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097,
    2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097,
    2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097,
    2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097,
    2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097,
    2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097,
    2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097,
    2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097,
    2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097,
    2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097,
    2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097,
    2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097,
    2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097,
    2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097,
    2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097,
    2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097,
    2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097,
    2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097,
    2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097,
    2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097,
    2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097,
    2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097,
    2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097,
    2097, 2097, 2097, 2097, 2097, 2097, 2097, 6820, 6845, 6856, 2097, 2097,
    2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097,
    2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097,
    2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097,
    2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097,
    2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097,
    2097, 2097, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6884,
    4212, 6905, 3229, 3229, 2671, 0, 6937, 0, 0, 0, 0, 6967, 6997, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 7029, 0, 0, 0, 7046, 7062, 7094, 7122, 7149,
    5458, 0, 0, 0, 0, 0, 0, 5446, 5445, 0, 0, 0, 7158, 7190, 7195, 7226, 0,
    3305, 3305, 3305, 7258, 7290, 7302, 3229, 3229, 7334, 1280, 7363, 7379,
    0, 0, 0, 0, 7380, 2308, 7392, 7424, 7456, 7488, 7509, 7525, 7557, 3229,
    7589, 0, 7621, 7647, 7665, 3305, 7679, 7699, 7715, 7739, 6708, 7771,
    6708, 7799, 7815, 7835, 7867, 7879, 6708, 6708, 6708, 6708, 6708, 6708,
    6708, 6708, 6708, 7911, 7912, 7926, 7958, 7973, 0, 0, 8005, 8015, 8047,
    6708, 6469, 8079, 0, 8111, 8143, 8175, 0, 0, 8207, 8215, 8247, 6756,
    8279, 8304, 8335, 968, 6708, 0, 6708, 8367, 968, 6412, 978, 8399, 8431,
    8460, 0, 0, 968, 968, 8492, 0, 6756, 8524, 6756, 8556, 8588, 8612,
    7867, 8644, 8670, 0, 0, 0, 0, 0, 0, 969, 8702, 8724, 8754, 8759, 8588,
    8791, 8594, 7013, 8823, 8686, 8855, 8887, 3544, 3544, 8919, 8937, 968,
    968, 8969, 8992, 8207, 9024, 9052, 7911, 8207, 8207, 9084, 9116, 9148,
    9167, 9198, 0, 9230, 9261, 6708, 9282, 9314, 9337, 9365, 9394, 9426,
    9442, 9473, 9495, 9527, 9527, 9533, 9565, 6708, 6708, 9597, 0, 0, 0, 0,
    0, 6708, 9629, 9653, 0, 6708, 6708, 9685, 9717, 8207, 9749, 9781, 9809,
    9841, 9870, 9902, 0, 0, 0, 0, 0, 8588, 8592, 0, 0, 0, 6708, 6708, 9934,
    9966, 9990, 10017, 0, 0, 10049, 10059, 10086, 10118, 10118, 10142,
    10118, 10170, 10200, 6708, 10232, 10264, 0, 0, 0, 0, 0, 7867, 10296,
    10328, 10338, 10364, 10383, 10399, 10423, 0, 0, 10455, 10466, 10497,
    10529, 10546, 10578, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8595, 10610, 10628,
    10658, 0, 0, 10685, 10717, 10731, 931, 931, 931, 931, 931, 931, 931,
    931, 931, 931, 931, 931, 931, 931, 931, 931, 931, 931, 931, 931, 931,
    931, 931, 931, 931, 931, 931, 10763, 10778, 0, 0, 0, 931, 931, 931,
    10810, 6756, 6756, 6756, 6756, 6756, 6756, 10842, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7013, 10874, 10874, 10887, 968, 968, 968, 968, 968, 968, 968,
    968, 968, 968, 968, 968, 968, 968, 968, 968, 968, 968, 968, 968, 968,
    968, 968, 968, 968, 968, 968, 968, 968, 968, 968, 968, 968, 10919,
    10944, 7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867,
    7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867,
    7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867,
    7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867,
    7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867,
    7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867,
    7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867,
    7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867,
    7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867,
    7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867,
    7867, 7867, 7867, 7867, 7867, 7867, 7872, 6756, 6756, 6756, 6756, 6756,
    6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756,
    6756, 10976, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7867, 7873, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3544, 3544, 3544, 3544, 3544, 3544,
    3544, 3544, 3544, 3544, 3544, 3544, 3544, 3544, 3544, 3544, 3544, 3551,
    6469, 11008, 10874, 10875, 11030, 11048, 6708, 6708, 11064, 11088,
    7918, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7867, 7873, 0, 0, 0, 0, 0,
    0, 8588, 8588, 8593, 0, 0, 0, 8207, 8207, 11120, 11136, 11167, 0, 0,
    11199, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527,
    9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527,
    9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527,
    9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527,
    9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527,
    9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527,
    9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527,
    9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527,
    9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527,
    9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527,
    9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527,
    9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527,
    9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527,
    9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527,
    9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527,
    9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527,
    9527, 11231, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527,
    9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527,
    9527, 9527, 11263, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702,
    8702, 8702, 8702, 8702, 8702, 8702, 11282, 11304, 11295, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 11336, 11368, 10118, 10118, 10118, 10118,
    10118, 10118, 10118, 11370, 11401, 11420, 11448, 10118, 10118, 10118,
    10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10122, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6708,
    6708, 6708, 11480, 11500, 11528, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7867, 7867, 7867, 7867, 7867,
    7867, 7867, 7873, 7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867, 7867,
    7867, 7867, 7867, 7867, 7879, 0, 0, 10874, 11560, 11585, 10874, 10874,
    10874, 11613, 0, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 11645, 7621,
    11677, 7621, 7621, 7621, 7621, 11687, 11717, 3229, 3229, 6931, 0, 0, 0,
    11749, 11781, 3305, 3305, 11813, 11845, 0, 0, 0, 0, 7621, 7621, 11877,
    7621, 11899, 11931, 11962, 7621, 11988, 11968, 12018, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 12046, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 12068, 7621, 6756, 6756, 6756, 6756,
    6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756,
    6756, 6756, 6756, 6756, 12100, 12126, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    10875, 12153, 0, 0, 0, 0, 0, 0, 12185, 12215, 12231, 12249, 11404, 0,
    0, 0, 10717, 12281, 12301, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7013, 11602,
    10717, 12333, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10594, 12237,
    0, 0, 0, 0, 0, 0, 12365, 12381, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 12413, 6708, 6708, 6708, 6708, 6708, 6708, 12445, 0, 9527, 9527,
    12477, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 12509, 8588, 12526, 0, 0, 10716, 10719, 0, 0, 0, 0, 0, 0,
    12558, 12590, 12620, 12650, 12682, 12713, 0, 12741, 0, 0, 0, 0, 0, 0,
    0, 0, 2308, 12773, 2308, 2308, 7389, 12805, 12837, 7912, 12869, 12886,
    12918, 12950, 12982, 13009, 0, 13035, 13067, 13083, 13115, 13147, 0, 0,
    0, 0, 3544, 13179, 3544, 13202, 13234, 3544, 13266, 13298, 3544, 13330,
    13360, 3544, 3544, 3544, 3544, 13368, 3544, 13400, 13432, 13456, 6708,
    13478, 6708, 13483, 13515, 13547, 13578, 6708, 3544, 3544, 13610,
    13642, 3544, 3544, 3544, 13674, 6708, 6708, 13706, 13738, 13770, 6708,
    9597, 6708, 7771, 13788, 13814, 0, 13846, 13878, 13910, 13941, 13973,
    14002, 14034, 14059, 10717, 10717, 10729, 14077, 14109, 14132, 14164,
    14196, 8702, 8702, 8702, 8702, 14228, 8702, 14249, 14265, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 14291, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 14323, 0, 968, 968, 968, 968, 968, 968,
    968, 968, 968, 968, 968, 968, 968, 968, 968, 968, 968, 968, 968, 968,
    968, 968, 968, 968, 968, 968, 968, 968, 968, 968, 968, 968, 968, 968,
    968, 968, 968, 968, 968, 968, 968, 968, 968, 968, 968, 968, 968, 968,
    968, 968, 968, 968, 968, 968, 968, 968, 968, 968, 968, 968, 968, 968,
    968, 968, 968, 968, 968, 968, 968, 968, 968, 968, 968, 968, 968, 968,
    968, 968, 968, 968, 968, 968, 968, 968, 968, 968, 968, 968, 968, 968,
    968, 968, 968, 968, 968, 968, 968, 968, 968, 968, 968, 968, 968, 968,
    968, 968, 968, 968, 968, 968, 968, 968, 968, 968, 968, 968, 968, 968,
    968, 968, 968, 968, 968, 968, 968, 968, 968, 968, 968, 14355, 3544,
    3544, 3544, 3544, 3544, 3544, 3546, 6756, 6756, 6756, 6756, 6756, 6756,
    6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756,
    6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756,
    6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756,
    6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756,
    6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756,
    6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756,
    6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756,
    6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756,
    6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756,
    6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756,
    6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756,
    6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756,
    6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756,
    6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756, 6756,
    6756, 6756, 6756, 6756, 6756, 6756, 14387, 10118, 10118, 10118, 10118,
    10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118,
    10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118,
    10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118,
    10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118,
    10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118,
    10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118,
    10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118,
    10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118,
    10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118,
    10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118,
    10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118,
    10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118,
    10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118,
    10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118,
    10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118,
    10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118,
    10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118,
    10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118,
    10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118,
    10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118,
    10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118,
    10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118,
    10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 10118, 14418,
    14434, 14434, 14434, 14434, 14434, 14434, 14434, 14434, 14434, 14434,
    14434, 14434, 14434, 14434, 14434, 14434, 14434, 14434, 14436, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621, 7621,
    7621, 7621, 7621, 7621, 7621, 14468, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14291, 8702, 8702, 8702, 8702, 8702,
    8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702,
    8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702,
    8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702,
    8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702,
    8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702,
    8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702,
    8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702,
    8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702,
    8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702,
    8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702,
    8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702,
    8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702, 8702,
    8702, 8702, 8702, 8702, 8702, 14500, 12231, 12231, 12231, 12231, 12231,
    12231, 12231, 12231, 12231, 12231, 12231, 12231, 12231, 12231, 12231,
    12231, 12231, 12231, 12231, 12231, 12231, 12231, 12231, 12231, 12231,
    12231, 12231, 12231, 12231, 12231, 12231, 12231, 12231, 12231, 12231,
    12231, 12231, 12231, 12231, 12231, 12231, 12231, 12231, 12231, 12231,
    12231, 12231, 12231, 12231, 12231, 12231, 12231, 12231, 12231, 12231,
    12231, 12231, 12231, 12231, 12231, 12231, 12231, 12231, 12231, 12231,
    12231, 12231, 12231, 12231, 12231, 12231, 12231, 12231, 12231, 12231,
    12231, 12231, 12231, 12231, 12231, 12231, 12231, 12231, 12231, 12231,
    12231, 12231, 12231, 12231, 12231, 12231, 12231, 12231, 12231, 12231,
    12231, 12231, 12231, 12231, 12231, 12231, 12231, 12231, 12231, 12231,
    12231, 12231, 12231, 12231, 12231, 12231, 12231, 12231, 12231, 12231,
    12231, 12231, 12231, 12231, 12231, 12231, 12231, 12231, 12231, 12231,
    12231, 12231, 12231, 12231, 12231, 12247, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    14291
};

/* Lines below are automatically generated. Don't edit them manually. */
static U16 precis_age_array[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0x0300, 0x0300, 0x0300, 0x0300, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0302, 0x0400,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0400, 0x0400, 0x0400, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0401, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500,
    0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0400, 0x0400, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0400, 0x0400,
    0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400,
    0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0, 0, 0, 0, 0, 0,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0302, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400,
    0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0400, 0x0400, 0x0400, 0, 0,
    0x0300, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302,
    0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0501, 0x0501, 0x0501, 0x0501,
    0, 0, 0x0501, 0x0501, 0, 0, 0, 0x0500, 0x0500, 0x0500, 0, 0x0700, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0501, 0, 0, 0, 0, 0, 0, 0,
    0x0300, 0x0302, 0x0302, 0, 0x0300, 0, 0x0300, 0, 0x0300, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0301, 0x0301, 0x0302, 0x0400,
    0x0400, 0x0400, 0x0400, 0x0400, 0x0401, 0x0401, 0x0401, 0x0401, 0x0300,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0300, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0300, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x0300, 0, 0, 0, 0, 0, 0, 0, 0x0501, 0x0300, 0x0300, 0x0302, 0x0302,
    0x0300, 0x0300, 0x0300, 0x0300, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0x0302, 0x0302, 0, 0, 0x0302, 0x0302, 0, 0, 0x0302, 0x0302,
    0x0500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0300, 0x0300,
    0, 0, 0, 0, 0, 0, 0, 0, 0x0401, 0x0401, 0, 0, 0x0500, 0x0500, 0x0500,
    0x0500, 0x0500, 0x0500, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302,
    0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302,
    0x0302, 0x0500, 0x0500, 0x0500, 0x0500, 0x0501, 0x0501, 0x0501, 0x0501,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0502,
    0x0502, 0x0600, 0x0600, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0b00,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0x0b00, 0, 0x0300, 0, 0, 0x0700, 0x0700, 0x0601,
    0, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200,
    0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0401, 0x0200,
    0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200,
    0x0200, 0x0200, 0x0200, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0500, 0, 0, 0,
    0, 0, 0x0200, 0x0401, 0x0401, 0x0401, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0400, 0x0400, 0x0400, 0x0400,
    0x0601, 0x0700, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0401, 0,
    0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0, 0x0603, 0x0e00, 0x0401, 0,
    0x0600, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0300, 0x0300, 0x0300,
    0x0400, 0x0400, 0x0400, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401,
    0x0600, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0302, 0x0302, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x0300, 0x0300, 0, 0, 0, 0, 0, 0x0300, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0x0300, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x0400, 0x0400, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0400, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0400,
    0x0400, 0x0400, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0, 0, 0x0400, 0x0400, 0x0400, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501,
    0x0501, 0x0501, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0302, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0500, 0x0500, 0x0500, 0x0500,
    0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500,
    0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500,
    0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500,
    0x0500, 0, 0, 0x0b00, 0x0b00, 0x0b00, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0, 0, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0, 0, 0x0600, 0, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00,
    0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0, 0, 0, 0, 0, 0x0e00,
    0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00,
    0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0, 0x0e00, 0x0e00, 0,
    0, 0, 0, 0, 0x1000, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00,
    0x0e00, 0x0e00, 0x0601, 0x0700, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601,
    0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0800, 0x0800, 0x0e00, 0x0900, 0x0900, 0x0900,
    0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0d00, 0x0d00, 0x0d00, 0x0d00,
    0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00,
    0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0b00, 0x0900, 0x0900,
    0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900,
    0x0900, 0x0800, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601,
    0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601,
    0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601,
    0x0601, 0x0601, 0x0700, 0x0502, 0, 0, 0, 0x0400, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0600,
    0x0600, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0502, 0x0600, 0, 0,
    0, 0, 0, 0x0502, 0x0600, 0x0600, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0x0501, 0x0501, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0700, 0x0502, 0x0502, 0x0500, 0x0500, 0x0401, 0x0500, 0x0500, 0x0700,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0x0400, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x0401, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0x0502, 0x0a00, 0x0a00, 0x0b00, 0, 0x0400, 0, 0x0400,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0x0501, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0x0501, 0x0b00, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0400,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0400,
    0x0400, 0x0400, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0601, 0x0400, 0,
    0, 0, 0, 0, 0, 0, 0x0800, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00,
    0x0a00, 0, 0, 0, 0, 0x0501, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0x0d00, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0501, 0x0501, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0400, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0x0401, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0400, 0x0400,
    0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0, 0, 0, 0, 0, 0x0700,
    0, 0, 0, 0x0b00, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0700, 0, 0, 0, 0, 0, 0, 0, 0x0e00, 0x0501,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x0501, 0x0501, 0x0800, 0, 0, 0x0e00, 0, 0, 0x0501, 0x0501, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0c00, 0x0501, 0x0501,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0900, 0x0700, 0, 0,
    0x0b00, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0x0400, 0x0400, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0e00, 0, 0,
    0x0500, 0x0500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0500, 0x0500,
    0x0f00, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0a00, 0x0700, 0, 0,
    0x0d00, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0x0600, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0x0600, 0x0a00, 0x0a00, 0x0501, 0, 0, 0, 0, 0x0501, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0x0600, 0x0900, 0, 0, 0, 0, 0x0900, 0x0900, 0x0900, 0,
    0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0800, 0, 0,
    0x0501, 0x0501, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0501, 0x0501,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0900, 0x0900, 0x0900, 0x0501, 0x0501,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0, 0x0d00, 0x0300, 0x0300, 0,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0, 0, 0, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0, 0x0300, 0, 0, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0, 0, 0, 0x0300, 0, 0, 0, 0, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0, 0x0300, 0, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0, 0, 0, 0, 0, 0,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0, 0, 0x0300, 0x0300, 0x0300, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x0c00, 0, 0, 0x0c00, 0, 0, 0x0c00, 0, 0x0c00, 0x0c00, 0x0c00, 0x0c00,
    0x0c00, 0x0c00, 0, 0, 0, 0, 0x0c00, 0, 0, 0, 0, 0, 0, 0, 0x0c00,
    0x0c00, 0, 0, 0x0c00, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0c00, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0f00, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0x0601, 0x0601, 0x0200, 0x0200, 0x0200, 0x0200,
    0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200,
    0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200,
    0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200,
    0x0200, 0, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200,
    0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200,
    0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0300, 0x0501,
    0x0501, 0, 0, 0, 0, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200,
    0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200,
    0x0200, 0x0300, 0x0200, 0, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200,
    0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200,
    0x0300, 0x0300, 0x0300, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200,
    0x0200, 0x0300, 0x0200, 0x0300, 0x0300, 0x0300, 0, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0, 0x0501, 0x0300, 0x0401, 0x0401, 0x0501, 0x0501,
    0x0501, 0x0502, 0x0502, 0x0502, 0x0502, 0x0600, 0x0600, 0, 0, 0, 0, 0,
    0x0300, 0x0300, 0x0501, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0501,
    0x0300, 0x0300, 0x0501, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0501, 0x0501, 0x0501, 0x0300, 0x0300, 0x0300, 0x0300, 0x0501,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0501, 0x0501, 0, 0, 0, 0, 0, 0, 0,
    0x0601, 0, 0, 0, 0, 0, 0x0601, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0302, 0x0302, 0x0401, 0x0401, 0,
    0x0401, 0x0601, 0x0601, 0x0601, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0401, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0401, 0x0300, 0, 0x0300, 0x0300,
    0x0300, 0x0300, 0, 0, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0, 0x0300, 0, 0x0300, 0x0300, 0x0300, 0x0300, 0, 0, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0401, 0x0300, 0,
    0x0300, 0x0300, 0x0300, 0x0300, 0, 0, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0, 0x0300, 0x0300, 0x0300, 0x0300, 0, 0,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0401, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0401, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0401, 0x0300, 0, 0x0300, 0x0300, 0x0300,
    0x0300, 0, 0, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0401, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0, 0, 0x0600, 0x0600, 0x0401, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0, 0, 0,
    0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0, 0,
    0, 0, 0, 0, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0800, 0, 0, 0x0800, 0x0800,
    0x0800, 0x0800, 0x0800, 0x0800, 0, 0, 0x0502, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0, 0, 0, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0, 0, 0, 0, 0, 0, 0, 0x0302, 0x0302, 0x0302,
    0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302,
    0x0302, 0x0e00, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302,
    0x0e00, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0e00, 0x0302, 0x0302, 0x0302,
    0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302,
    0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302,
    0x0302, 0x0302, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0302, 0x0302,
    0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302,
    0x0302, 0x0302, 0, 0x0302, 0x0302, 0x0302, 0, 0x0302, 0x0302, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0400, 0, 0, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0, 0, 0, 0, 0, 0, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400,
    0x0400, 0x0400, 0x0400, 0x0400, 0, 0, 0, 0, 0, 0, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0e00, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0, 0, 0, 0, 0, 0,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0b00, 0, 0, 0, 0, 0,
    0, 0, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0501, 0, 0, 0, 0, 0, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400,
    0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400,
    0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400,
    0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0700, 0x0700, 0,
    0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400,
    0x0400, 0x0400, 0x0400, 0, 0, 0, 0, 0x0400, 0x0400, 0x0400, 0x0400,
    0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0, 0,
    0, 0, 0x0400, 0, 0, 0, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400,
    0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400,
    0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400,
    0x0400, 0x0400, 0x0400, 0x0400, 0, 0, 0x0400, 0x0400, 0x0400, 0x0400,
    0x0400, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0401, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0502, 0x0502, 0, 0, 0, 0, 0x0401, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0401, 0x0401, 0, 0, 0, 0, 0, 0, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0502,
    0, 0, 0, 0x0401, 0x0401, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400,
    0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400,
    0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400,
    0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400,
    0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401,
    0x0401, 0, 0, 0x0401, 0x0401, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0, 0, 0, 0, 0, 0, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0, 0, 0, 0, 0, 0, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0, 0,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0d00, 0x0e00, 0x0e00,
    0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00,
    0x0e00, 0x0e00, 0x0e00, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500,
    0x0500, 0x0500, 0x0500, 0x0500, 0x0e00, 0, 0x1000, 0x1000, 0x0500,
    0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500,
    0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500,
    0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500,
    0x0500, 0x0e00, 0x0e00, 0x1000, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0601, 0x0601, 0x0601,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501,
    0x0501, 0x0501, 0x0501, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0, 0, 0, 0, 0, 0, 0, 0, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501,
    0, 0, 0, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501,
    0x0501, 0x0501, 0x0501, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900,
    0x0900, 0x0900, 0x0900, 0x1000, 0x1000, 0, 0, 0, 0, 0, 0x0b00, 0x0b00,
    0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00,
    0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00,
    0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0, 0, 0x0b00,
    0x0b00, 0x0b00, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601,
    0x0601, 0, 0, 0, 0, 0, 0, 0, 0, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0601, 0x0601, 0x0601, 0x0601,
    0x0a00, 0x0700, 0x0700, 0x0c00, 0, 0, 0, 0, 0, 0x0401, 0x0401, 0x0401,
    0x0401, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0501,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501,
    0x0501, 0x0501, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0a00,
    0x0a00, 0x0a00, 0x0a00, 0x0e00, 0x0900, 0x0600, 0x0502, 0x0500, 0x0500,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0x0200, 0x0501, 0x0501, 0x0501, 0x0501, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0501,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0, 0, 0, 0, 0, 0, 0, 0x0302,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0302, 0x0302, 0x0302,
    0x0302, 0x0302, 0x0400, 0x0400, 0x0401, 0x0401, 0x0302, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0302, 0x0302, 0x0302, 0x0302,
    0x0501, 0, 0x0603, 0x0603, 0x0603, 0x0603, 0, 0, 0, 0, 0, 0, 0, 0x0302,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0401, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0200, 0x0201, 0x0300,
    0x0300, 0x0300, 0x0302, 0x0302, 0x0401, 0x0401, 0x0401, 0x0401, 0x0502,
    0x0502, 0x0502, 0x0600, 0x0602, 0x0700, 0x0700, 0x0700, 0x0800, 0x0a00,
    0x0e00, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0300, 0x0300, 0x0302, 0x0302, 0x0302,
    0x0302, 0x0302, 0x0302, 0x0302, 0x0401, 0x0500, 0x0500, 0x0500, 0x0500,
    0x0501, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0x0300, 0x0300, 0x0400, 0x0401, 0x0302, 0x0302, 0x0302,
    0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302,
    0x0401, 0x0500, 0x0500, 0x0501, 0x0502, 0x0502, 0x0502, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0x0300, 0x0500, 0x0501, 0x0501, 0x0501, 0x0501,
    0x0502, 0x0800, 0x0800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302,
    0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302,
    0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0,
    0x0300, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0300, 0x0302, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0302, 0x0302, 0x0302,
    0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302,
    0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302,
    0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302,
    0x0302, 0x0302, 0x0400, 0x0400, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0500, 0x0500, 0x0500,
    0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0502, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0900, 0x0900, 0x0900,
    0x0900, 0x0a00, 0, 0, 0, 0, 0, 0x0300, 0x0300, 0x1000, 0x1000, 0x1000,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302,
    0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302,
    0x0302, 0x0302, 0x0400, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0302,
    0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0400, 0x0400, 0x0302,
    0x0302, 0x0401, 0x0300, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x0300, 0x0300, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302,
    0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0401, 0x0401, 0x0302, 0x0302,
    0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0400,
    0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401,
    0x0501, 0x0502, 0x0502, 0x0400, 0x0400, 0x0401, 0x0401, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0401, 0x0500, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0600, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0600, 0x0502, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0700, 0, 0, 0, 0, 0x0600, 0, 0, 0, 0, 0x0600, 0x0600, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0600, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0600, 0, 0x0600,
    0, 0, 0, 0, 0x0600, 0x0600, 0x0600, 0, 0x0502, 0, 0, 0, 0, 0, 0, 0,
    0x0600, 0, 0, 0, 0, 0, 0, 0, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302,
    0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0600,
    0x0600, 0x0600, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0600,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0600, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0500, 0x0500, 0x0500, 0x0500,
    0x0601, 0x0501, 0x0601, 0x0600, 0x0600, 0x0302, 0x0302, 0x0302, 0x0302,
    0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302,
    0x0302, 0x0302, 0x0302, 0x0501, 0x0501, 0x0501, 0x0501, 0x0302, 0x0302,
    0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302,
    0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0400, 0x0400, 0x0400, 0x0400,
    0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400,
    0x0400, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0500, 0x0500,
    0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0501, 0x0501, 0x0501, 0x0501,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0700, 0x0700, 0x0700,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0, 0, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0,
    0x0d00, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0b00, 0x0b00, 0x0b00, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0c00, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0a00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00,
    0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0800,
    0x0800, 0x0800, 0x0800, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00,
    0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00,
    0x0c00, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0e00, 0x0401,
    0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0401, 0x0e00, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500,
    0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0501,
    0x0501, 0x0501, 0x0502, 0x0501, 0x0501, 0x0501, 0x0500, 0x0500, 0x0500,
    0x0500, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0502, 0x0502,
    0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0601, 0x0601, 0, 0, 0, 0, 0, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401,
    0x0401, 0x0401, 0, 0x0601, 0, 0, 0, 0, 0, 0x0601, 0, 0, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0601, 0x0601, 0, 0, 0, 0, 0,
    0, 0, 0x0401, 0x0600, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0600,
    0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0, 0x0401,
    0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0, 0x0401, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0401, 0x0401, 0, 0x0401, 0x0401, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0501, 0x0501, 0x0501, 0x0501, 0x0401, 0x0401, 0x0501,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0502, 0x0601,
    0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0900, 0x0900, 0x0a00, 0x0a00, 0x0a00,
    0x0a00, 0x0a00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0c00, 0x0d00,
    0x0d00, 0x0d00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00,
    0x0e00, 0x0e00, 0x0e00, 0x0e00, 0, 0, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0f01,
    0x0f01, 0x0f01, 0x0f01, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0x0300, 0x0300, 0x0300, 0x0302, 0x0302, 0x0302,
    0x0300, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x0302, 0x0302, 0, 0, 0, 0, 0, 0, 0, 0, 0x0302, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x0302, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0501, 0x0a00, 0x0b00,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0600, 0x0600, 0x0600, 0x0d00, 0x0d00, 0x0d00,
    0x0d00, 0x0d00, 0x0501, 0x0501, 0x0501, 0x0501, 0x1000, 0x1000, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0x0f01, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302,
    0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302,
    0x0302, 0x0302, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0400, 0x0400, 0, 0, 0, 0, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0400, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302,
    0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0x0400, 0x0400, 0x0401, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x0400, 0x0400, 0x0400, 0x0400, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0c01, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0400,
    0x0400, 0x0400, 0x0400, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0400, 0x0400, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00,
    0x0d00, 0x0d00, 0x0d00, 0x0d00, 0, 0, 0, 0, 0, 0, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0501, 0x0501, 0x0501, 0x0501, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0601, 0x0800, 0x0800, 0x0800,
    0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0a00, 0x0a00, 0x0a00,
    0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0b00,
    0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00,
    0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0e00,
    0x0e00, 0x0e00, 0x0300, 0x0300, 0x0302, 0x0302, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0302, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0302, 0x0300,
    0x0300, 0x0300, 0x0302, 0x0300, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0501, 0x0501, 0x0501,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0600,
    0x0600, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501,
    0x0501, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0800, 0x0601, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0, 0, 0, 0, 0, 0, 0, 0, 0x0401, 0x0401, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401,
    0x0401, 0x0500, 0x0500, 0x0500, 0x0500, 0x0501, 0x0501, 0x0501, 0x0501,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0600,
    0x0600, 0x0800, 0x0600, 0x0600, 0x0601, 0x0601, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0601, 0x0700, 0x0700, 0x0700, 0x0900, 0x0b00, 0x0700, 0x0700,
    0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0b00, 0x0b00, 0x0c00,
    0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0e00, 0x0e00, 0x0c00, 0x0c00,
    0x0c00, 0x0c00, 0x0c00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x1000, 0x1000,
    0x1000, 0, 0, 0x0e00, 0x0e00, 0, 0x0e00, 0, 0x0e00, 0x0e00, 0x0e00,
    0x0e00, 0x0e00, 0x1000, 0x1000, 0x1000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0x0e00, 0x0e00, 0x0e00, 0x0d00, 0x0d00, 0x0700,
    0x0601, 0x0601, 0x0600, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0401,
    0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0d00, 0, 0, 0, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0, 0, 0, 0, 0, 0,
    0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500,
    0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500,
    0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0, 0, 0, 0, 0, 0, 0, 0,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0900, 0, 0, 0, 0, 0, 0, 0, 0,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501,
    0x0501, 0x0501, 0x0501, 0, 0, 0, 0, 0, 0, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0800, 0x0800,
    0x0b00, 0x0b00, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501,
    0x0501, 0x0501, 0x0501, 0x0501, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x0501, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0, 0, 0, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0, 0, 0, 0, 0x0502, 0x0502, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501,
    0, 0, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501,
    0x0501, 0x0501, 0, 0, 0x0501, 0x0501, 0x0501, 0x0501, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0502, 0x0502, 0x0502, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601,
    0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601,
    0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0, 0,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0, 0, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0600, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0800, 0x0800, 0x0800, 0x0800, 0x0700, 0x0700, 0x0c00,
    0x0c00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0, 0, 0, 0, 0x0800, 0x0800,
    0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800,
    0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800,
    0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800,
    0x0800, 0x0800, 0x0800, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0, 0,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0, 0, 0, 0, 0, 0, 0x0200, 0x0200, 0x0200, 0x0200, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0, 0, 0, 0, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0x0601, 0x0601, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302,
    0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302,
    0x0302, 0x0502, 0x0502, 0x0502, 0, 0, 0x0401, 0x0401, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0401, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0300, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0e00, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00,
    0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00,
    0x0e00, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0e00, 0x0301,
    0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301,
    0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0x0302, 0x0400, 0x0e00, 0x0e00, 0x0302, 0x0302, 0x0302,
    0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302, 0x0302,
    0x0302, 0x0302, 0x0302, 0x0302, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0, 0, 0, 0, 0, 0, 0x0501,
    0x0501, 0x0501, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0800, 0x0800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0302,
    0x0302, 0x0400, 0x0400, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0300, 0x0300, 0x0300, 0x0201, 0, 0, 0,
    0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400,
    0x0400, 0x0400, 0x0400, 0, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400,
    0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400,
    0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0, 0x0400, 0x0400, 0, 0x0400,
    0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400,
    0x0400, 0x0400, 0x0400, 0x0400, 0, 0, 0x0400, 0x0400, 0x0400, 0x0400,
    0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400,
    0x0400, 0, 0, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400,
    0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400,
    0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400,
    0x0400, 0x0400, 0, 0, 0, 0, 0, 0x0400, 0x0400, 0x0400, 0, 0, 0, 0,
    0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400,
    0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400,
    0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0, 0, 0,
    0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400,
    0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0700, 0x0700, 0x0900, 0x0900, 0, 0x0501, 0x0501,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501,
    0x0501, 0x0d00, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0501,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501,
    0x0501, 0x0501, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0, 0, 0, 0, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301,
    0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301,
    0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301,
    0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0700, 0x0301, 0x0301,
    0x0301, 0x0301, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0a00, 0x0a00, 0x0a00,
    0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301,
    0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0, 0, 0, 0, 0,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0, 0, 0, 0, 0, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400,
    0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400,
    0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400,
    0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0, 0x0400, 0x0401, 0x0401,
    0x0401, 0x0401, 0, 0, 0, 0, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301,
    0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301,
    0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301,
    0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301,
    0x0400, 0x0400, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301,
    0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301,
    0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0400,
    0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400,
    0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400,
    0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400,
    0x0400, 0x0400, 0, 0, 0, 0, 0, 0, 0x0900, 0x0900, 0x0900, 0x0900,
    0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900,
    0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0, 0, 0, 0,
    0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900,
    0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900,
    0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900,
    0x0900, 0, 0, 0, 0, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0, 0, 0, 0, 0, 0, 0, 0, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0700,
    0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00,
    0x0e00, 0x0e00, 0, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00,
    0x0e00, 0, 0x0e00, 0x0e00, 0, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00,
    0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00,
    0x0e00, 0, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0,
    0x0e00, 0x0e00, 0, 0, 0, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000,
    0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000,
    0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000,
    0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0, 0x0e00,
    0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00,
    0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00,
    0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0, 0x0e00, 0x0e00,
    0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0, 0, 0, 0, 0,
    0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0, 0, 0x0400, 0,
    0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400,
    0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400,
    0x0400, 0x0400, 0x0400, 0x0400, 0, 0x0400, 0x0400, 0, 0, 0, 0x0400, 0,
    0, 0x0400, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0, 0, 0, 0, 0,
    0, 0, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0800, 0x0800,
    0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800,
    0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0,
    0x0800, 0x0800, 0, 0, 0, 0, 0, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800,
    0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500,
    0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500,
    0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0502,
    0x0502, 0, 0, 0, 0x0500, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501,
    0x0501, 0x0501, 0x0501, 0, 0, 0, 0, 0, 0x0501, 0x0601, 0x0601, 0x0601,
    0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601,
    0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601,
    0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601,
    0x0601, 0x0601, 0, 0, 0, 0, 0x0800, 0x0800, 0x0601, 0x0601, 0x0800,
    0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800,
    0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0, 0, 0x0800, 0x0800,
    0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800,
    0x0800, 0x0800, 0x0800, 0x0401, 0x0401, 0x0401, 0x0401, 0, 0x0401,
    0x0401, 0, 0, 0, 0, 0, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401,
    0x0401, 0x0401, 0, 0x0401, 0x0401, 0x0401, 0, 0x0401, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0b00,
    0x0b00, 0, 0, 0x0401, 0x0401, 0x0401, 0, 0, 0, 0, 0x0401, 0x0401,
    0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0b00, 0, 0, 0, 0, 0,
    0, 0, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401, 0x0401,
    0x0401, 0, 0, 0, 0, 0, 0, 0, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0, 0, 0, 0, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0, 0, 0, 0, 0, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0, 0, 0, 0, 0, 0, 0, 0x0700, 0x0700,
    0x0700, 0x0700, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800,
    0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800,
    0x0800, 0x0800, 0x0800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0800,
    0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800,
    0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800,
    0, 0, 0, 0, 0, 0, 0, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800,
    0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00,
    0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00,
    0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00,
    0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0, 0, 0, 0, 0, 0, 0, 0, 0x0b00,
    0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00,
    0, 0, 0, 0, 0, 0, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0, 0,
    0, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000,
    0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000,
    0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0, 0, 0, 0, 0, 0, 0, 0,
    0x1000, 0x1000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0d00,
    0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00,
    0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00,
    0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00,
    0x0d00, 0x0d00, 0x0d00, 0x0d00, 0, 0x0d00, 0x0d00, 0x0d00, 0, 0,
    0x0d00, 0x0d00, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x1000,
    0x1000, 0x1000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x1000, 0x0f00, 0x0f00, 0x0f00, 0x0b00,
    0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0, 0, 0, 0, 0,
    0, 0, 0, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00,
    0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00,
    0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00,
    0x0e00, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00,
    0x0d00, 0x0d00, 0x0d00, 0x0d00, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00,
    0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00,
    0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0, 0,
    0, 0, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0e00,
    0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x0700, 0x0502, 0x0502, 0x0e00, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0b00,
    0, 0, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601,
    0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0, 0,
    0, 0, 0, 0, 0, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601,
    0x0601, 0x0601, 0x0601, 0, 0, 0, 0, 0, 0, 0x0601, 0x0601, 0x0601,
    0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601,
    0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601,
    0, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601,
    0x0601, 0x0601, 0x0b00, 0x0b00, 0x0b00, 0x0d00, 0, 0, 0, 0, 0, 0, 0, 0,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0601, 0x0601,
    0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0800, 0x0800,
    0x0800, 0x0800, 0x0700, 0x0d00, 0x0d00, 0x0601, 0x0601, 0x0601, 0x0601,
    0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0700, 0x0800, 0x0800,
    0x0800, 0x0800, 0x0800, 0, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0900, 0x0f00, 0x0f00,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800,
    0x0800, 0, 0x0800, 0, 0x0800, 0x0800, 0x0800, 0x0800, 0, 0x0800,
    0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800,
    0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0, 0x0800, 0x0800, 0x0800,
    0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0, 0, 0, 0, 0,
    0, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0, 0,
    0, 0, 0, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0, 0, 0, 0, 0, 0, 0x0800, 0x0700, 0x0700,
    0x0700, 0, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0, 0, 0x0700, 0x0700, 0, 0, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0, 0x0700,
    0x0700, 0, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0, 0x0b00, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0, 0, 0x0700, 0x0700, 0, 0, 0x0700,
    0x0700, 0x0700, 0, 0, 0x0800, 0, 0, 0, 0, 0, 0, 0x0700, 0, 0, 0, 0, 0,
    0x0700, 0x0700, 0x0700, 0x0700, 0, 0, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0, 0, 0, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x1000, 0x1000, 0x1000,
    0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0, 0x1000, 0,
    0, 0x1000, 0, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000,
    0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000,
    0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0, 0x1000, 0x1000,
    0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0, 0x1000, 0,
    0, 0x1000, 0, 0x1000, 0x1000, 0x1000, 0x1000, 0, 0x1000, 0x1000,
    0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0,
    0x1000, 0x1000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0900, 0x0900, 0x0900, 0x0900,
    0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900,
    0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900,
    0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900,
    0x0900, 0x0d00, 0x0900, 0, 0x0900, 0x0b00, 0x0c00, 0x0d00, 0x0d00, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0, 0, 0, 0, 0, 0, 0, 0, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0, 0, 0, 0, 0, 0, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0, 0, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0800, 0x0800, 0x0800, 0x0800,
    0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800,
    0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0, 0, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0, 0, 0, 0, 0, 0, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900,
    0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0601, 0x0601,
    0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601,
    0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601,
    0x0601, 0x0601, 0x0601, 0x0601, 0x0c00, 0x0e00, 0, 0, 0, 0, 0, 0,
    0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601,
    0x0601, 0, 0, 0, 0, 0, 0, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000,
    0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000,
    0x1000, 0x1000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800,
    0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800,
    0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800,
    0x0800, 0x0800, 0x0800, 0x0b00, 0, 0, 0x0800, 0x0800, 0x0800, 0x0800,
    0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0, 0,
    0, 0, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800,
    0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0e00,
    0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0700, 0x0d00, 0x0d00, 0x0d00, 0x0d00,
    0x0d00, 0x0d00, 0x0d00, 0, 0, 0x0d00, 0, 0, 0x0d00, 0x0d00, 0x0d00,
    0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0, 0x0d00, 0x0d00, 0, 0x0d00,
    0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00,
    0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00,
    0x0d00, 0x0d00, 0x0d00, 0, 0x0d00, 0x0d00, 0, 0, 0x0d00, 0x0d00,
    0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00,
    0x0d00, 0, 0, 0, 0, 0, 0, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00,
    0x0c00, 0x0c00, 0x0c00, 0, 0, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00,
    0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00,
    0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00,
    0x0c00, 0, 0, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00,
    0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00,
    0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00,
    0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0, 0, 0, 0, 0, 0, 0, 0, 0x0a00,
    0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00,
    0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0c00, 0x0c00, 0x0a00,
    0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00,
    0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00,
    0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0b00, 0x0a00, 0x0a00, 0x0a00, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0e00, 0x0e00, 0x0e00, 0x0e00,
    0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00,
    0x0e00, 0x0e00, 0x0e00, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0, 0, 0, 0, 0, 0, 0, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00,
    0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x1000, 0x1000, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000,
    0x1000, 0x1000, 0x1000, 0x1000, 0, 0, 0, 0, 0, 0, 0x0900, 0x0900,
    0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0, 0x0900,
    0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900,
    0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900,
    0x0900, 0x0900, 0x0900, 0x0900, 0, 0x0900, 0x0900, 0x0900, 0x0900,
    0x0900, 0x0900, 0x0900, 0x0900, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0900,
    0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900,
    0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0, 0, 0, 0x0900,
    0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900,
    0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0, 0, 0x0900, 0x0900,
    0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900,
    0x0900, 0x0900, 0x0900, 0, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900,
    0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00,
    0x0a00, 0x0a00, 0, 0x0a00, 0x0a00, 0, 0x0a00, 0x0a00, 0x0a00, 0x0a00,
    0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00,
    0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00,
    0x0a00, 0, 0, 0, 0x0a00, 0, 0x0a00, 0x0a00, 0, 0x0a00, 0x0a00, 0x0a00,
    0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0, 0, 0, 0, 0, 0, 0, 0, 0x0a00,
    0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00,
    0, 0, 0, 0, 0, 0, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0,
    0x0b00, 0x0b00, 0, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00,
    0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00,
    0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0, 0x0b00,
    0x0b00, 0, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0, 0, 0, 0,
    0, 0, 0, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00,
    0x0b00, 0x0b00, 0x0b00, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00,
    0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00,
    0x0f00, 0x0f00, 0, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00,
    0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00,
    0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00,
    0x0f00, 0x0f00, 0x0f00, 0, 0, 0, 0x0f00, 0x0f00, 0x0f00, 0x0f00,
    0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00,
    0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00,
    0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x1000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0x0d00, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00,
    0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00,
    0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00,
    0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0x0c00, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500,
    0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0800, 0, 0,
    0, 0, 0, 0, 0x0500, 0x0500, 0x0500, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0,
    0x0500, 0x0500, 0x0500, 0x0500, 0x0700, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0x0800, 0x0800, 0x0800, 0x0800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0e00, 0x0e00, 0x0e00,
    0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00,
    0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00,
    0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00,
    0x0e00, 0x0e00, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0f00, 0x0c00, 0x0c00, 0x0c00, 0x0c00,
    0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0f00, 0x0f00, 0x0f00, 0x0f00,
    0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00,
    0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800,
    0x0800, 0x0800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0, 0, 0, 0, 0x0700, 0x0700, 0x0e00,
    0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00,
    0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0, 0, 0, 0, 0, 0,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0, 0, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0, 0, 0, 0, 0, 0x0700, 0x0700,
    0x0700, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0c00, 0x0c00, 0x0c00,
    0x0c00, 0x0c00, 0x0c00, 0, 0, 0, 0, 0x0c00, 0x0601, 0x0601, 0x0601,
    0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601,
    0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601,
    0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601,
    0x0601, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00,
    0, 0, 0, 0, 0, 0, 0, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601,
    0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601,
    0x0601, 0x0601, 0x0900, 0x0a00, 0x0c00, 0x0c00, 0x0d00, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0x0d00, 0x0d00, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900,
    0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0b00, 0x0b00, 0x0b00, 0x0b00,
    0x0b00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0, 0, 0, 0, 0,
    0, 0, 0, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900,
    0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900,
    0x0900, 0x0900, 0x0900, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00,
    0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00,
    0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0x1000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0e00,
    0x0e00, 0x0e00, 0x0e00, 0, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00,
    0x0e00, 0x0e00, 0, 0x0e00, 0x0e00, 0, 0x0600, 0x0600, 0x0a00, 0x0a00,
    0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00,
    0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00,
    0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00,
    0x0a00, 0x0a00, 0x0e00, 0x0e00, 0x0e00, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0x0f00, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x0c00, 0x0c00, 0x0c00, 0, 0, 0x0f00, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x0c00, 0x0c00, 0x0c00, 0x0c00, 0, 0, 0, 0, 0, 0, 0, 0, 0x0a00, 0x0a00,
    0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00,
    0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0, 0, 0, 0, 0,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0, 0, 0, 0, 0, 0, 0, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0, 0,
    0x0700, 0x0700, 0x0700, 0x0700, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0e00, 0x0e00, 0x0e00,
    0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00,
    0x0e00, 0x0e00, 0, 0, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00,
    0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00,
    0x0e00, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0e00, 0x0e00, 0x0e00, 0x0e00,
    0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00,
    0x0e00, 0x0e00, 0x0e00, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0301, 0x0301, 0x0301, 0x0301,
    0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301,
    0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301,
    0x0301, 0x0301, 0, 0, 0x0501, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301,
    0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301,
    0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301,
    0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0800, 0x0800,
    0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0e00, 0x0e00,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0f00,
    0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00,
    0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00,
    0x0f00, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0b00, 0x0b00, 0x0b00,
    0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00,
    0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400,
    0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400,
    0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500,
    0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500,
    0x0500, 0x0500, 0x0500, 0x0500, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00,
    0x0b00, 0x0b00, 0, 0, 0, 0, 0, 0, 0, 0x0301, 0x0301, 0x0301, 0x0301,
    0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301,
    0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0,
    0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301,
    0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301,
    0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301,
    0x0301, 0x0301, 0, 0x0301, 0x0301, 0, 0, 0x0301, 0, 0, 0x0301, 0x0301,
    0, 0, 0x0301, 0x0301, 0x0301, 0x0301, 0, 0x0301, 0x0301, 0x0301,
    0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301,
    0, 0x0301, 0, 0x0301, 0x0301, 0x0301, 0x0400, 0x0301, 0x0301, 0,
    0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301,
    0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301,
    0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301,
    0, 0x0301, 0x0301, 0x0301, 0x0301, 0, 0, 0x0301, 0x0301, 0x0301,
    0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0, 0x0301, 0x0301, 0x0301,
    0x0301, 0x0301, 0x0301, 0x0301, 0, 0x0301, 0x0301, 0x0301, 0x0301,
    0x0301, 0, 0x0301, 0, 0, 0, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301,
    0x0301, 0x0301, 0, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301,
    0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0401,
    0x0401, 0, 0, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301,
    0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301,
    0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0500,
    0x0500, 0, 0, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301,
    0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301,
    0x0301, 0x0301, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800,
    0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800,
    0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0f00, 0x0f00, 0x0f00,
    0x0f00, 0x0f00, 0x0f00, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900,
    0, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900,
    0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900,
    0, 0, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0, 0x0900, 0x0900, 0,
    0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0, 0, 0, 0, 0, 0x0f00, 0x0f00,
    0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00,
    0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00,
    0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00,
    0x0f00, 0x0f00, 0x0f00, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00,
    0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0, 0, 0, 0x0c00, 0x0c00,
    0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00,
    0x0c00, 0x0c00, 0x0c00, 0, 0, 0, 0, 0x0c00, 0x0c00, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00,
    0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00,
    0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00,
    0x0c00, 0x0c00, 0x0c00, 0, 0, 0, 0, 0, 0x0c00, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000,
    0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000,
    0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000,
    0x1000, 0x1000, 0x1000, 0, 0, 0, 0, 0x1000, 0x0e00, 0x0e00, 0x0e00,
    0x0e00, 0x0e00, 0x0e00, 0x0e00, 0, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0,
    0x0e00, 0x0e00, 0, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00,
    0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00,
    0, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0, 0, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900,
    0x0900, 0x0900, 0x0c00, 0, 0, 0, 0, 0x0900, 0x0900, 0x0900, 0x0900,
    0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0, 0, 0, 0, 0x0900,
    0x0900, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0b00,
    0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00,
    0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00,
    0x0b00, 0x0b00, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0601, 0x0601,
    0x0601, 0x0601, 0, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601,
    0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601,
    0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601,
    0x0601, 0x0601, 0x0601, 0, 0x0601, 0x0601, 0, 0x0601, 0, 0, 0x0601, 0,
    0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601,
    0x0601, 0, 0x0601, 0x0601, 0x0601, 0x0601, 0, 0x0601, 0, 0x0601, 0, 0,
    0, 0, 0x0601, 0, 0, 0, 0, 0x0601, 0, 0x0601, 0, 0x0601, 0, 0x0601,
    0x0601, 0x0601, 0, 0x0601, 0x0601, 0, 0x0601, 0, 0, 0x0601, 0, 0x0601,
    0, 0x0601, 0, 0x0601, 0, 0x0601, 0x0601, 0, 0x0601, 0, 0, 0x0601,
    0x0601, 0x0601, 0x0601, 0, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601,
    0x0601, 0x0601, 0, 0x0601, 0x0601, 0x0601, 0x0601, 0, 0x0601, 0x0601,
    0x0601, 0x0601, 0, 0x0601, 0, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601,
    0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0, 0x0601, 0x0601, 0x0601,
    0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601,
    0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0, 0, 0, 0, 0x0601, 0x0601,
    0x0601, 0, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0, 0x0601, 0x0601,
    0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601,
    0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0x0601, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0x0601, 0x0601, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0, 0, 0, 0, 0x0501, 0x0501,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0501,
    0x0501, 0x0501, 0x0501, 0x0501, 0x0501, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0, 0, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0700,
    0, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0700, 0x0700,
    0x0d00, 0x0d00, 0x0d00, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0b00, 0x0600, 0x0502, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0502, 0x0600, 0x0502,
    0x0600, 0x0600, 0x0502, 0x0600, 0x0600, 0x0600, 0x0502, 0x0600, 0x0600,
    0x0600, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0502, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0502, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0601, 0x0601, 0x0c00,
    0x0d00, 0x0d00, 0x0d00, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0502, 0x0600, 0x0502, 0x0502, 0x0600, 0x0600,
    0x0502, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0502, 0x0502, 0x0502, 0x0502, 0x0600, 0x0600, 0x0502,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900,
    0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0d00, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0502, 0x0600, 0x0600, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0900, 0, 0, 0, 0, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0, 0, 0, 0, 0, 0, 0, 0x0600,
    0x0600, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0a00, 0x0a00,
    0x0a00, 0x0a00, 0x0a00, 0x0a00, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0600, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0800, 0x0800, 0x0800, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0700, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0700, 0x0800, 0x0800, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0700, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0700, 0x0700, 0x0700, 0x0700, 0x0800,
    0x0800, 0x0800, 0x0800, 0x0800, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800,
    0x0800, 0x0800, 0x0800, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0700, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0700, 0x0600, 0x0600, 0x0600, 0x0600, 0x0700, 0x0700,
    0x0800, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0700, 0x0700, 0x0601, 0x0601, 0x0601,
    0x0601, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0800,
    0x0800, 0x0800, 0x0800, 0x0800, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0900, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0601,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0601, 0x0600,
    0x0600, 0x0600, 0x0601, 0x0600, 0x0601, 0x0600, 0x0601, 0x0600, 0x0601,
    0x0600, 0x0600, 0x0600, 0x0601, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0601, 0x0601, 0x0600, 0x0600, 0x0600, 0x0600, 0x0601, 0x0600,
    0x0601, 0x0601, 0x0600, 0x0600, 0x0600, 0x0600, 0x0601, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0700, 0x0700, 0x0800, 0x0800, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0800, 0x0900, 0x0900, 0x0a00, 0x0a00, 0x0c00, 0x0d00,
    0x0d00, 0, 0, 0, 0, 0x0f00, 0x0e00, 0x0e00, 0x0e00, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0, 0, 0, 0x0700, 0x0700, 0x0700, 0x0700, 0x0900,
    0x0900, 0x0900, 0x0a00, 0x0a00, 0x0b00, 0x0c00, 0x0d00, 0x0d00, 0, 0,
    0, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0f00, 0x0f00, 0x0f00, 0, 0, 0, 0, 0x0f00,
    0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0b00, 0x0b00,
    0x0b00, 0x0b00, 0x0f00, 0, 0, 0, 0, 0, 0, 0x0c00, 0x0c00, 0x0c00,
    0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00,
    0, 0, 0, 0, 0x0e00, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0, 0, 0, 0, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700, 0x0700,
    0x0700, 0x0700, 0x0700, 0, 0, 0x0d00, 0x0d00, 0x1000, 0x1000, 0x1000,
    0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00,
    0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0d00, 0x0c00, 0x0c00, 0x0c00, 0x0800,
    0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0900,
    0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0a00, 0x0900, 0x0900, 0x0900,
    0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0a00, 0x0a00, 0x0a00, 0x0a00,
    0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0900, 0x0a00, 0x0a00, 0x0900, 0x0900,
    0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900,
    0x0900, 0x0c00, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900,
    0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0a00, 0x0b00, 0x0b00, 0x0b00,
    0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900,
    0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0a00, 0x0a00, 0x0a00,
    0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00,
    0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0c00, 0x0d00, 0x0b00, 0x0b00,
    0x0b00, 0x0b00, 0x0d00, 0x0d00, 0x0e00, 0x0b00, 0x0c00, 0x0b00, 0x0b00,
    0x0b00, 0x0b00, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0900, 0x0900,
    0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900,
    0x0900, 0x0900, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0b00,
    0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0d00, 0x0d00,
    0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0d00, 0x0d00, 0x0d00,
    0x0c00, 0x0c00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00,
    0x0b00, 0x0b00, 0x0b00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00,
    0x0800, 0x0b00, 0x0b00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00,
    0x0c00, 0x0c00, 0x0d00, 0x0e00, 0x0c00, 0x0c00, 0x0c00, 0x0a00, 0x0a00,
    0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00,
    0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0b00, 0x0b00, 0x0b00, 0x0b00,
    0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00,
    0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00, 0x0b00,
    0x0b00, 0x0b00, 0x0b00, 0, 0, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0d00,
    0x0f00, 0x0f00, 0x0f00, 0x0c00, 0x0c00, 0x0c00, 0x0e00, 0x0e00, 0, 0,
    0, 0x0c00, 0x0c00, 0x0c00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0f00,
    0x0f00, 0x1000, 0, 0, 0, 0, 0, 0x1000, 0x0c00, 0x0c00, 0x0c00, 0x0c00,
    0x0c00, 0x0c00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00,
    0x0d00, 0x0d00, 0x0d00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0f00, 0x0f00,
    0x0f00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0e00,
    0x0e00, 0x0e00, 0x0e00, 0x0f00, 0x0f00, 0x0f00, 0x1000, 0x0f00, 0x0d00,
    0x0d00, 0x0d00, 0x0e00, 0x0e00, 0x0e00, 0x1000, 0, 0, 0, 0, 0, 0, 0,
    0x0f00, 0x0f00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00,
    0x0e00, 0x0e00, 0x0e00, 0x0f00, 0x0f00, 0x1000, 0, 0, 0x1000, 0x0e00,
    0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0f00, 0x1000,
    0, 0, 0, 0, 0, 0, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0e00,
    0x0e00, 0x0f00, 0x0f00, 0, 0, 0, 0, 0, 0, 0, 0x0d00, 0x0d00, 0x0d00,
    0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00,
    0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0, 0x0d00,
    0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00,
    0x0d00, 0x0d00, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000,
    0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000,
    0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x0d00, 0x0d00, 0x0d00, 0x0d00,
    0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x0200, 0x0200, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301,
    0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301,
    0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0d00, 0x0d00,
    0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0e00, 0x0e00, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502, 0x0502,
    0x0502, 0x0e00, 0x0e00, 0x0e00, 0x0e00, 0x0f00, 0, 0, 0, 0, 0, 0,
    0x0800, 0x0800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x0a00,
    0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00,
    0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0x0f01, 0x0f01, 0x0f01, 0x0f01, 0x0f01, 0x0f01,
    0x0f01, 0x0f01, 0x0f01, 0x0f01, 0x0f01, 0x0f01, 0x0f01, 0x0f01, 0x0f01,
    0x0f01, 0x0f01, 0x0f01, 0x0f01, 0x0f01, 0x0f01, 0x0f01, 0x0f01, 0x0f01,
    0x0f01, 0x0f01, 0x0f01, 0x0f01, 0x0f01, 0x0f01, 0x0f01, 0x0f01, 0, 0,
    0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301,
    0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301,
    0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301, 0x0301,
    0x0301, 0x0301, 0x0301, 0, 0, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00,
    0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0x0d00, 0, 0, 0, 0, 0, 0x0f00,
    0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00,
    0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0f00
};

static U16 precis_age_lookup(U32 cp)
{
    if ((0x01FFFE <= cp && (cp & 0x00FFFE) == 0x00FFFE)
	|| (0x0F0000 <= cp && cp <= 0x0FFFFD)
	|| (0x100000 <= cp && cp <= 0x10FFFD))
	return 0x0200;
    else if (cp == 0x0E0001 || (0x0E0020 <= cp && cp <= 0x0E007F))
	return 0x0301;
    else if (0x0E0100 <= cp && cp <= 0x0E01EF)
	return 0x0400;
    else if (0x040000 <= cp)
	return 0;

    return precis_age_array[precis_age_index[cp >> AGE_BLKWIDTH] +
			    (cp & ((1 << AGE_BLKWIDTH) - 1))
	];
}

/* Lines below are automatically generated. Don't edit them manually. */
static U16 precis_xprop_index[] = {
    0, 109, 165, 165, 165, 165, 293, 421, 165, 549, 165, 660, 777, 897,
    1025, 1153, 1279, 1404, 1529, 1656, 1783, 1910, 2038, 2164, 2292, 2419,
    2517, 2644, 2731, 2810, 2914, 3042, 3125, 3251, 165, 165, 165, 165,
    3286, 165, 165, 165, 165, 165, 165, 165, 3396, 3512, 3633, 3756, 3852,
    165, 3957, 4085, 4213, 4327, 4443, 4499, 4621, 4728, 165, 165, 4856,
    4984, 5111, 5223, 5336, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 5375,
    5489, 197, 165, 5617, 5745, 5787, 5910, 6015, 165, 6143, 165, 6175,
    6303, 165, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 6431, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    6495, 6621, 165, 165, 6747, 6862, 6990, 7118, 7220, 7345, 7464, 7566,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    5745, 5745, 7694, 5783, 7822, 165, 165, 165, 165, 165, 7950, 166, 7998,
    8111, 165, 165, 8235, 8348, 165, 8474, 8571, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 8698, 8762, 165, 8890, 165,
    165, 9018, 165, 165, 9128, 9256, 9382, 9509, 9637, 9765, 9893, 9974,
    10040, 10168, 10285, 10384, 10479, 165, 10557, 10651, 10736, 10835,
    165, 10916, 165, 10985, 11053, 11180, 11298, 165, 165, 11378, 11488,
    11567, 11679, 165, 11703, 11818, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 11909, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 12007, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 12055, 12172, 165, 165, 165, 165, 165, 165, 165, 8394,
    12285, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 12399, 12527, 12528, 12624, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 12728, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 12856, 165, 165,
    165, 12927, 13052, 13180, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 13308, 13421, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 13549, 8555, 12172, 165, 165, 13631, 165, 165,
    165, 13743, 165, 11708, 165, 165, 165, 165, 165, 13855, 13983, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 14111, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5777,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 14239, 5745, 14337,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 14431, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 14479, 5745, 5745, 5745,
    5745, 5779, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 5745, 5745, 5745, 5745, 6465, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    14591, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745,
    5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 5745, 6447, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165
};

/* Lines below are automatically generated. Don't edit them manually. */
static U8 precis_xprop_array[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, CH_SMALLL, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    CH_MIDDLEDOT, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, 0, CH_KERAIA, SC_Greek,
    SC_Greek, 0, 0, SC_Greek, SC_Greek, SC_Greek, SC_Greek, 0, SC_Greek, 0,
    0, 0, 0, SC_Greek, 0, SC_Greek, 0, SC_Greek, SC_Greek, SC_Greek, 0,
    SC_Greek, 0, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, 0, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew,
    JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew,
    JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew,
    JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew,
    JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew,
    JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew,
    JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew,
    JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew,
    JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew,
    JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew,
    JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew,
    JT_T | SC_Hebrew, SC_Hebrew, JT_T | SC_Hebrew, SC_Hebrew,
    JT_T | SC_Hebrew, JT_T | SC_Hebrew, SC_Hebrew, JT_T | SC_Hebrew,
    JT_T | SC_Hebrew, SC_Hebrew, JT_T | SC_Hebrew, 0, 0, 0, 0, 0, 0, 0, 0,
    SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew,
    SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew,
    SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew,
    SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew,
    SC_Hebrew, SC_Hebrew, SC_Hebrew, 0, 0, 0, 0, SC_Hebrew, SC_Hebrew,
    SC_Hebrew, SC_Hebrew, CH_GERESH, CH_GERSHAYIM, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, 0, JT_T, 0, 0, 0, JT_D, 0, JT_R, JT_R, JT_R, JT_R,
    JT_D, JT_R, JT_D, JT_R, JT_D, JT_D, JT_D, JT_D, JT_D, JT_R, JT_R, JT_R,
    JT_R, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, 0, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_R, JT_D,
    JT_D, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    CH_Arabic_Indic_digits, CH_Arabic_Indic_digits, CH_Arabic_Indic_digits,
    CH_Arabic_Indic_digits, CH_Arabic_Indic_digits, CH_Arabic_Indic_digits,
    CH_Arabic_Indic_digits, CH_Arabic_Indic_digits, CH_Arabic_Indic_digits,
    CH_Arabic_Indic_digits, 0, 0, 0, 0, JT_D, JT_D, JT_T, JT_R, JT_R, JT_R,
    0, JT_R, JT_R, JT_R, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_R, JT_R, JT_R, JT_R, JT_R, JT_R, JT_R, JT_R, JT_R, JT_R, JT_R, JT_R,
    JT_R, JT_R, JT_R, JT_R, JT_R, JT_R, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_R, JT_D, JT_D, JT_R,
    JT_R, JT_R, JT_R, JT_R, JT_R, JT_R, JT_R, JT_R, JT_D, JT_R, JT_D, JT_R,
    JT_D, JT_D, JT_R, JT_R, 0, JT_R, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, JT_T, JT_T, 0,
    JT_T, JT_T, JT_T, JT_T, JT_R, JT_R, CH_extended_Arabic_Indic_digits,
    CH_extended_Arabic_Indic_digits, CH_extended_Arabic_Indic_digits,
    CH_extended_Arabic_Indic_digits, CH_extended_Arabic_Indic_digits,
    CH_extended_Arabic_Indic_digits, CH_extended_Arabic_Indic_digits,
    CH_extended_Arabic_Indic_digits, CH_extended_Arabic_Indic_digits,
    CH_extended_Arabic_Indic_digits, JT_D, JT_D, JT_D, 0, 0, JT_D, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_R, JT_T, JT_D, JT_D, JT_D,
    JT_R, JT_R, JT_R, JT_R, JT_R, JT_D, JT_D, JT_D, JT_D, JT_R, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_R, JT_D, JT_R, JT_D, JT_R,
    JT_D, JT_D, JT_R, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, JT_R, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_R, JT_R, JT_R, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_R, JT_R, JT_D, JT_D, JT_D, JT_D, JT_R, JT_D, JT_R, JT_R, JT_D,
    JT_D, JT_D, JT_R, JT_R, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0,
    0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, 0, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, 0, JT_T, JT_T, JT_T, 0, JT_T, JT_T, JT_T,
    JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_R,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_R, JT_R, JT_D, JT_R, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_R, JT_D, JT_R, JT_R, JT_R,
    JT_T, JT_T, JT_T, 0, 0, 0, 0, JT_D, 0, JT_D, JT_D, JT_D, JT_D, 0, JT_R,
    JT_D, JT_R, JT_R, 0, 0, 0, 0, 0, JT_R, JT_R, JT_R, JT_R, JT_R, JT_R,
    JT_R, JT_R, JT_R, JT_R, JT_R, JT_R, JT_R, JT_R, JT_R, JT_R, 0, 0, 0,
    JT_D, 0, 0, JT_D, JT_D, JT_D, JT_D, JT_D, JT_R, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_R, JT_R, JT_R, 0, JT_R,
    JT_D, JT_D, JT_R, JT_R, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_R, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, JT_T, 0, JT_T, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, 0, 0, 0, 0, JT_T | CCC_VIRAMA, 0, 0, 0, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, JT_T, JT_T, JT_T,
    JT_T, 0, 0, 0, 0, 0, 0, 0, 0, JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, JT_T,
    JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, JT_T, JT_T, 0, 0, 0,
    0, JT_T, JT_T, 0, 0, JT_T, JT_T, JT_T | CCC_VIRAMA, 0, 0, 0, JT_T, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, JT_T, JT_T,
    JT_T, JT_T, JT_T, 0, JT_T, JT_T, 0, 0, 0, 0, JT_T | CCC_VIRAMA, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0,
    0, JT_T, 0, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_T, 0, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, 0, JT_T,
    JT_T, JT_T, JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, JT_T, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0,
    JT_T, JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_T | CCC_VIRAMA, JT_T | CCC_VIRAMA, 0, 0, 0, 0, JT_T, JT_T, JT_T,
    JT_T, 0, 0, 0, 0, 0, 0, 0, 0, JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, 0, JT_T, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_T, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T | CCC_VIRAMA, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, JT_T, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T | CCC_VIRAMA, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0,
    JT_T, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, JT_T, JT_T, JT_T,
    JT_T, JT_T | CCC_VIRAMA, 0, JT_T, JT_T, 0, 0, 0, 0, 0, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0,
    0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T,
    0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, JT_T | CCC_VIRAMA,
    JT_T | CCC_VIRAMA, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, JT_T,
    JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T,
    JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, JT_T, JT_T, 0,
    0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T,
    JT_T | CCC_VIRAMA, CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, CCC_VIRAMA, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T,
    JT_T, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0,
    0, JT_T, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T | CCC_VIRAMA, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, JT_D, 0, 0, 0, JT_T, JT_T, JT_T, 0, JT_T, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, 0, 0,
    0, 0, 0, 0, 0, JT_T, JT_T, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_T, JT_D, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_T, JT_T, JT_T, 0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_T, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, 0, 0, JT_T, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, JT_T, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0,
    JT_T | CCC_VIRAMA, 0, JT_T, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, JT_T, JT_T, JT_T, JT_T, JT_T, 0,
    JT_T, 0, 0, 0, 0, 0, JT_T, 0, CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, 0, 0, JT_T, JT_T, CCC_VIRAMA,
    JT_T | CCC_VIRAMA, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, JT_T,
    JT_T, 0, 0, 0, JT_T, 0, JT_T, JT_T, JT_T, CCC_VIRAMA, CCC_VIRAMA, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_T, JT_T, JT_T, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, JT_T, JT_T, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, 0, 0, 0, 0, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, SC_Greek, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, 0, 0, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, 0, 0, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, 0, 0,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, 0, 0,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, 0, SC_Greek, 0, SC_Greek, 0, SC_Greek, 0, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, 0, 0, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, 0,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, 0, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, 0, 0, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, 0, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, 0, 0, SC_Greek, SC_Greek, SC_Greek, 0, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, CH_ZWNJ, CH_ZWJ, JT_T, JT_T, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0,
    0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, SC_Greek, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T | CCC_VIRAMA,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, 0,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, SC_Han, 0, SC_Han, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, JT_T, JT_T,
    JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, SC_Han, SC_Han, SC_Han,
    SC_Han, 0, 0, 0, 0, 0, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, 0, 0,
    JT_T, JT_T, 0, 0, SC_Hiragana, SC_Hiragana, SC_Hiragana, 0,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    CH_NAKAGURO, 0, SC_Katakana, SC_Katakana, SC_Katakana, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, 0, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T,
    JT_T, JT_T, JT_T, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T,
    JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0,
    JT_T | CCC_VIRAMA, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0,
    JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_L, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, JT_T | CCC_VIRAMA, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, 0, CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, JT_T, JT_T, JT_T, JT_T, 0, 0,
    JT_T, JT_T, 0, 0, CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, 0, 0, JT_T, JT_T, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, JT_T,
    JT_T, JT_T, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, JT_T, JT_T, 0, JT_T, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0,
    0, 0, 0, 0, JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, SC_Greek, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, JT_T, 0, 0, JT_T, 0, 0, 0, 0, JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, 0, 0, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    SC_Hebrew, JT_T | SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew,
    SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew,
    SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew,
    SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew,
    SC_Hebrew, SC_Hebrew, SC_Hebrew, 0, SC_Hebrew, SC_Hebrew, SC_Hebrew,
    SC_Hebrew, SC_Hebrew, 0, SC_Hebrew, 0, SC_Hebrew, SC_Hebrew, 0,
    SC_Hebrew, SC_Hebrew, 0, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew,
    SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, 0, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, SC_Greek, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, JT_T, JT_T,
    JT_T, 0, JT_T, JT_T, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, 0, 0, 0, 0,
    JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_R, 0, JT_R, 0, JT_R, JT_R, 0, 0, JT_L,
    JT_R, JT_R, JT_R, JT_R, JT_R, JT_D, JT_D, JT_D, JT_D, JT_L, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_R, JT_D, JT_D, JT_D, JT_R, 0, 0, JT_R, JT_T, JT_T,
    0, 0, 0, 0, JT_D, JT_D, JT_D, JT_D, JT_R, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, JT_D, JT_R, JT_D, JT_R, JT_R, JT_R, JT_D, JT_D, JT_D,
    JT_R, JT_D, JT_D, JT_R, JT_D, JT_R, JT_R, JT_D, JT_R, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_R, JT_R, JT_R,
    JT_R, JT_D, JT_D, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_L, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_R, JT_D, JT_T, JT_T, JT_T, JT_T,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T,
    JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, JT_R, JT_D, JT_D, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_D,
    JT_D, JT_D, JT_R, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, 0, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_D, JT_D, JT_D, JT_R,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, JT_D, JT_D, JT_D, JT_D, JT_R, JT_R, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_D, 0, JT_D, JT_D, JT_R,
    JT_R, JT_R, 0, JT_D, JT_R, JT_R, JT_D, JT_D, JT_R, JT_D, JT_D, 0, JT_D,
    JT_R, JT_R, JT_D, 0, 0, 0, 0, JT_R, JT_D, JT_L, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, JT_T | CCC_VIRAMA, 0, 0, JT_T, JT_T, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, JT_T | CCC_VIRAMA, JT_T, JT_T, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T,
    JT_T, JT_T, 0, 0, JT_T | CCC_VIRAMA, JT_T, 0, 0, 0, 0, 0, 0, 0, JT_T,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, 0, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T | CCC_VIRAMA, JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, 0, CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, 0,
    0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, JT_T, JT_T, JT_T, 0, 0, JT_T, CCC_VIRAMA, JT_T, JT_T, 0, 0, 0,
    0, 0, 0, JT_T, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T,
    JT_T, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, CCC_VIRAMA, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, JT_T, JT_T, JT_T,
    JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T | CCC_VIRAMA,
    CCC_VIRAMA, JT_T | CCC_VIRAMA, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, 0, 0, JT_T | CCC_VIRAMA, JT_T, JT_T, 0, JT_T,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, JT_T, 0, 0, 0, 0,
    JT_T, JT_T, 0, JT_T | CCC_VIRAMA, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, JT_T, JT_T, 0,
    JT_T | CCC_VIRAMA, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, JT_T, 0, JT_T | CCC_VIRAMA,
    JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, JT_T, 0, 0,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, CCC_VIRAMA, JT_T, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, JT_T, 0,
    0, JT_T, JT_T, JT_T, JT_T, 0, JT_T, JT_T, JT_T, JT_T,
    JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, JT_T | CCC_VIRAMA, JT_T,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T,
    JT_T, CCC_VIRAMA, JT_T | CCC_VIRAMA, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, 0, 0, JT_T, JT_T, 0, 0, 0,
    0, JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, JT_T, JT_T | CCC_VIRAMA, JT_T, JT_T, JT_T, JT_T, 0, 0,
    JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, JT_T | CCC_VIRAMA, 0,
    0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, JT_T,
    JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, JT_T,
    JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0,
    JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, JT_T, JT_T, 0, JT_T, JT_T, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, JT_T, 0, JT_T, JT_T, 0,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T | CCC_VIRAMA, JT_T | CCC_VIRAMA, 0,
    JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, JT_T, 0,
    JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0,
    0, JT_T, CCC_VIRAMA, JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, 0, 0, 0, JT_T, JT_T, JT_T | CCC_VIRAMA, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, SC_Han, SC_Han, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, SC_Han, SC_Han, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, 0, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, 0, SC_Katakana, SC_Katakana, 0, SC_Katakana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Katakana, SC_Katakana, SC_Katakana, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, SC_Hiragana, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, 0, 0, SC_Katakana, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, 0, JT_T, JT_T, JT_T, JT_T, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    JT_T | SC_Greek, JT_T | SC_Greek, JT_T | SC_Greek, SC_Greek, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0,
    0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T,
    0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, 0, JT_T, JT_T, 0, JT_T, JT_T, JT_T, JT_T,
    JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, SC_Hiragana, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, 0, 0, 0, 0, 0, 0, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    0, 0, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, 0, 0, 0, 0, 0, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han
};

static U32 precis_xprop_lookup(U32 cp)
{
    if (cp == 0x0E0001 || (0x0E0020 <= cp && cp <= 0x0E007F)
	|| (0x0E0100 <= cp && cp <= 0x0E01EF))
	return JT_T;
    else if (0x040000 <= cp)
	return 0;

    return precis_xprop_array[precis_xprop_index[cp >> XPROP_BLKWIDTH] +
			      (cp & ((1 << XPROP_BLKWIDTH) - 1))
	];
}

static const U8 utf8_sequence_len[0x100] = {
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,	/* 0x00-0x0F */
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,	/* 0x10-0x1F */
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,	/* 0x20-0x2F */
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,	/* 0x30-0x3F */
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,	/* 0x40-0x4F */
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,	/* 0x50-0x5F */
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,	/* 0x60-0x6F */
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,	/* 0x70-0x7F */
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* 0x80-0x8F */
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* 0x90-0x9F */
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* 0xA0-0xAF */
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* 0xB0-0xBF */
    0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,	/* 0xC0-0xCF */
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,	/* 0xD0-0xDF */
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,	/* 0xE0-0xEF */
    4, 4, 4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* 0xF0-0xFF */
};

int precis_prepare(U8 * buf, const STRLEN buflen, int stringclass,
		   U16 unicode_version, U8 ** pptr, STRLEN * lenptr,
		   STRLEN * idxptr, U32 * cpptr)
{
    U8 *p = buf;
    const U8 *end = buf + buflen;
    const U8 *end4 = end - 4;

    STRLEN len = 0, idx = 0;
    U32 cp = 0;
    U8 prop = PRECIS_PVALID;
    U8 has_hankana = 0, has_aid = 0, has_eaid = 0;
    typedef struct {
	U8 *p;
	STRLEN len;
	STRLEN idx;
	U32 cp;
    } ctx_t;
    ctx_t ctx = { NULL, 0, 0, 0 };
    ctx_t nakaguro = { NULL, 0, 0, 0 };

    U32 vec;
    U32 xprop, jtype, xprop_before = 0, jtype_before = 0;

    while (p < end4) {
      check:
	/* Check if string consists of valid UTF-8 sequences. */

	len = utf8_sequence_len[*p];

	switch (len) {
	case 0:
	    goto illseq;

	case 1:
	    /* 0xxxxxxx */
	    cp = (U32) p[0];
	    break;

	case 2:
	    /* 110xxxxx 10xxxxxx */
	    if ((p[1] & 0xC0) != 0x80)
		goto illseq;
	    cp = ((U32) (p[0] & 0x1F) << 6) | ((U32) (p[1] & 0x3F));
	    break;

	case 3:
	    vec = ((U32) p[0] << 16) | ((U32) p[1] << 8) | ((U32) p[2]);
	    /* 1110xxxx 10xxxxxx 10xxxxxx *//* Shortest form */
	    if ((vec & 0x00F0C0C0) != 0x00E08080 || vec < 0x00E0A080)
		goto illseq;
	    cp = ((U32) (p[0] & 0x0F) << 12)
		| ((U32) (p[1] & 0x3F) << 6) | ((U32) (p[2] & 0x3F));
	    /* Surrogates U+D800..U+DFFF */
	    if ((cp & 0x00F800) == 0x00D800)
		goto disallowed;
	    /* Non-characters U+FDD0..U+FDEF, U+FFFE..U+FFFF */
	    if (0x00FDD0 <= cp && cp <= 0x00FDEF)
		goto disallowed;
	    if ((cp & 0x00FFFE) == 0x00FFFE)
		goto disallowed;
	    break;

	case 4:
	    vec = ((U32) p[0] << 24)
		| ((U32) p[1] << 16) | ((U32) p[2] << 8) | ((U32) p[3]);
	    /* 11110xxx 10xxxxxx 10xxxxxx 10xxxxxx *//* Shortest form */
	    if ((vec & 0xF8C0C0C0) != 0xF0808080 || vec < 0xF0908080)
		goto illseq;
	    cp = ((U32) (p[0] & 0x07) << 18)
		| ((U32) (p[1] & 0x3F) << 12)
		| ((U32) (p[2] & 0x3F) << 6) | ((U32) (p[3] & 0x3F));
	    /* Greater than U+10FFFF */
	    if (0x10FFFF < cp)
		goto disallowed;
	    /* Non-characters U+nFFFE..U+nFFFF */
	    if ((cp & 0x00FFFE) == 0x00FFFE)
		goto disallowed;
	    break;

	  illseq:
	    len = 0;
	    cp = 0;
	    /* goto disallowed; */
	  disallowed:
	    prop = PRECIS_DISALLOWED;
	    goto done;
	}			/* switch (len) */

	/* Check if character is assigned by specified version of Unicode. */

	if (unicode_version != 0
	    && unicode_version < precis_age_lookup(cp)) {
	    prop = PRECIS_UNASSIGNED;
	    goto done;
	}

	switch (stringclass) {
	case PRECIS_FREE_FORM_CLASS:
	case PRECIS_IDENTIFIER_CLASS:

	    /* Resolve property. */

	    prop = precis_prop_lookup(cp);

	    switch (prop) {
	    case PRECIS_PVALID:
	    case PRECIS_CONTEXTJ:
	    case PRECIS_CONTEXTO:
		break;

	    case PRECIS_ID_DIS:
		if (stringclass == PRECIS_IDENTIFIER_CLASS) {
		    prop = PRECIS_DISALLOWED;
		    goto done;
		} else
		    prop = PRECIS_PVALID;
		break;

	    default:
		goto done;
	    }

	    /* Resolve contextual rules. */

	    xprop = precis_xprop_lookup(cp);
	    jtype = xprop & JT_MASK;
	    xprop &= ~JT_MASK;

	    if (xprop == CH_NAKAGURO) {
		/* Rule 7: Record use of NAKAGURO. */
		if (nakaguro.p == NULL) {
		    nakaguro.p = p;
		    nakaguro.len = len;
		    nakaguro.idx = idx;
		    nakaguro.cp = cp;
		}
		prop = PRECIS_PVALID;
		xprop = 0;
	    }
	    if ((jtype_before & JT_L) && (jtype & JT_T))
		/* Rule 1.2: Allowing Re((JT:{L,D})(JT:T)*) */
		jtype = jtype_before;

	    switch (xprop_before) {
	    case CH_ZWNJ:
		goto after_ZWNJ;
	    case CH_MIDDLEDOT:
		goto after_MIDDLEDOT;
	    case CH_KERAIA:
		goto after_KERAIA;
	    }
	    switch (prop) {
	    case PRECIS_CONTEXTJ:
	    case PRECIS_CONTEXTO:
		ctx.p = p;
		ctx.len = len;
		ctx.idx = idx;
		ctx.cp = cp;
	    }

	    switch (xprop) {
		/* Rule 1: ZERO WIDTH NON-JOINER */
	    case CH_ZWNJ:	/* ZWNJ, CONTEXTJ */
		if (xprop_before == CCC_VIRAMA) {
		    /* Rule 1.1: CCC(Before(cp)) .eq. Virama */
		    prop = PRECIS_PVALID;
		    xprop = 0;
		} else if (jtype_before & JT_L)
		    /* Rule 1.2 top half: Re((JT:{L,D})(JT:T)*\u200C) */
		    ;
		else
		    goto done;
		break;

	      after_ZWNJ:
		/* Rule 1.2 bottom half: Re(\u200C(JT:T)*(JT:{R,D})) */
		if (jtype & JT_T) {
		    prop = PRECIS_CONTEXTJ;
		    xprop = xprop_before;	/* CP_ZWNJ */
		    jtype = jtype_before;	/* 0 */
		} else if (jtype & JT_R);
		else {
		    prop = PRECIS_CONTEXTJ;
		    goto done;
		}
		break;

		/* Rule 2: ZERO WIDTH JOINER */
	    case CH_ZWJ:	/* ZWJ, CONTEXTJ */
		if (xprop_before == CCC_VIRAMA)
		    prop = PRECIS_PVALID;
		else
		    goto done;
		break;

	    case CCC_VIRAMA:
		break;

		/* Rule 3: MIDDLE DOT */
	    case CH_MIDDLEDOT:	/* MIDDLE DOT, CONTEXTO */
		if (xprop_before == CH_SMALLL);
		else
		    goto done;
		break;

	      after_MIDDLEDOT:
		if (xprop == CH_SMALLL);
		else {
		    prop = PRECIS_CONTEXTO;
		    goto done;
		}
		break;

	    case CH_SMALLL:
		break;

		/* Rule 4: GREEK LOWER NUMERAL SIGN */
	    case CH_KERAIA:	/* KERAIA, CONTEXTO */
		break;

	      after_KERAIA:
		switch (xprop) {
		case CH_KERAIA:	/* CONTEXTO */
		    break;
		case SC_Greek:
		    break;
		default:
		    prop = PRECIS_CONTEXTO;
		    goto done;
		}
		break;

	    case SC_Greek:
		break;

		/* Rule 5: HEBREW PUNCTUATION GERESH */
	    case CH_GERESH:	/* GERESH, CONTEXTO */
		switch (xprop_before) {
		case CH_GERESH:
		case CH_GERSHAYIM:
		case SC_Hebrew:
		    prop = PRECIS_PVALID;
		    break;
		default:
		    goto done;
		}
		break;

		/* Rule 6: HEBREW PUNCTUATION GERSHAYIM */
	    case CH_GERSHAYIM:	/* GERSHAYIM, CONTEXTO */
		switch (xprop_before) {
		case CH_GERESH:
		case CH_GERSHAYIM:
		case SC_Hebrew:
		    prop = PRECIS_PVALID;
		    break;
		default:
		    goto done;
		}
		break;

	    case SC_Hebrew:
		break;

		/* Rule 7: KATAKANA MIDDLE DOT */
	    case CH_NAKAGURO:	/* NAKAGURO, CONTEXTO */
		 /*NOTREACHED*/	/* See above. */
		    break;

	    case SC_Han:
	    case SC_Hiragana:
	    case SC_Katakana:
		has_hankana = 1;
		break;

		/* Rule 8: ARABIC-INDIC DIGITS */
	    case CH_Arabic_Indic_digits:
		/* Arabic-Indic digits, CONTEXTO */
		if (has_eaid)
		    goto done;
		else {
		    prop = PRECIS_PVALID;
		    has_aid = 1;
		}
		break;

		/* Rule 9: EXTENDED ARABIC-INDIC DIGITS */
	    case CH_extended_Arabic_Indic_digits:
		/* Extended Arabic-Indic digits, CONTEXTO */
		if (has_aid)
		    goto done;
		else {
		    prop = PRECIS_PVALID;
		    has_eaid = 1;
		}
		break;

	    default:
		assert(prop == PRECIS_PVALID);
		assert(xprop == 0);
	    }			/* switch (xprop) */

	    xprop_before = xprop;
	    jtype_before = jtype;
	    break;

	default:
	    break;
	}			/* switch (stringclass) */

	p += len;
	idx++;
    }				/* while (p < end4) */
    if (p < end) {
	if (p + utf8_sequence_len[*p] <= end)
	    goto check;
	else
	    goto illseq;
    }

  done:
    if (nakaguro.p != NULL && !has_hankana) {
	if (pptr != NULL)
	    *pptr = nakaguro.p;
	if (lenptr != NULL)
	    *lenptr = nakaguro.len;
	if (idxptr != NULL)
	    *idxptr = nakaguro.idx;
	if (cpptr != NULL)
	    *cpptr = nakaguro.cp;
	prop = PRECIS_CONTEXTO;
    } else
	switch (prop) {
	case PRECIS_CONTEXTJ:
	case PRECIS_CONTEXTO:
	    assert(ctx.p != NULL);

	    if (pptr != NULL)
		*pptr = ctx.p;
	    if (lenptr != NULL)
		*lenptr = ctx.len;
	    if (idxptr != NULL)
		*idxptr = ctx.idx;
	    if (cpptr != NULL)
		*cpptr = ctx.cp;
	    break;

	case PRECIS_DISALLOWED:
	case PRECIS_UNASSIGNED:
	    if (pptr != NULL)
		*pptr = p;
	    if (lenptr != NULL)
		*lenptr = len;
	    if (idxptr != NULL)
		*idxptr = idx;
	    if (cpptr != NULL)
		*cpptr = cp;
	    break;

	default:
	    if (pptr != NULL)
		*pptr = p;
	    if (lenptr != NULL)
		*lenptr = 0;
	    if (idxptr != NULL)
		*idxptr = idx;
	    break;
	}

    return prop;
}
