/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import org.apache.sis.util.resources.IndexedResourceBundle;
import org.apache.sis.util.resources.KeyConstants;
import org.apache.sis.util.resources.ResourceInternationalString;
import org.opengis.util.InternationalString;

public final class Resources
extends IndexedResourceBundle {
    public Resources(URL uRL) {
        super(uRL);
    }

    @Override
    protected KeyConstants getKeyConstants() {
        return Keys.INSTANCE;
    }

    public static Resources forLocale(Locale locale) throws MissingResourceException {
        return Resources.getBundle(Resources.class, locale);
    }

    public static String format(short s) throws MissingResourceException {
        return Resources.forLocale(null).getString(s);
    }

    public static String format(short s, Object object) throws MissingResourceException {
        return Resources.forLocale(null).getString(s, object);
    }

    public static String format(short s, Object object, Object object2) throws MissingResourceException {
        return Resources.forLocale(null).getString(s, object, object2);
    }

    public static String format(short s, Object object, Object object2, Object object3) throws MissingResourceException {
        return Resources.forLocale(null).getString(s, object, object2, object3);
    }

    public static InternationalString formatInternational(short s) {
        return new International(s);
    }

    public static InternationalString formatInternational(short s, Object ... objectArray) {
        return new International(s, objectArray);
    }

    private static final class International
    extends ResourceInternationalString {
        private static final long serialVersionUID = -7265791441872360274L;

        International(short s) {
            super(s);
        }

        International(short s, Object object) {
            super(s, object);
        }

        @Override
        protected KeyConstants getKeyConstants() {
            return Keys.INSTANCE;
        }

        @Override
        protected IndexedResourceBundle getBundle(Locale locale) {
            return Resources.forLocale(locale);
        }
    }

    public static final class Keys
    extends KeyConstants {
        static final Keys INSTANCE = new Keys();
        public static final short AmbiguousName_4 = 15;
        public static final short CanNotGetCommonMetadata_2 = 39;
        public static final short CanNotReadCRS_WKT_1 = 37;
        public static final short CanNotReadDirectory_1 = 34;
        public static final short CanNotReadFile_2 = 1;
        public static final short CanNotReadFile_3 = 2;
        public static final short CanNotReadFile_4 = 3;
        public static final short ClosedReader_1 = 4;
        public static final short ClosedWriter_1 = 5;
        public static final short ConcurrentRead_1 = 19;
        public static final short ConcurrentWrite_1 = 20;
        public static final short DataStoreEncoding = 29;
        public static final short DataStoreLocale = 30;
        public static final short DataStoreLocation = 31;
        public static final short DataStoreTimeZone = 32;
        public static final short DirectoryContent_1 = 35;
        public static final short ExcessiveStringSize_3 = 6;
        public static final short FeatureAlreadyPresent_2 = 16;
        public static final short FeatureNotFound_2 = 17;
        public static final short IllegalFeatureType_2 = 7;
        public static final short IllegalInputTypeForReader_2 = 8;
        public static final short IllegalOutputTypeForWriter_2 = 9;
        public static final short InconsistentNameComponents_2 = 10;
        public static final short MissingSchemeInURI_1 = 11;
        public static final short ProcessingExecutedOn_1 = 12;
        public static final short ResourceIdentifierCollision_2 = 23;
        public static final short ResourceNotFound_2 = 24;
        public static final short ShallBeDeclaredBefore_2 = 22;
        public static final short SharedDirectory_1 = 36;
        public static final short StoreIsReadOnly = 28;
        public static final short StreamIsForwardOnly_1 = 13;
        public static final short StreamIsNotReadable_1 = 25;
        public static final short StreamIsNotWritable_1 = 26;
        public static final short StreamIsReadOnce_1 = 18;
        public static final short StreamIsWriteOnce_1 = 21;
        public static final short UndefinedParameter_2 = 27;
        public static final short UnknownFormatFor_1 = 14;
        public static final short UsedOnlyIfNotEncoded = 33;

        private Keys() {
        }
    }
}

