/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.IOException;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.params.BasicFormatParams;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.sentiment.SentimentSample;
import opennlp.tools.sentiment.SentimentSampleStream;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;

public class SentimentSampleStreamFactory
extends AbstractSampleStreamFactory<SentimentSample> {
    protected <P> SentimentSampleStreamFactory(Class<P> params) {
        super(params);
    }

    @Override
    public ObjectStream<SentimentSample> create(String[] args) {
        BasicFormatParams params = ArgumentParser.parse(args, BasicFormatParams.class);
        CmdLineUtil.checkInputFile("Data", params.getData());
        InputStreamFactory sampleDataIn = CmdLineUtil.createInputStreamFactory(params.getData());
        PlainTextByLineStream lineStream = null;
        try {
            lineStream = new PlainTextByLineStream(sampleDataIn, params.getEncoding());
        }
        catch (IOException ex) {
            CmdLineUtil.handleCreateObjectStreamError(ex);
        }
        return new SentimentSampleStream(lineStream);
    }

    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(SentimentSample.class, "sentiment", new SentimentSampleStreamFactory(BasicFormatParams.class));
    }
}

