use strict;

use Test::More;
use Lingua::TL::Numbers qw(num2tl num2tl_ordinal);

subtest 'cardinals with contracted form of "at"' => sub {
    is(num2tl(1), 'isa');
    is(num2tl(2), 'dalawa');
    is(num2tl(3), 'tatlo');
    is(num2tl(4), 'apat');
    is(num2tl(5), 'lima');
    is(num2tl(6), 'anim');
    is(num2tl(7), 'pito');
    is(num2tl(8), 'walo');
    is(num2tl(9), 'siyam');
    is(num2tl(10), 'sampu');
    is(num2tl(11), 'labing-isa');
    is(num2tl(12), 'labindalawa');
    is(num2tl(13), 'labintatlo');
    is(num2tl(14), 'labing-apat');
    is(num2tl(15), 'labinlima');
    is(num2tl(16), 'labing-anim');
    is(num2tl(17), 'labimpito');
    is(num2tl(18), 'labingwalo');
    is(num2tl(19), 'labinsiyam');
    is(num2tl(20), 'dalawampu');
    is(num2tl(21), "dalawampu't isa");
    is(num2tl(22), "dalawampu't dalawa");
    is(num2tl(23), "dalawampu't tatlo");
    is(num2tl(24), "dalawampu't apat");
    is(num2tl(25), "dalawampu't lima");
    is(num2tl(26), "dalawampu't anim");
    is(num2tl(27), "dalawampu't pito");
    is(num2tl(28), "dalawampu't walo");
    is(num2tl(29), "dalawampu't siyam");
    is(num2tl(30), 'tatlumpu');
    is(num2tl(40), 'apatnapu');
    is(num2tl(50), 'limampu');
    is(num2tl(60), 'animnapu');
    is(num2tl(70), 'pitumpu');
    is(num2tl(80), 'walumpu');
    is(num2tl(90), 'siyamnapu');
    is(num2tl(100), 'isang daan');
    is(num2tl(200), 'dalawang daan');
    is(num2tl(300), 'tatlong daan');
    is(num2tl(400), 'apat na raan');
    is(num2tl(500), 'limang daan');
    is(num2tl(600), 'anim na raan');
    is(num2tl(700), 'pitong daan');
    is(num2tl(800), 'walong daan');
    is(num2tl(900), 'siyam na raan');
    is(num2tl(1000), 'isang libo');
    is(num2tl(10_000), 'sampung libo');
    is(num2tl(100_000), 'isang daang libo');
    is(num2tl(1_000_000), 'isang milyon');
    is(num2tl(10_000_000), 'sampung milyon');
    is(num2tl(100_000_000), 'isang daang milyon');

    is(num2tl(32), "tatlumpu't dalawa");
    is(num2tl(43), "apatnapu't tatlo");
    is(num2tl(54), "limampu't apat");
    is(num2tl(65), "animnapu't lima");
    is(num2tl(76), "pitumpu't anim");
    is(num2tl(87), "walumpu't pito");
    is(num2tl(98), "siyamnapu't walo");

    is(num2tl(123), "isang daa't dalawampu't tatlo");
    is(num2tl(1234), "isang libo't dalawang daa't tatlumpu't apat");
    is(num2tl(12345), "labindalawang libo't tatlong daa't apatnapu't lima");
    is(num2tl(123456), "isang daa't dalawampu't tatlong libo't apat na raa't limampu't anim");
    is(num2tl(1234567), "isang milyon at dalawang daa't tatlumpu't apat na libo't limang daa't animnapu't pito");
    is(num2tl(12345678), "labindalawang milyon at tatlong daa't apatnapu't limang libo't anim na raa't pitumpu't walo");
    is(num2tl(123456789), "isang daa't dalawampu't tatlong milyon at apat na raa't limampu't anim na libo't pitong daa't walumpu't siyam");

    is(num2tl(321), "tatlong daa't dalawampu't isa");
    is(num2tl(4321), "apat na libo't tatlong daa't dalawampu't isa");
    is(num2tl(54321), "limampu't apat na libo't tatlong daa't dalawampu't isa");
    is(num2tl(654321), "anim na raa't limampu't apat na libo't tatlong daa't dalawampu't isa");
    is(num2tl(7654321), "pitong milyon at anim na raa't limampu't apat na libo't tatlong daa't dalawampu't isa");
    is(num2tl(87654321), "walumpu't pitong milyon at anim na raa't limampu't apat na libo't tatlong daa't dalawampu't isa");
    is(num2tl(987654321), "siyam na raa't walumpu't pitong milyon at anim na raa't limampu't apat na libo't tatlong daa't dalawampu't isa");

    is(num2tl(48), "apatnapu't walo");
    is(num2tl(95), "siyamnapu't lima");
    is(num2tl(115), "isang daa't labinlima");
    is(num2tl(145), "isang daa't apatnapu't lima");
    is(num2tl(236), "dalawang daa't tatlumpu't anim");
    is(num2tl(250), "dalawang daa't limampu");
    is(num2tl(256), "dalawang daa't limampu't anim");
    is(num2tl(410), "apat na raa't sampu");
    is(num2tl(874), "walong daa't pitumpu't apat");
    is(num2tl(1024), "isang libo't dalawampu't apat");
    is(num2tl(1445), "isang libo't apat na raa't apatnapu't lima");
    is(num2tl(1941), "isang libo't siyam na raa't apatnapu't isa");
    is(num2tl(2000), 'dalawang libo');
    is(num2tl(5011), "limang libo't labing-isa");
    is(num2tl(9999), "siyam na libo't siyam na raa't siyamnapu't siyam");
    is(num2tl(17_001), "labimpitong libo't isa");
    is(num2tl(51_351), "limampu't isang libo't tatlong daa't limampu't isa");
    is(num2tl(200_000), 'dalawang daang libo');
    is(num2tl(999_999), "siyam na raa't siyamnapu't siyam na libo't siyam na raa't siyamnapu't siyam");
    is(num2tl(1_048_576), "isang milyon at apatnapu't walong libo't limang daa't pitumpu't anim");
    is(num2tl(1_500_000), 'isang milyon at limang daang libo');
    is(num2tl(2_000_000), 'dalawang milyon');

    done_testing();
};

done_testing();
