use strict;
use vars qw($i $loaded $num $comp $cord $data $order $class);
BEGIN {
  use Lingua::JA::Sort::JIS 'jcmp';
  $| = 1;
  $num = 1 + 2 * (1 + 24 + 22 + 45 + 30 + 11 + 10 + 114 + 52 + 174 + 5 + 1);
  print "1..$num\n";
}
END {print "not ok 1\n" unless $loaded;}

$loaded = 1;
print "ok 1\n";

$comp = '';
$cord = '0-0';

while (<DATA>) {
  if (/^([^#]+)# ((\d+)\-\d+)/) {
    $data = $1;
    $order = $2;
    $class = $3;

    print jcmp($data,$comp) == 1 ? "ok" : "not ok", " ", ++$loaded, "\n";

    my $expect = $cord eq $order ? 0 : 1;
    print jcmp($data,$comp,1) == $expect
      ? "ok" : "not ok", " ", ++$loaded, "\n";
  }

  $comp = $data;
  $cord = $order;
};

1;
__DATA__
　# 1-1
、# 2-1
。# 2-2
，# 2-3
．# 2-4
・# 2-5
：# 2-6
；# 2-7
？# 2-8
！# 2-9
´# 2-91 added
｀# 2-92 added
¨# 2-93 added
＾# 2-94 added
￣# 2-10
＿# 2-11
―# 2-12
‐# 2-13
／# 2-14
＼# 2-15
～# 2-16
∥# 2-17
｜# 2-18
…# 2-19
‥# 2-20
‘# 3-1
’# 3-2
“# 3-3
”# 3-4
（# 3-5
）# 3-6
〔# 3-7
〕# 3-8
［# 3-9
］# 3-10
｛# 3-11
｝# 3-12
〈# 3-13
〉# 3-14
《# 3-15
》# 3-16
「# 3-17
」# 3-18
『# 3-19
』# 3-20
【# 3-21
】# 3-22
＋# 4-1
－# 4-2
±# 4-3
×# 4-4
÷# 4-5
＝# 4-6
≠# 4-7
＜# 4-8
＞# 4-9
≦# 4-10
≧# 4-11
≒# 4-12
≪# 4-13
≫# 4-14
∝# 4-15
∞# 4-16
∂# 4-17
∇# 4-18
√# 4-19
∫# 4-20
∬# 4-21
∠# 4-22
⊥# 4-23
⌒# 4-24
≡# 4-25
∽# 4-26
∈# 4-27
∋# 4-28
⊆# 4-29
⊇# 4-30
⊂# 4-31
⊃# 4-32
∪# 4-33
∩# 4-34
∧# 4-35
∨# 4-36
￢# 4-37
⇒# 4-38
⇔# 4-39
∀# 4-40
∃# 4-41
∴# 4-42
∵# 4-43
♂# 4-44
♀# 4-45
＃# 5-1
＆# 5-2
＊# 5-3
＠# 5-4
§# 5-5
¶# 5-6
※# 5-7
†# 5-8
‡# 5-9
☆# 5-10
★# 5-11
○# 5-12
●# 5-13
◎# 5-14
◇# 5-15
◆# 5-16
□# 5-17
■# 5-18
△# 5-19
▲# 5-20
▽# 5-21
▼# 5-22
〒# 5-23
→# 5-24
←# 5-25
↑# 5-26
↓# 5-27
♯# 5-28
♭# 5-29
♪# 5-30
°# 6-1
′# 6-2
″# 6-3
℃# 6-4
￥# 6-5
＄# 6-6
￠# 6-7
￡# 6-8
％# 6-9
‰# 6-10
Å# 6-11
０# 7-1
１# 7-2
２# 7-3
３# 7-4
４# 7-5
５# 7-6
６# 7-7
７# 7-8
８# 7-9
９# 7-10
α# 8-1
β# 8-2
γ# 8-3
δ# 8-4
ε# 8-5
ζ# 8-6
η# 8-7
θ# 8-8
ι# 8-9
κ# 8-10
λ# 8-11
μ# 8-12
ν# 8-13
ξ# 8-14
ο# 8-15
π# 8-16
ρ# 8-17
σ# 8-18
τ# 8-19
υ# 8-20
φ# 8-21
χ# 8-22
ψ# 8-23
ω# 8-24
Α# 8-25
Β# 8-26
Γ# 8-27
Δ# 8-28
Ε# 8-29
Ζ# 8-30
Η# 8-31
Θ# 8-32
Ι# 8-33
Κ# 8-34
Λ# 8-35
Μ# 8-36
Ν# 8-37
Ξ# 8-38
Ο# 8-39
Π# 8-40
Ρ# 8-41
Σ# 8-42
Τ# 8-43
Υ# 8-44
Φ# 8-45
Χ# 8-46
Ψ# 8-47
Ω# 8-48
а# 8-49
б# 8-50
в# 8-51
г# 8-52
д# 8-53
е# 8-54
ё# 8-55
ж# 8-56
з# 8-57
и# 8-58
й# 8-59
к# 8-60
л# 8-61
м# 8-62
н# 8-63
о# 8-64
п# 8-65
р# 8-66
с# 8-67
т# 8-68
у# 8-69
ф# 8-70
х# 8-71
ц# 8-72
ч# 8-73
ш# 8-74
щ# 8-75
ъ# 8-76
ы# 8-77
ь# 8-78
э# 8-79
ю# 8-80
я# 8-81
А# 8-82
Б# 8-83
В# 8-84
Г# 8-85
Д# 8-86
Е# 8-87
Ё# 8-88
Ж# 8-89
З# 8-90
И# 8-91
Й# 8-92
К# 8-93
Л# 8-94
М# 8-95
Н# 8-96
О# 8-97
П# 8-98
Р# 8-99
С# 8-100
Т# 8-101
У# 8-102
Ф# 8-103
Х# 8-104
Ц# 8-105
Ч# 8-106
Ш# 8-107
Щ# 8-108
Ъ# 8-109
Ы# 8-110
Ь# 8-111
Э# 8-112
Ю# 8-113
Я# 8-114
ａ# 9-1-1
Ａ# 9-1-2
ｂ# 9-2-1
Ｂ# 9-2-2
ｃ# 9-3-1
Ｃ# 9-3-2
ｄ# 9-4-1
Ｄ# 9-4-2
ｅ# 9-5-1
Ｅ# 9-5-2
ｆ# 9-6-1
Ｆ# 9-6-2
ｇ# 9-7-1
Ｇ# 9-7-2
ｈ# 9-8-1
Ｈ# 9-8-2
ｉ# 9-9-1
Ｉ# 9-9-2
ｊ# 9-10-1
Ｊ# 9-10-2
ｋ# 9-11-1
Ｋ# 9-11-2
ｌ# 9-12-1
Ｌ# 9-12-2
ｍ# 9-13-1
Ｍ# 9-13-2
ｎ# 9-14-1
Ｎ# 9-14-2
ｏ# 9-15-1
Ｏ# 9-15-2
ｐ# 9-16-1
Ｐ# 9-16-2
ｑ# 9-17-1
Ｑ# 9-17-2
ｒ# 9-18-1
Ｒ# 9-18-2
ｓ# 9-19-1
Ｓ# 9-19-2
ｔ# 9-20-1
Ｔ# 9-20-2
ｕ# 9-21-1
Ｕ# 9-21-2
ｖ# 9-22-1
Ｖ# 9-22-2
ｗ# 9-23-1
Ｗ# 9-23-2
ｘ# 9-24-1
Ｘ# 9-24-2
ｙ# 9-25-1
Ｙ# 9-25-2
ｚ# 9-26-1
Ｚ# 9-26-2
ぁ# 10-1-1
ァ# 10-1-2
あ# 10-1-3
ア# 10-1-4
ぃ# 10-2-1
ィ# 10-2-2
い# 10-2-3
イ# 10-2-4
ぅ# 10-3-1
ゥ# 10-3-2
う# 10-3-3
ウ# 10-3-4
ヴ# 10-3-5
ぇ# 10-4-1
ェ# 10-4-2
え# 10-4-3
エ# 10-4-4
ぉ# 10-5-1
ォ# 10-5-2
お# 10-5-3
オ# 10-5-4
ヵ# 10-6-1
か# 10-6-2
カ# 10-6-3
が# 10-6-4
ガ# 10-6-5
き# 10-7-1
キ# 10-7-2
ぎ# 10-7-3
ギ# 10-7-4
く# 10-8-1
ク# 10-8-2
ぐ# 10-8-3
グ# 10-8-4
ヶ# 10-9-1
け# 10-9-2
ケ# 10-9-3
げ# 10-9-4
ゲ# 10-9-5
こ# 10-10-1
コ# 10-10-2
ご# 10-10-3
ゴ# 10-10-4
さ# 10-11-1
サ# 10-11-2
ざ# 10-11-3
ザ# 10-11-4
し# 10-12-1
シ# 10-12-2
じ# 10-12-3
ジ# 10-12-4
す# 10-13-1
ス# 10-13-2
ず# 10-13-3
ズ# 10-13-4
せ# 10-14-1
セ# 10-14-2
ぜ# 10-14-3
ゼ# 10-14-4
そ# 10-15-1
ソ# 10-15-2
ぞ# 10-15-3
ゾ# 10-15-4
た# 10-16-1
タ# 10-16-2
だ# 10-16-3
ダ# 10-16-4
ち# 10-17-1
チ# 10-17-2
ぢ# 10-17-3
ヂ# 10-17-4
っ# 10-18-1
ッ# 10-18-2
つ# 10-18-3
ツ# 10-18-4
づ# 10-18-5
ヅ# 10-18-6
て# 10-19-1
テ# 10-19-2
で# 10-19-3
デ# 10-19-4
と# 10-20-1
ト# 10-20-2
ど# 10-20-3
ド# 10-20-4
な# 10-21-1
ナ# 10-21-2
に# 10-22-1
ニ# 10-22-2
ぬ# 10-23-1
ヌ# 10-23-2
ね# 10-24-1
ネ# 10-24-2
の# 10-25-1
ノ# 10-25-2
は# 10-26-1
ハ# 10-26-2
ば# 10-26-3
バ# 10-26-4
ぱ# 10-26-5
パ# 10-26-6
ひ# 10-27-1
ヒ# 10-27-2
び# 10-27-3
ビ# 10-27-4
ぴ# 10-27-5
ピ# 10-27-6
ふ# 10-28-1
フ# 10-28-2
ぶ# 10-28-3
ブ# 10-28-4
ぷ# 10-28-5
プ# 10-28-6
へ# 10-29-1
ヘ# 10-29-2
べ# 10-29-3
ベ# 10-29-4
ぺ# 10-29-5
ペ# 10-29-6
ほ# 10-30-1
ホ# 10-30-2
ぼ# 10-30-3
ボ# 10-30-4
ぽ# 10-30-5
ポ# 10-30-6
ま# 10-31-1
マ# 10-31-2
み# 10-32-1
ミ# 10-32-2
む# 10-33-1
ム# 10-33-2
め# 10-34-1
メ# 10-34-2
も# 10-35-1
モ# 10-35-2
ゃ# 10-36-1
ャ# 10-36-2
や# 10-36-3
ヤ# 10-36-4
ゅ# 10-37-1
ュ# 10-37-2
ゆ# 10-37-3
ユ# 10-37-4
ょ# 10-38-1
ョ# 10-38-2
よ# 10-38-3
ヨ# 10-38-4
ら# 10-39-1
ラ# 10-39-2
り# 10-40-1
リ# 10-40-2
る# 10-41-1
ル# 10-41-2
れ# 10-42-1
レ# 10-42-2
ろ# 10-43-1
ロ# 10-43-2
ゎ# 10-44-1
ヮ# 10-44-2
わ# 10-44-3
ワ# 10-44-4
ゐ# 10-45-1
ヰ# 10-45-2
ゑ# 10-46-1
ヱ# 10-46-2
を# 10-47-1
ヲ# 10-47-2
ん# 10-48-1
ン# 10-48-2
ゝ# 10-49-1
ヽ# 10-49-2
ゞ# 10-49-3
ヾ# 10-49-4
ー# 10-50-1
〃# 11-1
仝# 11-2
々# 11-3
〆# 11-4
〇# 11-5
〓# 12-1
