/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex;

import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.trees.tregex.TregexPatternCompiler;
import edu.stanford.nlp.util.Pair;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class Macros {
    private Macros() {
    }

    public static List<Pair<String, String>> readMacros(String filename) {
        return Macros.readMacros(filename, "utf-8");
    }

    public static List<Pair<String, String>> readMacros(String filename, String encoding) {
        try {
            BufferedReader bin = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), encoding));
            return Macros.readMacros(bin);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public static List<Pair<String, String>> readMacros(BufferedReader bin) {
        try {
            String line;
            ArrayList<Pair<String, String>> macros = new ArrayList<Pair<String, String>>();
            int lineNumber = 0;
            while ((line = bin.readLine()) != null) {
                ++lineNumber;
                String trimmed = line.trim();
                if (trimmed.equals("") || trimmed.charAt(0) == '#') continue;
                String[] pieces = line.split("\t", 2);
                if (pieces.length < 2) {
                    throw new IllegalArgumentException("Expected lines of the format original (tab) replacement.  Line number " + lineNumber + " does not match.");
                }
                macros.add(new Pair<String, String>(pieces[0], pieces[1]));
            }
            return macros;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public static void addAllMacros(TregexPatternCompiler compiler, String filename, String encoding) {
        if (filename == null || filename.equals("")) {
            return;
        }
        for (Pair<String, String> macro : Macros.readMacros(filename, encoding)) {
            compiler.addMacro(macro.first(), macro.second());
        }
    }
}

