/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.semgraph;

import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.trees.semgraph.SemanticGraph;
import edu.stanford.nlp.trees.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.util.StringUtils;
import java.util.HashSet;
import java.util.Set;

public class SemanticGraphFormatter {
    private static final String LPAREN = "[";
    private static final String RPAREN = "]";
    private static final String SPACE = " ";
    private static final String COLON = ":";
    private static final int DEFAULT_WIDTH = 80;
    private static final int DEFAULT_INDENT = 4;
    private static final boolean DEFAULT_SMART_INDENT = true;
    private static final boolean DEFAULT_SHOW_RELNS = true;
    private static final boolean DEFAULT_SHOW_TAGS = true;
    private static final boolean DEFAULT_SHOW_ANNOS = false;
    private static final boolean DEFAULT_SHOW_INDICES = false;
    private int width = 80;
    private int indent = 4;
    private boolean smartIndent = true;
    private boolean showRelns = true;
    private boolean showTags = true;
    private boolean showAnnos = false;
    private boolean showIndices = false;
    private StringBuilder out;
    private Set<IndexedWord> used;

    public SemanticGraphFormatter() {
        this(80, 4, true, true, true, false, false);
    }

    public SemanticGraphFormatter(int width, int indent, boolean smartIndent, boolean showRelns, boolean showTags, boolean showAnnos, boolean showIndices) {
        this.width = width;
        this.indent = indent;
        this.smartIndent = smartIndent;
        this.showRelns = showRelns;
        this.showTags = showTags;
        this.showAnnos = showAnnos;
        this.showIndices = showIndices;
    }

    public String formatSemanticGraph(SemanticGraph sg) {
        if (sg.vertexSet().isEmpty()) {
            return "[]";
        }
        this.out = new StringBuilder();
        this.used = new HashSet<IndexedWord>();
        if (sg.getRoots().size() == 1) {
            this.formatSGNode(sg, sg.getFirstRoot(), 1);
        } else {
            int index = 0;
            for (IndexedWord root : sg.getRoots()) {
                this.out.append("root_").append(++index).append(": ");
                this.formatSGNode(sg, root, 9);
                this.out.append("\n");
            }
        }
        String result = this.out.toString();
        if (!result.startsWith(LPAREN)) {
            result = LPAREN + result + RPAREN;
        }
        return result;
    }

    private void formatSGNode(SemanticGraph sg, IndexedWord node, int spaces) {
        this.used.add(node);
        String oneline = this.formatSGNodeOneline(sg, node);
        boolean toolong = spaces + oneline.length() > this.width;
        boolean breakable = sg.hasChildren(node);
        if (toolong && breakable) {
            this.formatSGNodeMultiline(sg, node, spaces);
        } else {
            this.out.append(oneline);
        }
    }

    private String formatSGNodeOneline(SemanticGraph sg, IndexedWord node) {
        StringBuilder sb = new StringBuilder();
        HashSet<IndexedWord> usedOneline = new HashSet<IndexedWord>();
        this.formatSGNodeOnelineHelper(sg, node, sb, usedOneline);
        return sb.toString();
    }

    private void formatSGNodeOnelineHelper(SemanticGraph sg, IndexedWord node, StringBuilder sb, Set<IndexedWord> usedOneline) {
        boolean isntLeaf;
        usedOneline.add(node);
        boolean bl = isntLeaf = sg.outDegree(node) > 0;
        if (isntLeaf) {
            sb.append(LPAREN);
        }
        sb.append(this.formatLabel(node));
        for (SemanticGraphEdge depcy : sg.getOutEdgesSorted(node)) {
            IndexedWord dep = depcy.getDependent();
            sb.append(SPACE);
            if (this.showRelns) {
                sb.append(depcy.getRelation());
                sb.append(COLON);
            }
            if (!usedOneline.contains(dep) && !this.used.contains(dep)) {
                this.formatSGNodeOnelineHelper(sg, dep, sb, usedOneline);
                continue;
            }
            sb.append(this.formatLabel(dep));
        }
        if (isntLeaf) {
            sb.append(RPAREN);
        }
    }

    private void formatSGNodeMultiline(SemanticGraph sg, IndexedWord node, int spaces) {
        this.out.append(LPAREN);
        this.out.append(this.formatLabel(node));
        spaces = this.smartIndent ? ++spaces : (spaces += this.indent);
        for (SemanticGraphEdge depcy : sg.getOutEdgesSorted(node)) {
            IndexedWord dep = depcy.getDependent();
            this.out.append("\n");
            this.out.append(StringUtils.repeat(SPACE, spaces));
            int sp = spaces;
            if (this.showRelns) {
                String reln = depcy.getRelation().toString();
                this.out.append(reln);
                this.out.append(COLON);
                if (this.smartIndent) {
                    sp += reln.length() + 1;
                }
            }
            if (this.used.contains(dep)) continue;
            this.formatSGNode(sg, dep, sp);
        }
        this.out.append(RPAREN);
    }

    private String formatLabel(IndexedWord node) {
        String tag;
        String s = node.word();
        if (this.showIndices) {
            s = node.sentIndex() + COLON + node.index() + "-" + s;
        }
        if (this.showTags && (tag = node.tag()) != null && tag.length() > 0) {
            s = s + "/" + tag;
        }
        if (this.showAnnos) {
            s = s + node.toString("COMPLETE_FORMAT");
        }
        return s;
    }

    private void test(String s) {
        SemanticGraph sg = SemanticGraph.valueOf(s);
        System.out.println(sg.toCompactString());
        System.out.println(this.formatSemanticGraph(sg));
        System.out.println();
    }

    public static void main(String[] args) {
        SemanticGraphFormatter fmt = new SemanticGraphFormatter();
        System.out.println("0        1         2         3         4         5         6         7         8");
        System.out.println("12345678901234567890123456789012345678901234567890123456789012345678901234567890");
        System.out.println();
        fmt.test("[like subj:Bill dobj:[muffins nn:blueberrry]]");
        fmt.test("[eligible nsubj:Zambia cop:became xcomp:[receive aux:to dobj:[assistance amod:UNCDF] prep_in:1991]]");
        fmt.test("[say advcl:[are mark:If nsubj:[polls det:the] xcomp:[believed aux:to auxpass:be]] nsubj:[voters amod:American] aux:will advmod:[much dep:[same det:the]] dep:[to pobj:[Republicans poss:[Bush possessive:'s nn:George]]] dep:[vote advmod:when nsubj:they prep:[in pobj:[elections amod:congressional det:the]] prep:[on pobj:[November num:7th]]]]");
    }
}

