/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.french;

import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.PennTreebankTokenizer;
import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.international.french.FrenchTreeNormalizer;
import edu.stanford.nlp.trees.international.french.FrenchTreeReader;
import java.io.Reader;
import java.io.Serializable;

public class FrenchTreeReaderFactory
implements TreeReaderFactory,
Serializable {
    private static final long serialVersionUID = 6928967570430642163L;
    private final boolean readPennFormat;

    public FrenchTreeReaderFactory() {
        this(false);
    }

    public FrenchTreeReaderFactory(boolean pennFormat) {
        this.readPennFormat = pennFormat;
    }

    @Override
    public TreeReader newTreeReader(Reader in) {
        if (this.readPennFormat) {
            return new PennTreeReader(in, new LabeledScoredTreeFactory(), new FrenchTreeNormalizer(), new PennTreebankTokenizer(in));
        }
        return new FrenchTreeReader(in);
    }
}

