/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.CyclicCoreLabel;
import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.parser.lexparser.LexicalizedParserQuery;
import edu.stanford.nlp.parser.lexparser.ParserAnnotations;
import edu.stanford.nlp.parser.lexparser.ParserConstraint;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.ParserAnnotatorUtils;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Function;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.ReflectionLoading;
import edu.stanford.nlp.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class ParserAnnotator
implements Annotator {
    private final boolean VERBOSE;
    private final boolean BUILD_GRAPHS;
    private final LexicalizedParser parser;
    private final Function<Tree, Tree> treeMap;
    private final int maxSentenceLength;
    private final long maxParseTime;
    public static final String[] DEFAULT_FLAGS = new String[]{"-retainTmpSubcategories"};

    public ParserAnnotator(boolean verbose, int maxSent) {
        this(System.getProperty("parse.model", LexicalizedParser.DEFAULT_PARSER_LOC), verbose, maxSent, DEFAULT_FLAGS);
    }

    public ParserAnnotator(String parserLoc, boolean verbose, int maxSent, String[] flags) {
        this(ParserAnnotator.loadModel(parserLoc, verbose, flags), verbose, maxSent);
    }

    public ParserAnnotator(LexicalizedParser parser, boolean verbose, int maxSent) {
        this(parser, verbose, maxSent, null);
    }

    public ParserAnnotator(LexicalizedParser parser, boolean verbose, int maxSent, Function<Tree, Tree> treeMap) {
        this.VERBOSE = verbose;
        this.BUILD_GRAPHS = true;
        this.parser = parser;
        this.maxSentenceLength = maxSent;
        this.treeMap = treeMap;
        this.maxParseTime = 0L;
    }

    public ParserAnnotator(String annotatorName, Properties props) {
        String model = props.getProperty(annotatorName + ".model", LexicalizedParser.DEFAULT_PARSER_LOC);
        if (model == null) {
            throw new IllegalArgumentException("No model specified for Parser annotator " + annotatorName);
        }
        this.VERBOSE = PropertiesUtils.getBool(props, annotatorName + ".debug", false);
        String[] flags = ParserAnnotator.convertFlagsToArray(props.getProperty(annotatorName + ".flags"));
        this.parser = ParserAnnotator.loadModel(model, this.VERBOSE, flags);
        this.maxSentenceLength = PropertiesUtils.getInt(props, annotatorName + ".maxlen", -1);
        String treeMapClass = props.getProperty(annotatorName + ".treemap");
        this.treeMap = treeMapClass == null ? null : (Function)ReflectionLoading.loadByReflection(treeMapClass, props);
        this.maxParseTime = PropertiesUtils.getLong(props, annotatorName + ".maxtime", 0L);
        this.BUILD_GRAPHS = PropertiesUtils.getBool(props, annotatorName + ".buildgraphs", true);
    }

    public static String signature(String annotatorName, Properties props) {
        StringBuilder os = new StringBuilder();
        os.append(annotatorName + ".model:" + props.getProperty(annotatorName + ".model", LexicalizedParser.DEFAULT_PARSER_LOC));
        os.append(annotatorName + ".debug:" + props.getProperty(annotatorName + ".debug", "false"));
        os.append(annotatorName + ".flags:" + props.getProperty(annotatorName + ".flags", ""));
        os.append(annotatorName + ".maxlen:" + props.getProperty(annotatorName + ".maxlen", "-1"));
        os.append(annotatorName + ".treemap:" + props.getProperty(annotatorName + ".treemap", ""));
        os.append(annotatorName + ".maxtime:" + props.getProperty(annotatorName + ".maxtime", "0"));
        os.append(annotatorName + ".buildgraphs:" + props.getProperty(annotatorName + ".buildgraphs", "true"));
        return os.toString();
    }

    public static String[] convertFlagsToArray(String parserFlags) {
        if (parserFlags == null) {
            return DEFAULT_FLAGS;
        }
        if (parserFlags.trim().equals("")) {
            return StringUtils.EMPTY_STRING_ARRAY;
        }
        return parserFlags.trim().split("\\s+");
    }

    private static LexicalizedParser loadModel(String parserLoc, boolean verbose, String[] flags) {
        if (verbose) {
            System.err.println("Loading Parser Model [" + parserLoc + "] ...");
        }
        LexicalizedParser result = LexicalizedParser.loadModel(parserLoc, flags);
        return result;
    }

    @Override
    public void annotate(Annotation annotation) {
        if (annotation.containsKey(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                Tree tree;
                List words;
                block12: {
                    words = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                    if (this.VERBOSE) {
                        System.err.println("Parsing: " + words);
                    }
                    tree = null;
                    if (this.maxSentenceLength <= 0 || words.size() < this.maxSentenceLength) {
                        final List constraints = (List)sentence.get(ParserAnnotations.ConstraintAnnotation.class);
                        if (this.maxParseTime > 0L) {
                            final Tree[] treeMem = new Tree[]{null};
                            Thread thread = new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    treeMem[0] = ParserAnnotator.this.process(constraints, words);
                                }
                            });
                            try {
                                thread.start();
                                thread.join(this.maxParseTime);
                                tree = treeMem[0];
                                if (!thread.isAlive()) break block12;
                                thread.stop();
                                if (this.VERBOSE) {
                                    System.err.println("WARNING: The parser took too long to parse: " + Sentence.listToString(words));
                                }
                                break block12;
                            }
                            catch (InterruptedException e) {
                                if (this.VERBOSE) {
                                    System.err.println("WARNING: Parsing of sentence failed: " + Sentence.listToString(words));
                                    e.printStackTrace();
                                }
                                break block12;
                            }
                        }
                        tree = this.process(constraints, words);
                    }
                }
                if (tree == null) {
                    tree = ParserAnnotatorUtils.xTree(words);
                }
                if (this.treeMap != null) {
                    tree = this.treeMap.apply(tree);
                }
                ParserAnnotatorUtils.fillInParseAnnotations(this.VERBOSE, this.BUILD_GRAPHS, sentence, tree);
            }
        } else {
            throw new RuntimeException("unable to find sentences in: " + annotation);
        }
    }

    private Tree process(List<ParserConstraint> constraints, List<CoreLabel> words) {
        LexicalizedParserQuery pq = this.parser.parserQuery();
        pq.setConstraints(constraints);
        pq.parse(words);
        Tree tree = null;
        try {
            tree = pq.getBestParse();
            tree.setScore(pq.getPCFGScore() % -10000.0);
        }
        catch (OutOfMemoryError e) {
            System.err.println("WARNING: Parsing of sentence ran out of memory.  Will ignore and continue: " + Sentence.listToString(words));
        }
        return tree;
    }

    private Tree doOneSentence(List<? extends CoreLabel> words) {
        ArrayList<CyclicCoreLabel> newWords = new ArrayList<CyclicCoreLabel>();
        for (CoreLabel coreLabel : words) {
            CyclicCoreLabel ml = new CyclicCoreLabel();
            ml.setWord(coreLabel.word());
            ml.setValue(coreLabel.word());
            newWords.add(ml);
        }
        if (this.maxSentenceLength <= 0 || newWords.size() < this.maxSentenceLength) {
            return this.parser.apply(newWords);
        }
        return ParserAnnotatorUtils.xTree(newWords);
    }
}

