/*
 * Decompiled with CFR 0.152.
 */
package de.jollyday.parser.impl;

import de.jollyday.Holiday;
import de.jollyday.HolidayType;
import de.jollyday.config.FixedWeekdayBetweenFixed;
import de.jollyday.config.Holidays;
import de.jollyday.parser.AbstractHolidayParser;
import java.util.Set;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedWeekdayBetweenFixedParser
extends AbstractHolidayParser {
    @Override
    public void parse(int year, Set<Holiday> holidays, Holidays config) {
        for (FixedWeekdayBetweenFixed fwm : config.getFixedWeekdayBetweenFixed()) {
            if (!this.isValid(fwm, year)) continue;
            LocalDate from = this.calendarUtil.create(year, fwm.getFrom());
            LocalDate to = this.calendarUtil.create(year, fwm.getTo());
            LocalDate result = null;
            while (!from.isAfter((ReadablePartial)to)) {
                if (from.getDayOfWeek() == this.xmlUtil.getWeekday(fwm.getWeekday())) {
                    result = from;
                    break;
                }
                from = from.plusDays(1);
            }
            if (result == null) continue;
            HolidayType type = this.xmlUtil.getType(fwm.getLocalizedType());
            holidays.add(new Holiday(result, fwm.getDescriptionPropertiesKey(), type));
        }
    }
}

