/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.pennchinese;

import edu.stanford.nlp.parser.ViterbiParserWithOptions;
import edu.stanford.nlp.parser.lexparser.ChineseTreebankParserParams;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.GrammaticalStructureFromDependenciesFactory;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeGraphNode;
import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.Treebank;
import edu.stanford.nlp.trees.TypedDependency;
import edu.stanford.nlp.trees.international.pennchinese.CHTBTokenizer;
import edu.stanford.nlp.trees.international.pennchinese.ChineseGrammaticalRelations;
import edu.stanford.nlp.trees.international.pennchinese.ChineseSemanticHeadFinder;
import edu.stanford.nlp.trees.international.pennchinese.ChineseTreebankLanguagePack;
import edu.stanford.nlp.util.Filter;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class ChineseGrammaticalStructure
extends GrammaticalStructure {
    private static HeadFinder shf = new ChineseSemanticHeadFinder();
    private static final long serialVersionUID = 8877651855167458256L;

    public ChineseGrammaticalStructure(Tree t) {
        this(t, new ChineseTreebankLanguagePack().punctuationWordRejectFilter());
    }

    public ChineseGrammaticalStructure(Tree t, Filter<String> puncFilter) {
        this(t, puncFilter, shf);
    }

    public ChineseGrammaticalStructure(Tree t, HeadFinder hf) {
        this(t, null, hf);
    }

    public ChineseGrammaticalStructure(Tree t, Filter<String> puncFilter, HeadFinder hf) {
        super(t, ChineseGrammaticalRelations.values(), hf, puncFilter);
    }

    public ChineseGrammaticalStructure(List<TypedDependency> projectiveDependencies, TreeGraphNode root) {
        super(projectiveDependencies, root);
    }

    @Override
    protected void collapseDependencies(List<TypedDependency> list, boolean CCprocess) {
        ChineseGrammaticalStructure.collapsePrepAndPoss(list);
    }

    private static void collapsePrepAndPoss(Collection<TypedDependency> list) {
        ArrayList<TypedDependency> newTypedDeps = new ArrayList<TypedDependency>();
        HashMap map = new HashMap();
        for (TypedDependency typedDep : list) {
            if (!map.containsKey(typedDep.gov())) {
                map.put(typedDep.gov(), new HashSet());
            }
            ((Set)map.get(typedDep.gov())).add(typedDep);
        }
        for (TypedDependency td1 : list) {
            if (td1.reln() == GrammaticalRelation.KILL) continue;
            TreeGraphNode td1Dep = td1.dep();
            String td1DepPOS = td1Dep.parent().value();
            Set possibles = (Set)map.get(td1Dep);
            if (possibles == null) continue;
            for (TypedDependency td2 : possibles) {
                if (td1.reln() != GrammaticalRelation.DEPENDENT || td2.reln() != GrammaticalRelation.DEPENDENT || !td1DepPOS.equals("P")) continue;
                GrammaticalRelation td3reln = ChineseGrammaticalRelations.valueOf(td1Dep.value());
                if (td3reln == null) {
                    td3reln = GrammaticalRelation.valueOf(GrammaticalRelation.Language.Chinese, td1Dep.value());
                }
                TypedDependency td3 = new TypedDependency(td3reln, td1.gov(), td2.dep());
                newTypedDeps.add(td3);
                td1.setReln(GrammaticalRelation.KILL);
                td2.setReln(GrammaticalRelation.KILL);
            }
            if (!td1.reln().equals(GrammaticalRelation.KILL)) continue;
            for (TypedDependency td2 : possibles) {
                if (td2.reln().equals(GrammaticalRelation.KILL)) continue;
                td2.setGov(td1.gov());
            }
        }
        for (TypedDependency td : list) {
            if (td.reln().equals(GrammaticalRelation.KILL)) continue;
            newTypedDeps.add(td);
        }
        list.clear();
        list.addAll(newTypedDeps);
    }

    private static void AddTreesFromFile(String treeFileName, String encoding, Treebank tb) {
        ChineseTreebankParserParams ctpp = new ChineseTreebankParserParams();
        try {
            Tree t;
            TreeReaderFactory trf = ctpp.treeReaderFactory();
            TreeReader tr = trf.newTreeReader(new InputStreamReader((InputStream)new FileInputStream(treeFileName), encoding));
            while ((t = tr.readTree()) != null) {
                tb.add(t);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("File problem: " + e);
        }
    }

    public static void main(String[] args) {
        MemoryTreebank tb = new MemoryTreebank();
        Properties props = StringUtils.argsToProperties(args);
        String treeFileName = props.getProperty("treeFile");
        String treeDirname = props.getProperty("treeDir");
        String sentFileName = props.getProperty("sentFile");
        String encoding = props.getProperty("encoding", "GB18030");
        String hf = props.getProperty("hf");
        String parserModel = props.getProperty("parserModel", "/u/nlp/data/lexparser/chineseFactored.ser.gz");
        try {
            if (hf != null) {
                shf = (HeadFinder)Class.forName(hf).newInstance();
                System.err.println("Using " + hf);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Fail to use HeadFinder: " + hf);
        }
        if (args.length == 0) {
            System.err.println("Please provide -treeFile treeFile or -sentFile sentFile");
        } else {
            if (treeDirname != null && treeFileName != null) {
                throw new RuntimeException("Only one of treeDirname or treeFileName should be set");
            }
            if (treeDirname != null) {
                String[] files;
                File dir = new File(treeDirname);
                for (String file : files = dir.list()) {
                    ChineseGrammaticalStructure.AddTreesFromFile(treeDirname + "/" + file, encoding, tb);
                }
            } else if (treeFileName != null) {
                ChineseGrammaticalStructure.AddTreesFromFile(treeFileName, encoding, tb);
            } else if (sentFileName != null) {
                ViterbiParserWithOptions lp;
                try {
                    Class[] classes = new Class[]{String.class};
                    Constructor<?> constr = Class.forName("edu.stanford.nlp.parser.lexparser.LexicalizedParser").getConstructor(classes);
                    String[] opts = new String[]{"-retainTmpSubcategories"};
                    lp = (ViterbiParserWithOptions)constr.newInstance(parserModel);
                    lp.setOptionFlags(opts);
                }
                catch (Exception cnfe) {
                    cnfe.printStackTrace();
                    return;
                }
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new FileReader(sentFileName));
                }
                catch (FileNotFoundException e) {
                    System.err.println("Cannot find " + sentFileName);
                    System.exit(1);
                }
                try {
                    String line;
                    System.out.println("Processing sentence file " + sentFileName);
                    while ((line = reader.readLine()) != null) {
                        CHTBTokenizer chtb = new CHTBTokenizer(new StringReader(line));
                        List words = chtb.tokenize();
                        lp.parse(words);
                        Tree parseTree = lp.getBestParse();
                        ((AbstractCollection)tb).add(parseTree);
                    }
                    reader.close();
                }
                catch (Exception e) {
                    throw new RuntimeException("Exception reading key file " + sentFileName, e);
                }
            }
        }
        System.out.println("Phrase structure tree, then dependencies, then collapsed dependencies");
        for (Tree t : tb) {
            System.out.println("==================================================");
            ChineseGrammaticalStructure gs = new ChineseGrammaticalStructure(t);
            t.pennPrint();
            System.out.println("----------------------------");
            System.out.println(StringUtils.join(gs.typedDependencies(true), "\n"));
            System.out.println("----------------------------");
            System.out.println(StringUtils.join(gs.typedDependenciesCollapsed(true), "\n"));
        }
    }

    public static List<GrammaticalStructure> readCoNLLXGrammaticStructureCollection(String fileName) throws IOException {
        return ChineseGrammaticalStructure.readCoNLLXGrammaticStructureCollection(fileName, ChineseGrammaticalRelations.shortNameToGRel, new FromDependenciesFactory());
    }

    public static ChineseGrammaticalStructure buildCoNNLXGrammaticStructure(List<List<String>> tokenFields) {
        return (ChineseGrammaticalStructure)ChineseGrammaticalStructure.buildCoNNLXGrammaticStructure(tokenFields, ChineseGrammaticalRelations.shortNameToGRel, new FromDependenciesFactory());
    }

    public static class FromDependenciesFactory
    implements GrammaticalStructureFromDependenciesFactory {
        @Override
        public ChineseGrammaticalStructure build(List<TypedDependency> tdeps, TreeGraphNode root) {
            return new ChineseGrammaticalStructure(tdeps, root);
        }
    }
}

