/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ie.NERClassifierCombiner;
import edu.stanford.nlp.ie.regexp.NumberSequenceClassifier;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Timing;
import java.io.IOException;
import java.util.List;
import java.util.Properties;

public class NERCombinerAnnotator
implements Annotator {
    private NERClassifierCombiner ner;
    private Timing timer = new Timing();
    private boolean VERBOSE = true;

    public NERCombinerAnnotator() throws IOException, ClassNotFoundException {
        this(true);
    }

    private void timerStart(String msg) {
        if (this.VERBOSE) {
            this.timer.start();
            System.err.println(msg);
        }
    }

    private void timerStop() {
        if (this.VERBOSE) {
            this.timer.stop("done.");
        }
    }

    public NERCombinerAnnotator(boolean verbose) throws IOException, ClassNotFoundException {
        this.VERBOSE = verbose;
        this.timerStart("Loading NER combiner model...");
        this.ner = new NERClassifierCombiner(new Properties());
        this.timerStop();
    }

    public NERCombinerAnnotator(boolean verbose, String ... classifiers) throws IOException, ClassNotFoundException {
        this.VERBOSE = verbose;
        this.timerStart("Loading NER combiner model...");
        this.ner = new NERClassifierCombiner(classifiers);
        this.timerStop();
    }

    public NERCombinerAnnotator(NERClassifierCombiner ner, boolean verbose) {
        this.VERBOSE = verbose;
        this.ner = ner;
    }

    @Override
    public void annotate(Annotation annotation) {
        this.timerStart("Adding NER Combiner annotation...");
        if (annotation.containsKey(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                boolean first;
                List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                List output = this.ner.classifySentenceWithGlobalInformation(tokens, annotation, sentence);
                if (this.VERBOSE) {
                    first = true;
                    System.err.print("NERCombinerAnnotator direct output: [");
                    for (CoreLabel w : output) {
                        if (first) {
                            first = false;
                        } else {
                            System.err.print(", ");
                        }
                        System.err.print(w.toString());
                    }
                    System.err.println(']');
                }
                for (int i = 0; i < tokens.size(); ++i) {
                    String neTag = (String)((CoreLabel)output.get(i)).get(CoreAnnotations.NamedEntityTagAnnotation.class);
                    String normNeTag = (String)((CoreLabel)output.get(i)).get(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class);
                    ((CoreLabel)tokens.get(i)).setNER(neTag);
                    if (normNeTag != null) {
                        ((CoreLabel)tokens.get(i)).set(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class, normNeTag);
                    }
                    NumberSequenceClassifier.transferAnnotations((CoreLabel)output.get(i), (CoreLabel)tokens.get(i));
                }
                if (!this.VERBOSE) continue;
                first = true;
                System.err.print("NERCombinerAnnotator output: [");
                for (CoreLabel w : tokens) {
                    if (first) {
                        first = false;
                    } else {
                        System.err.print(", ");
                    }
                    System.err.print(w.toShorterString("Word", "NamedEntityTag", "NormalizedNamedEntityTag"));
                }
                System.err.println(']');
            }
        } else {
            throw new RuntimeException("unable to find sentences in: " + annotation);
        }
    }
}

