/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.lexparser.AbstractTreeExtractor;
import edu.stanford.nlp.parser.lexparser.BinaryGrammar;
import edu.stanford.nlp.parser.lexparser.BinaryRule;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.UnaryGrammar;
import edu.stanford.nlp.parser.lexparser.UnaryRule;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.Pair;
import java.util.HashSet;
import java.util.Set;

public class BinaryGrammarExtractor
extends AbstractTreeExtractor<Pair<UnaryGrammar, BinaryGrammar>> {
    protected Index<String> stateIndex;
    private ClassicCounter<UnaryRule> unaryRuleCounter = new ClassicCounter();
    private ClassicCounter<BinaryRule> binaryRuleCounter = new ClassicCounter();
    protected ClassicCounter<String> symbolCounter = new ClassicCounter();
    private Set<BinaryRule> binaryRules = new HashSet<BinaryRule>();
    private Set<UnaryRule> unaryRules = new HashSet<UnaryRule>();

    public BinaryGrammarExtractor(Options op, Index<String> index) {
        super(op);
        this.stateIndex = index;
    }

    @Override
    protected void tallyInternalNode(Tree lt, double weight2) {
        if (lt.children().length == 1) {
            UnaryRule ur = new UnaryRule(this.stateIndex.indexOf(lt.label().value(), true), this.stateIndex.indexOf(lt.children()[0].label().value(), true));
            this.symbolCounter.incrementCount(this.stateIndex.get(ur.parent), weight2);
            this.unaryRuleCounter.incrementCount(ur, weight2);
            this.unaryRules.add(ur);
        } else {
            BinaryRule br = new BinaryRule(this.stateIndex.indexOf(lt.label().value(), true), this.stateIndex.indexOf(lt.children()[0].label().value(), true), this.stateIndex.indexOf(lt.children()[1].label().value(), true));
            this.symbolCounter.incrementCount(this.stateIndex.get(br.parent), weight2);
            this.binaryRuleCounter.incrementCount(br, weight2);
            this.binaryRules.add(br);
        }
    }

    @Override
    public Pair<UnaryGrammar, BinaryGrammar> formResult() {
        this.stateIndex.indexOf(".$$.", true);
        BinaryGrammar bg = new BinaryGrammar(this.stateIndex);
        UnaryGrammar ug = new UnaryGrammar(this.stateIndex);
        for (UnaryRule ur : this.unaryRules) {
            ur.score = (float)Math.log(this.unaryRuleCounter.getCount(ur) / this.symbolCounter.getCount(this.stateIndex.get(ur.parent)));
            if (this.op.trainOptions.compactGrammar() >= 4) {
                ur.score = (float)this.unaryRuleCounter.getCount(ur);
            }
            ug.addRule(ur);
        }
        for (BinaryRule br : this.binaryRules) {
            br.score = (float)Math.log((this.binaryRuleCounter.getCount(br) - this.op.trainOptions.ruleDiscount) / this.symbolCounter.getCount(this.stateIndex.get(br.parent)));
            if (this.op.trainOptions.compactGrammar() >= 4) {
                br.score = (float)this.binaryRuleCounter.getCount(br);
            }
            bg.addRule(br);
        }
        return new Pair<UnaryGrammar, BinaryGrammar>(ug, bg);
    }
}

