/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.optimization;

import edu.stanford.nlp.optimization.DiffFunction;
import edu.stanford.nlp.optimization.HasInitial;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;

public abstract class AbstractCachingDiffFunction
implements DiffFunction,
HasInitial {
    double[] lastX;
    int fEvaluations;
    protected double[] derivative;
    protected double value;
    Random generator = new Random(Integer.MAX_VALUE);

    public boolean gradientCheck() {
        int i;
        double epsilon = 1.0E-4;
        double diffThreshold = 0.05;
        double diffPctThreshold = 0.1;
        int numOfChecks = 100;
        int numOfRandomChecks = 50;
        double twoEpsilon = epsilon * 2.0;
        double[] x = this.initial();
        int xLen = x.length;
        this.derivativeAt(x);
        double[] savedDeriv = new double[xLen];
        System.arraycopy(this.derivative, 0, savedDeriv, 0, this.derivative.length);
        double pct = 0.0;
        int interval = x.length / numOfChecks;
        ArrayList<Integer> indicesToCheck = new ArrayList<Integer>();
        for (int paramIndex = 0; paramIndex < xLen; paramIndex += interval) {
            indicesToCheck.add(paramIndex);
        }
        for (i = xLen - 1; i >= 0 && i > xLen - numOfChecks; --i) {
            indicesToCheck.add(i);
        }
        for (i = 1; i < xLen && i < numOfChecks; ++i) {
            indicesToCheck.add(i);
        }
        for (i = 0; i < numOfRandomChecks; ++i) {
            indicesToCheck.add(this.generator.nextInt(xLen));
        }
        Iterator i$ = indicesToCheck.iterator();
        while (i$.hasNext()) {
            int paramIndex = (Integer)i$.next();
            double oldX = x[paramIndex];
            x[paramIndex] = oldX + epsilon;
            double plusVal = this.valueAt(x);
            x[paramIndex] = oldX - epsilon;
            double minusVal = this.valueAt(x);
            double appDeriv = (plusVal - minusVal) / twoEpsilon;
            double calcDeriv = savedDeriv[paramIndex];
            double diff = Math.abs(appDeriv - calcDeriv);
            pct = diff / Math.min(Math.abs(appDeriv), Math.abs(calcDeriv));
            if (diff > diffThreshold && pct > diffPctThreshold) {
                System.err.println("Gradient check failed at index " + paramIndex + ", appGrad=" + appDeriv + ", calcGrad=" + calcDeriv + ", diff=" + diff + ", pct=" + pct);
                return false;
            }
            System.err.println("Gradient check passed at index " + paramIndex + ", appGrad=" + appDeriv + ", calcGrad=" + calcDeriv + ", diff=" + diff + ", pct=" + pct);
            x[paramIndex] = oldX;
        }
        return true;
    }

    protected abstract void calculate(double[] var1);

    protected void clearCache() {
        if (this.lastX != null) {
            this.lastX[0] = Double.NaN;
        }
    }

    @Override
    public double[] initial() {
        double[] initial = new double[this.domainDimension()];
        return initial;
    }

    public double[] randomInitial() {
        double[] initial = new double[this.domainDimension()];
        for (int i = 0; i < initial.length; ++i) {
            initial[i] = this.generator.nextDouble();
        }
        return initial;
    }

    protected static void copy(double[] copy, double[] orig) {
        System.arraycopy(orig, 0, copy, 0, orig.length);
    }

    void ensure(double[] x) {
        if (Arrays.equals(x, this.lastX)) {
            return;
        }
        if (this.lastX == null) {
            this.lastX = new double[this.domainDimension()];
        }
        if (this.derivative == null) {
            this.derivative = new double[this.domainDimension()];
        }
        AbstractCachingDiffFunction.copy(this.lastX, x);
        ++this.fEvaluations;
        this.calculate(x);
    }

    @Override
    public double valueAt(double[] x) {
        this.ensure(x);
        return this.value;
    }

    @Override
    public double[] derivativeAt(double[] x) {
        this.ensure(x);
        return this.derivative;
    }

    public double lastValue() {
        return this.value;
    }
}

