/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.crf;

import edu.stanford.nlp.ie.crf.CliquePotentialFunction;
import edu.stanford.nlp.ie.crf.NonLinearCliquePotentialFunction;
import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.sequences.SeqClassifierFlags;

public class NonLinearSecondOrderCliquePotentialFunction
implements CliquePotentialFunction {
    double[][] inputLayerWeights4Edge;
    double[][] outputLayerWeights4Edge;
    double[][] inputLayerWeights;
    double[][] outputLayerWeights;
    SeqClassifierFlags flags;

    public NonLinearSecondOrderCliquePotentialFunction(double[][] inputLayerWeights4Edge, double[][] outputLayerWeights4Edge, double[][] inputLayerWeights, double[][] outputLayerWeights, SeqClassifierFlags flags) {
        this.inputLayerWeights4Edge = inputLayerWeights4Edge;
        this.outputLayerWeights4Edge = outputLayerWeights4Edge;
        this.inputLayerWeights = inputLayerWeights;
        this.outputLayerWeights = outputLayerWeights;
        this.flags = flags;
    }

    @Override
    public double computeCliquePotential(int cliqueSize, int labelIndex, int[] cliqueFeatures) {
        double[][] inputWeights;
        double output = 0.0;
        double[][] outputWeights = null;
        if (cliqueSize > 1) {
            inputWeights = this.inputLayerWeights4Edge;
            outputWeights = this.outputLayerWeights4Edge;
        } else {
            inputWeights = this.inputLayerWeights;
            outputWeights = this.outputLayerWeights;
        }
        double[] hiddenLayer = NonLinearCliquePotentialFunction.hiddenLayerOutput(inputWeights, cliqueFeatures, this.flags);
        int outputLayerSize = inputWeights.length / outputWeights[0].length;
        if (this.flags.useOutputLayer) {
            double[] outputWs = null;
            outputWs = this.flags.tieOutputLayer ? outputWeights[0] : outputWeights[labelIndex];
            if (this.flags.softmaxOutputLayer) {
                outputWs = ArrayMath.softmax(outputWs);
            }
            for (int i = 0; i < inputWeights.length; ++i) {
                if (this.flags.sparseOutputLayer || this.flags.tieOutputLayer) {
                    if (i % outputLayerSize != labelIndex) continue;
                    output += outputWs[i / outputLayerSize] * hiddenLayer[i];
                    continue;
                }
                output += outputWs[i] * hiddenLayer[i];
            }
        } else {
            output = hiddenLayer[labelIndex];
        }
        return output;
    }
}

