#!/usr/bin/env perl

# Pragmas.
use strict;
use warnings;

# Modules.
use Encode qw(decode_utf8 encode_utf8);
use Map::Tube::SaintPetersburg;

# Object.
my $obj = Map::Tube::SaintPetersburg->new;

# Get route.
my $route = $obj->get_shortest_route(decode_utf8('Лесная'), decode_utf8('Озерки'));

# Print out type.
print "Route: ".encode_utf8($route)."\n";

# Output:
# Route: Лесная (Кировско-Выборгская линия), Выборгская (Кировско-Выборгская линия), Площадь Ленина (Кировско-Выборгская линия), Чернышевская (Кировско-Выборгская линия), Площадь Восстания (Кировско-Выборгская линия), Владимирская (Кировско-Выборгская линия), Пушкинская (Кировско-Выборгская линия), Технологический институт (Кировско-Выборгская линия,Московско-Петроградская линия), Сенная площадь (Московско-Петроградская линия), Невский проспект (Московско-Петроградская линия), Горьковская (Московско-Петроградская линия), Петроградская (Московско-Петроградская линия), Чёрная речка (Московско-Петроградская линия), Пионерская (Московско-Петроградская линия), Удельная (Московско-Петроградская линия), Озерки (Московско-Петроградская линия)