# Generated by default/object.tt
package Paws::WAFV2::Label;
  use Moose;
  has Name => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::WAFV2::Label

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::WAFV2::Label object:

  $service_obj->Method(Att1 => { Name => $value, ..., Name => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::WAFV2::Label object:

  $result = $service_obj->Method(...);
  $result->Att1->Name

=head1 DESCRIPTION

A single label container. This is used as an element of a label array
in multiple contexts, for example, in C<RuleLabels> inside a Rule and
in C<Labels> inside a SampledHTTPRequest.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Name => Str

The label string.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::WAFV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

