# Generated by default/object.tt
package Paws::SecurityHub::AwsDynamoDbTableGlobalSecondaryIndex;
  use Moose;
  has Backfilling => (is => 'ro', isa => 'Bool');
  has IndexArn => (is => 'ro', isa => 'Str');
  has IndexName => (is => 'ro', isa => 'Str');
  has IndexSizeBytes => (is => 'ro', isa => 'Int');
  has IndexStatus => (is => 'ro', isa => 'Str');
  has ItemCount => (is => 'ro', isa => 'Int');
  has KeySchema => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsDynamoDbTableKeySchema]');
  has Projection => (is => 'ro', isa => 'Paws::SecurityHub::AwsDynamoDbTableProjection');
  has ProvisionedThroughput => (is => 'ro', isa => 'Paws::SecurityHub::AwsDynamoDbTableProvisionedThroughput');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsDynamoDbTableGlobalSecondaryIndex

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsDynamoDbTableGlobalSecondaryIndex object:

  $service_obj->Method(Att1 => { Backfilling => $value, ..., ProvisionedThroughput => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsDynamoDbTableGlobalSecondaryIndex object:

  $result = $service_obj->Method(...);
  $result->Att1->Backfilling

=head1 DESCRIPTION

Information abut a global secondary index for the table.

=head1 ATTRIBUTES


=head2 Backfilling => Bool

Whether the index is currently backfilling.


=head2 IndexArn => Str

The ARN of the index.


=head2 IndexName => Str

The name of the index.


=head2 IndexSizeBytes => Int

The total size in bytes of the index.


=head2 IndexStatus => Str

The current status of the index.


=head2 ItemCount => Int

The number of items in the index.


=head2 KeySchema => ArrayRef[L<Paws::SecurityHub::AwsDynamoDbTableKeySchema>]

The key schema for the index.


=head2 Projection => L<Paws::SecurityHub::AwsDynamoDbTableProjection>

Attributes that are copied from the table into an index.


=head2 ProvisionedThroughput => L<Paws::SecurityHub::AwsDynamoDbTableProvisionedThroughput>

Information about the provisioned throughput settings for the indexes.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

