# Generated by default/object.tt
package Paws::MediaTailor::Channel;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str', required => 1);
  has ChannelName => (is => 'ro', isa => 'Str', required => 1);
  has ChannelState => (is => 'ro', isa => 'Str', required => 1);
  has CreationTime => (is => 'ro', isa => 'Str');
  has LastModifiedTime => (is => 'ro', isa => 'Str');
  has Outputs => (is => 'ro', isa => 'ArrayRef[Paws::MediaTailor::ResponseOutputItem]', required => 1);
  has PlaybackMode => (is => 'ro', isa => 'Str', required => 1);
  has Tags => (is => 'ro', isa => 'Paws::MediaTailor::__mapOf__string', request_name => 'tags', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaTailor::Channel

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaTailor::Channel object:

  $service_obj->Method(Att1 => { Arn => $value, ..., Tags => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaTailor::Channel object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

The configuration parameters for a channel.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Arn => Str

The ARN of the channel.


=head2 B<REQUIRED> ChannelName => Str

The name of the channel.


=head2 B<REQUIRED> ChannelState => Str

Returns the state whether the channel is running or not.


=head2 CreationTime => Str

The timestamp of when the channel was created.


=head2 LastModifiedTime => Str

The timestamp of when the channel was last modified.


=head2 B<REQUIRED> Outputs => ArrayRef[L<Paws::MediaTailor::ResponseOutputItem>]

The channel's output properties.


=head2 B<REQUIRED> PlaybackMode => Str

The type of playback mode for this channel. Possible values: ONCE or
LOOP.


=head2 Tags => L<Paws::MediaTailor::__mapOf__string>

The tags to assign to the channel.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaTailor>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

