# Generated by default/object.tt
package Paws::IoTWireless::LoRaWANDeviceMetadata;
  use Moose;
  has DataRate => (is => 'ro', isa => 'Int');
  has DevEui => (is => 'ro', isa => 'Str');
  has FPort => (is => 'ro', isa => 'Int');
  has Frequency => (is => 'ro', isa => 'Int');
  has Gateways => (is => 'ro', isa => 'ArrayRef[Paws::IoTWireless::LoRaWANGatewayMetadata]');
  has Timestamp => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTWireless::LoRaWANDeviceMetadata

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTWireless::LoRaWANDeviceMetadata object:

  $service_obj->Method(Att1 => { DataRate => $value, ..., Timestamp => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTWireless::LoRaWANDeviceMetadata object:

  $result = $service_obj->Method(...);
  $result->Att1->DataRate

=head1 DESCRIPTION

LoRaWAN device metatdata.

=head1 ATTRIBUTES


=head2 DataRate => Int

The DataRate value.


=head2 DevEui => Str

The DevEUI value.


=head2 FPort => Int

The FPort value.


=head2 Frequency => Int

The device's channel frequency in Hz.


=head2 Gateways => ArrayRef[L<Paws::IoTWireless::LoRaWANGatewayMetadata>]

Information about the gateways accessed by the device.


=head2 Timestamp => Str

The date and time of the metadata.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTWireless>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

