# Generated by default/object.tt
package Paws::CloudFront::FunctionAssociations;
  use Moose;
  has Items => (is => 'ro', isa => 'ArrayRef[Paws::CloudFront::FunctionAssociation]', request_name => 'FunctionAssociation', traits => ['NameInRequest']);
  has Quantity => (is => 'ro', isa => 'Int', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudFront::FunctionAssociations

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudFront::FunctionAssociations object:

  $service_obj->Method(Att1 => { Items => $value, ..., Quantity => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudFront::FunctionAssociations object:

  $result = $service_obj->Method(...);
  $result->Att1->Items

=head1 DESCRIPTION

A list of CloudFront functions that are associated with a cache
behavior in a CloudFront distribution. CloudFront functions must be
published to the C<LIVE> stage to associate them with a cache behavior.

=head1 ATTRIBUTES


=head2 Items => ArrayRef[L<Paws::CloudFront::FunctionAssociation>]

The CloudFront functions that are associated with a cache behavior in a
CloudFront distribution. CloudFront functions must be published to the
C<LIVE> stage to associate them with a cache behavior.


=head2 B<REQUIRED> Quantity => Int

The number of CloudFront functions in the list.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudFront>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

