package JIRA::REST::Class::Issue::LinkType;
use base qw( JIRA::REST::Class::Abstract );
use strict;
use warnings;
use v5.10;

our $VERSION = '0.01';

# ABSTRACT: A helper class for C<JIRA::REST::Class> that represents a JIRA link type as an object.

__PACKAGE__->mk_data_ro_accessors(qw( id name inward outward self ));

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

JIRA::REST::Class::Issue::LinkType - A helper class for C<JIRA::REST::Class> that represents a JIRA link type as an object.

=head1 VERSION

version 0.01

=head1 METHODS

=head2 B<id>

The id of the link type.

=head2 B<name>

The name of the link type.

=head2 B<inward>

The text for the inward name of the link type.

=head2 B<outward>

The text for the outward name of the link type.

=head2 B<self>

The full URL for the JIRA REST API call for the link type.

=head1 AUTHOR

Packy Anderson <packy@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2016 by Packy Anderson.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
