package Google::Ads::AdWords::v201402::AdGroupChangeData;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/ch/v201402' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %adGroupId_of :ATTR(:get<adGroupId>);
my %adGroupChangeStatus_of :ATTR(:get<adGroupChangeStatus>);
my %changedAds_of :ATTR(:get<changedAds>);
my %changedCriteria_of :ATTR(:get<changedCriteria>);
my %deletedCriteria_of :ATTR(:get<deletedCriteria>);
my %changedFeeds_of :ATTR(:get<changedFeeds>);
my %deletedFeeds_of :ATTR(:get<deletedFeeds>);
my %changedAdGroupBidModifierCriteria_of :ATTR(:get<changedAdGroupBidModifierCriteria>);
my %deletedAdGroupBidModifierCriteria_of :ATTR(:get<deletedAdGroupBidModifierCriteria>);

__PACKAGE__->_factory(
    [ qw(        adGroupId
        adGroupChangeStatus
        changedAds
        changedCriteria
        deletedCriteria
        changedFeeds
        deletedFeeds
        changedAdGroupBidModifierCriteria
        deletedAdGroupBidModifierCriteria

    ) ],
    {
        'adGroupId' => \%adGroupId_of,
        'adGroupChangeStatus' => \%adGroupChangeStatus_of,
        'changedAds' => \%changedAds_of,
        'changedCriteria' => \%changedCriteria_of,
        'deletedCriteria' => \%deletedCriteria_of,
        'changedFeeds' => \%changedFeeds_of,
        'deletedFeeds' => \%deletedFeeds_of,
        'changedAdGroupBidModifierCriteria' => \%changedAdGroupBidModifierCriteria_of,
        'deletedAdGroupBidModifierCriteria' => \%deletedAdGroupBidModifierCriteria_of,
    },
    {
        'adGroupId' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'adGroupChangeStatus' => 'Google::Ads::AdWords::v201402::ChangeStatus',
        'changedAds' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'changedCriteria' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'deletedCriteria' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'changedFeeds' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'deletedFeeds' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'changedAdGroupBidModifierCriteria' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'deletedAdGroupBidModifierCriteria' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
    },
    {

        'adGroupId' => 'adGroupId',
        'adGroupChangeStatus' => 'adGroupChangeStatus',
        'changedAds' => 'changedAds',
        'changedCriteria' => 'changedCriteria',
        'deletedCriteria' => 'deletedCriteria',
        'changedFeeds' => 'changedFeeds',
        'deletedFeeds' => 'deletedFeeds',
        'changedAdGroupBidModifierCriteria' => 'changedAdGroupBidModifierCriteria',
        'deletedAdGroupBidModifierCriteria' => 'deletedAdGroupBidModifierCriteria',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201402::AdGroupChangeData

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
AdGroupChangeData from the namespace https://adwords.google.com/api/adwords/ch/v201402.

Holds information about a changed adgroup 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * adGroupId


=item * adGroupChangeStatus


=item * changedAds


=item * changedCriteria


=item * deletedCriteria


=item * changedFeeds


=item * deletedFeeds


=item * changedAdGroupBidModifierCriteria


=item * deletedAdGroupBidModifierCriteria




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

