package Google::Ads::AdWords::v201209::AdExtensionOverrideSelector;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201209' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %campaignIds_of :ATTR(:get<campaignIds>);
my %adIds_of :ATTR(:get<adIds>);
my %adExtensionIds_of :ATTR(:get<adExtensionIds>);
my %statuses_of :ATTR(:get<statuses>);
my %paging_of :ATTR(:get<paging>);

__PACKAGE__->_factory(
    [ qw(        campaignIds
        adIds
        adExtensionIds
        statuses
        paging

    ) ],
    {
        'campaignIds' => \%campaignIds_of,
        'adIds' => \%adIds_of,
        'adExtensionIds' => \%adExtensionIds_of,
        'statuses' => \%statuses_of,
        'paging' => \%paging_of,
    },
    {
        'campaignIds' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'adIds' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'adExtensionIds' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'statuses' => 'Google::Ads::AdWords::v201209::AdExtensionOverride::Status',
        'paging' => 'Google::Ads::AdWords::v201209::Paging',
    },
    {

        'campaignIds' => 'campaignIds',
        'adIds' => 'adIds',
        'adExtensionIds' => 'adExtensionIds',
        'statuses' => 'statuses',
        'paging' => 'paging',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201209::AdExtensionOverrideSelector

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
AdExtensionOverrideSelector from the namespace https://adwords.google.com/api/adwords/cm/v201209.

Specifies criteria for selecting a set of AdExtensionOverrides. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * campaignIds


=item * adIds


=item * adExtensionIds


=item * statuses


=item * paging




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

