package Graphics::ColorNamesCMYK::ToutesLesCouleursCom::Brown;

use strict;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-05-06'; # DATE
our $DIST = 'Graphics-ColorNamesCMYK-ToutesLesCouleursCom'; # DIST
our $VERSION = '0.001'; # VERSION

our $NAMES_CMYK_TABLE = {
  'brown' => 0x00225140, # 0,34,81,64
  'mahogany' => 0x00334f2f, # 0,51,79,47
  'chestnut' => 0x00264d23, # 0,38,77,35
  'amber' => 0x00136406, # 0,19,100,6
  'auburn' => 0x003d5c26, # 0,61,92,38
  'suntan' => 0x0016352d, # 0,22,53,45
  'beige' => 0x000e2516, # 0,14,37,22
  'light beige' => 0x00000a28, # 0,0,10,40
  'beigeasse' => 0x00051e1f, # 0,5,30,31
  'bistre' => 0x001e314c, # 0,30,49,76
  'bistre' => 0x00122a30, # 0,18,42,48
  'bitumen' => 0x00163145, # 0,22,49,69
  'blet' => 0x00225140, # 0,34,81,64
  'brick' => 0x00415030, # 0,65,80,48
  'bronze' => 0x0014493e, # 0,20,73,62
  'walnut brou' => 0x002e5e4b, # 0,46,94,75
  'office' => 0x0013363a, # 0,19,54,58
  'cocoa' => 0x0017283e, # 0,23,40,62
  'cachou' => 0x002b4a52, # 0,43,74,82
  'cafe' => 0x00226349, # 0,34,99,73
  'latte' => 0x00163d35, # 0,22,61,53
  'cannelle' => 0x001e3a33, # 0,30,58,51
  'caramel' => 0x003c6433, # 0,60,100,51
  'chestnut' => 0x000f1e32, # 0,15,30,50
  'light' => 0x0016352d, # 0,22,53,45
  'cauldron' => 0x00265930, # 0,38,89,48
  'chocolate' => 0x00243e41, # 0,36,62,65
  'pumpkin' => 0x002d500d, # 0,45,80,13
  'fauve' => 0x00365f20, # 0,54,95,32
  'sheet-dead' => 0x002f4828, # 0,47,72,40
  'grege' => 0x0007131b, # 0,7,19,27
  'moorish grey' => 0x000a243b, # 0,10,36,59
  'lavalliere' => 0x00264c2c, # 0,38,76,44
  'brown' => 0x00356441, # 0,53,100,65
  'mordore' => 0x0022512f, # 0,34,81,47
  'hazel' => 0x002a492a, # 0,42,73,42
  'burnt orange' => 0x003a6414, # 0,58,100,20
  'chip' => 0x00485845, # 0,72,88,69
  'red bismarck' => 0x004d5e23, # 0,77,94,35
  'red tomette' => 0x00394620, # 0,57,70,32
  'rust' => 0x002b5528, # 0,43,85,40
  'beef blood' => 0x005d6437, # 0,93,100,55
  'senois' => 0x00374a2d, # 0,55,74,45
  'sepia' => 0x00111d22, # 0,17,29,34
  'sepia' => 0x00152b20, # 0,21,43,32
  'tobacco' => 0x002f5126, # 0,47,81,38
  'sienna' => 0x00293f2c, # 0,41,63,44
  'umber' => 0x00071b3e, # 0,7,27,62
  'umber' => 0x0019492b, # 0,25,73,43
  'vanilla' => 0x0008200c, # 0,8,32,12
};


1;
# ABSTRACT: CMYK colors from http://toutes-les-couleurs.com/ (brown)

__END__

=pod

=encoding UTF-8

=head1 NAME

Graphics::ColorNamesCMYK::ToutesLesCouleursCom::Brown - CMYK colors from http://toutes-les-couleurs.com/ (brown)

=head1 VERSION

This document describes version 0.001 of Graphics::ColorNamesCMYK::ToutesLesCouleursCom::Brown (from Perl distribution Graphics-ColorNamesCMYK-ToutesLesCouleursCom), released on 2024-05-06.

=head1 DESCRIPTION

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Graphics-ColorNamesCMYK-ToutesLesCouleursCom>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Graphics-ColorNamesCMYK-ToutesLesCouleursCom>.

=head1 SEE ALSO

Other C<Graphics::ColorNamesCMYK::ToutesLesCoulersCom::*> modules.

Other C<Graphics::ColorNamesCMYK::*> modules.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Graphics-ColorNamesCMYK-ToutesLesCouleursCom>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
