package ICU;
#
#    ICU.pm
#
#    $Id: ICU.pm,v 1.2 2001/07/10 11:27:54 mrperl Exp $
#
#    Copyright (c) 2000 Brian Stell
#
#    This package is free software and is provided ``as is'' without
#    express or implied warranty. It may be used, redistributed and/or
#    modified under the terms of the Perl Artistic License 
#    (see http://www.perl.com/perl/misc/Artistic.html)
#

use strict;
use Carp;
use vars qw( $AUTOLOAD @EXPORT_OK @ISA $VERSION );

use Exporter;
use DynaLoader;
@ISA = qw(Exporter DynaLoader);
use AutoLoader;

$VERSION = '0.01.00';

Exporter::export_tags();

@EXPORT_OK = qw(
U_ERROR_INFO_START
U_USING_FALLBACK_ERROR
U_USING_DEFAULT_ERROR
U_SAFECLONE_ALLOCATED_ERROR
U_ERROR_INFO_LIMIT
U_ZERO_ERROR
U_ILLEGAL_ARGUMENT_ERROR
U_MISSING_RESOURCE_ERROR
U_INVALID_FORMAT_ERROR
U_FILE_ACCESS_ERROR
U_INTERNAL_PROGRAM_ERROR
U_MESSAGE_PARSE_ERROR
U_MEMORY_ALLOCATION_ERROR
U_INDEX_OUTOFBOUNDS_ERROR
U_PARSE_ERROR
U_INVALID_CHAR_FOUND
U_TRUNCATED_CHAR_FOUND
U_ILLEGAL_CHAR_FOUND
U_INVALID_TABLE_FORMAT
U_INVALID_TABLE_FILE
U_BUFFER_OVERFLOW_ERROR
U_UNSUPPORTED_ERROR
U_RESOURCE_TYPE_MISMATCH
U_ILLEGAL_ESCAPE_SEQUENCE
U_UNSUPPORTED_ESCAPE_SEQUENCE
U_NO_SPACE_AVAILABLE
U_ERROR_LIMIT
);

sub AUTOLOAD {
    # This AUTOLOAD is used to 'autoload' constants from the constant()
    # XS function.  If a constant is not found then control is passed
    # to the AUTOLOAD in AutoLoader.

    my $constname;
    ($constname = $AUTOLOAD) =~ s/.*:://;
    croak "& not defined" if $constname eq 'constant';
    my $val = constant_iv($constname, @_ ? $_[0] : 0);
    #if ($! != 0) {
    # could check: $val = constant_nv($constname, @_ ? $_[0] : 0);
    #}
    if ($! != 0) {
        if ($! =~ /Invalid/) {
            $AutoLoader::AUTOLOAD = $AUTOLOAD;
            goto &AutoLoader::AUTOLOAD;
        }
        else {
                croak "Your vendor has not defined ICU macro $constname";
        }
    }
    no strict 'refs';
    *$AUTOLOAD = sub { $val };
    goto &$AUTOLOAD;
}



bootstrap ICU;

1;

__END__


=head1 NAME

ICU - Perl extension for International Components for Unicode

=head1 SYNOPSIS

  use ICU;

=head1 DESCRIPTION

TBD

