package ICU::Normalizer;
#
#    Normalizer.pm
#
#    $Id: Normalizer.pm,v 1.3 2001/06/05 07:29:59 mrperl Exp $
#
#    Copyright (c) 2000 Brian Stell and James
#
#    This package is free software and is provided ``as is'' without
#    express or implied warranty. It may be used, redistributed and/or
#    modified under the terms of the Perl Artistic License 
#    (see http://www.perl.com/perl/misc/Artistic.html)
#

use strict;
use Carp;
use vars qw(@ISA %EXPORT_TAGS $AUTOLOAD);

use Exporter;
@ISA = qw(Exporter);

use ICU;

%EXPORT_TAGS = (
    EMode => [qw( NO_OP COMPOSE COMPOSE_COMPAT DECOMP DECOMP_COMPAT )],
    EModeBit => [qw( COMPAT_BIT DECOMP_BIT COMPOSE_BIT )],
    EStatus => [qw( DONE )],
    EOption => [qw( IGNORE_HANGUL )],
);

Exporter::export_tags();

sub AUTOLOAD {
    # This AUTOLOAD is used to 'autoload' constants from the constant()
    # XS function.  If a constant is not found then control is passed
    # to the AUTOLOAD in AutoLoader.

    my $constname;
    ($constname = $AUTOLOAD) =~ s/.*:://;
    croak "& not defined" if $constname eq 'constant';
    my $val = constant_iv($constname, @_ ? $_[0] : 0);
    if ($! != 0) { 
        if ($! =~ /Invalid/) {
            $AutoLoader::AUTOLOAD = $AUTOLOAD;
            goto &AutoLoader::AUTOLOAD;
        }
        else {
                croak "Your vendor has not defined ICU::Normalizer macro $constname";
        }
    }
    no strict 'refs';
    *$AUTOLOAD = sub { $val };
    goto &$AUTOLOAD;
}

1;

__END__

=head1 NAME

ICU::Normalizer 

=head1 SYNOPSIS

  use ICU::Normalizer;

=head1 DESCRIPTION

TBD

