use Test::More tests => 101;

BEGIN { use_ok "Crypt::UnixCrypt_XS"; }

while(<DATA>) {
	my($fullhash, $salt, $password) = (/^((_\S{8})\S{11}) (\S+)$/);
	is Crypt::UnixCrypt_XS::crypt($password, $salt), $fullhash;
}

__DATA__
_/...rfZCB9Fh7zhPZJk Ahe1-$kxz$zCt~i;:uH+q6&fodM$HuaP^Kmt>wg|G$(S8$plR
_./..TC504.9WMT5FKqk ,J@QE3d*l#'I_-b
_../.Uy1UkhNReQqDiQ6 AxR@BlQ5&X#Fj@o"5h;.["vy,MQIj{![/q
_.../Q4vR4qzqS47NGfw '0<@D7{d:48>)Y$Z+O"=6L
_xE..j4z1sJY0AgqnjfA jT_\*e
_Kf..8yg0I4ZlGYbqo22 ^`4-
_1l/.4z1sk2pL3SZDPeI w}CzT7c.-mXp"P@&hbX]\~<1R(pR$AeB_aD[
_c1..6B8NiFLGW2U5Czs \"q?H_X*(\e"!$nWJ`9>;<aFka6FyL9<!<|u
_AO/.YPbIj6HGFz1megE f%5+HRMHd3d+DEpZg3Cb
_zd/.XJw4qZwMwcs9Xk2 RC,7/T0N=x@HT+}dgq'{h2f8A+./FsXp-8@3^@
_Tj/.xRhMdx17dl0nYJ. bi8{8)-LL,mSf1Zs1cYr^
_Av..J45BzAippggNqKo YJ[x1U
_vQ/.177lAb6Hi6VRwic _jNnV^yCvh$rQ`t~IAo'
_vQ/.Q6lC2TPucCHXA26 Hd&^omMBfj
_S6/.p6046pUYMidVIjo (o<fJF#9Vgjx?-;EEAn$w-du/]|iDrNU:m@
_aR..IwitJAfBRBBN8Ig PI(g`eqjEes&5/:W7ooHI
_UJ..q.6b4TuFWpgDnzQ @wh@
_Lg..B1pPySsu3iK19ZQ Vchj2I
_fJ0..Ia4hiRUS2VZZso T#nh8jK6Tw%
_p0/.G99ECt0EycjcA7o 8?#0-cDP]f'JD/XM&MF)l)T=Y|2;~XEdC1kRvqY>]t
_cJ/.shWZu5rreK3ii/A AKX#^hV@9JHCqyvmDLxY<(%\=}
_PB/.rhl.jXzCL4kvG5I -|q&
_n70.FX/cEJ0T9ctYYLg zbxx(}5mzk[
_TK/.J1sVsAYT5rIoLJQ 7RHU^j/yU!KmK}1}lLaOQ&zz'
_y8/.S81q3gQJ5JFfBBA (Qj'i3H*(m+YlN9YWL/l,"8\P/sofRdmkTAO}/5ox.Mn7a
_o3..WnTXuctrQp4Ri86 q(\~_+pt\Kp?='&,f+haBq']0,0,p\s@_Z@r[r%
_y30.M1YrzqeI8sTkT9I v7o}T8)S[!<KAO8Sx(_.)BC!RVV2G22ra:S'A5U`QJ
_oZ..a/bxx/fPWU5MHUE Zdl+$>"qmF+O9ao<AxsRTA
_dq/.sjcxnP5bo7JR3x6 (0\nOS?|rXJ=HyZP3C;KX`;HDnRRYJ>(U9pA"e2D|0DP*g
_GB..n5/lSM/DC2g/eog n]}E`3]
_ci..qQo0MrQSsFd264Q "0Bf9pkjOkALO:E&\y?i$T*$
_/a/.9i9SjbindhXssKY %(?Jx1A^~tk2g0Z|im{bE"{_)cjI^1GG*`8~*OvD944
_Mx/.1oYJtpDRVK3ZW3Q g<}a5.{>br4:-\F91Rl3a>{n,^x
_W40.4ldksQ3GEJzY856 c3y*1=1D)R,*\
_/10.81.lx4NRW6Hwp6Y vQvTp6
_cn..JERFqC5otcVzR9M AaeZ4Ogz"F
_dU/.RCcu3tNllk5XAr. {[n$b^)$.sPQ'w.8XV1Wkv-[nhf7kipe]c
_8H/.Q91cp8b.hzxuNzs tPl6S:0U-kT40%G*
_lK/.XoQ1vY0SpTxEMqY S`}J;`V-;&p
_Ex..CPBi16asKeg5oaU &\;;|dhn.9_o]$
_Hv..g/bRBSu3ZBDIY62 J:P@UM-g
_670.oIAm/V9a5.tNTrE l~iB,vHu+jR`hD{sP#8jE\^m.qKFU-I1b(
_vw/.sH5VFbdGnftJkyI tgiw;0PHe'4w;h
_1O0.QVBEEKS2WjEb4Gc 9kNzinDFti1E5AC]Ar>QN3*}x>r&hEsK_50lKplA17W@AoG,
_Bq/.aZ.IVGlHhdN2Lek ,df$_I=&y9;3wEJbc}~_v2}}au2^(MZ8&Y5_,Mqxqd1=)wH>
_Vn..LeoWrUey4CVm05U "sj|1T(JX.}28]>lZVu7[)).kNde{Zv<*skk^CSdtjgmj
_lI/.QV1as1hChI9TI/Y i&PB"9gAKO5O?x[|HD"[_yJ6N<^MEhFL6L)]a@
_h4..TKHoJ2aJOmelz9I BnMkyor]a54-GD:M
_rT/.0D6tM9.qZiYgNSM =]NB;RG2x[zYY,v~LaD{d{-we8H97BLTO
_370.FNIF9YeRO9u9r6Q Ln0[jj]Kjck|0PUBi4Mcp;-a>h#o_R*!Rk&4~ly/RtlzK,.7.
_rA0.8Zi4RDxXUS./ZDY VaQ,Qa
_S10.AIrIlW/jmT37d9M y1.Iagk!#X
_kl/.jYpFm5vbO.y7PZc 3$XWDvIo'<d{%
_tz/.K.4Gv6OCrKmzxZA KO8qU7B[rk!-lcP96yV:{eGIXzq}avL(j
_tW/.MLJ93Lmedb/qyGE 45cS~9t0;,23+{'y)
_7E..fwgIo8e/KUXsU5s #J4xqus,m?xjR)*8bl;M1N
_2Q..BUEWC6JtG.EeH/M !
_ic/.r9WVDH2zEoxQORg me(z_jBI3fq4<G{E|EF
_ZZ/.abW84693W3rNa2M l*la3*T*t|=gGr.8.jsv2WP({
_F8..zoc2xLqC3vt84Og K{Y\2.29(OaZBKEnA8}#Se(OpUm^8^`
_Mq/.QrOhZ4pT7bL/X0Y (H#so8N9*_4pxo[Wu9)V%mHc
_QM/.LRXE2RhgJDbnCF2 /37MS&C)?#)vN&Tsbrup:0jf&,FBU
_NN0.igLfkugYyy8VvQQ H*p\Q/
_g5/.NxOZeSA2lsOyeJw /Gd0I;2}5@Lba2gJf~v\,i<_~m(lS<Umc)+=_X92,ae8yfcGH
_bT..CMumOELvbVLVTYQ URzYR<Rg~q2:73+soxY3
_ij/.jCOmYDot5XJSfqQ 7!KW-kB4>HV7CN_Q_ueJ7I%[lUN$JUF[{U'^8Vdd
_vK..r5AGvfxOCdpMnlc aZeRJo5~l*%.B}*,ginx#bp"VsT=E4j>+I3_SPPM'bx7u
_yh..v/SOxWEhK9xRFJ2 9R(f^`fL=W\zcwy8dDz+tux`
_en..JzCXtDLzmWsoKV. :^
_CL/.g7eA26fszVHahuI HPxL"*b<1Gmf"8sv&Q.,G57q>kEJsXw>K}(yK.g+sr
_OG0.6frWjWm/G62muto OE1}?~/sXhz[>.,`0~[ub<:/z
_XY..iGw/BPW9SbpGGD2 zz&0vtbelput1K_Q\Rx~
_XO0.VMthUMCX743Y9UI ^pKd/]>b**Bou
_pw..DN5VJgK7JcRWIIU sD,8u%nERwrc\ucH|,Rm?;t9b8j2F,OV>z@@5;!6
_1/0.vIu/QLPGpymPAvA O4JU$G`X;Dw`G5ib<6<Ei=x*O|ud
_tj/./YY5k0QCaCU.M.Q -V4?Qgw*k'uXb>%R]QkAruK/
_We..ZJy7k3M8F5cHvgU w:A`N2Gz
_PP..68hg7oEUavYGA7c gPFB:9Vwwp;L?G>2bx3LY<WK=tHeYRcZSHfPhtOowQCzvS
_cK/.Sv3syBYmwqJjNK6 %6%||,@p4[K0}u\5
_3d..LmjS5R8Qj1WCzBA KG8ILmd!
_/u/.299oYwEBWouyfkE `zj38kr!ctL`dP'*P+CP)<c7h=L<t
_LK..4p7.DGypXG7BCgo vVo1PGpv
_as..ylzpoiEMcTwbWQg Vu=::J
_y10.Us9XytzJuJS0JWI D']JZ
_4b/.rmsS7Ro2UsP8TUM (RY.B
_Vz..xtl0OTkQDP8CNPc L%h,CU)CW+%}HHff:E
_b2/.32pwaqcdeDX..dY ^(78(+voC0!}eGP_)l7S=nB)0
_ue..a6gCtyn/RZ7.tXo edF_Hr{?jWGr4
_S6/.KP./CGUD/LMYuNc CYSMw,Jn+
_wM..P.NPvRAZtIANpfM hoY$FH(#{ZUIju/bC44@a':,CEA]Y}cn57cRVtp9jG
_LC0.ONl8GTDfWDAVqD2 v=>S
_bt/.77CwjdXLFI2Q2Ic :SDZ(GDNc&ymwKdq7p^hbk'@MKUEg]ntSb(a%L)!/VCET8kD7
_u3..o5G7CGXmiVftl0w si(Nb<8@D](~h47m[>+*Wh,k1s7`9o
_JV/.sK/chaBabs.r22w p,C75=:/\CO$b<1N/2sGuu#2%HSp,cBHy}3Ny3$/V
_Fu/.NqA1A3UXZwNqEBM g9__a,ax3"k?wn|CF
_L8..aopATqOIbENUckQ PSI\/&4hqrNJyiuR&p';mAP`/~5$4)d\FfcgSU&hD
_d3/.WrKw/puBiAtrruc l$4ktBjKxG=^qYdw&B#b!^wed!X6ModOot_Q;io8]:&$[F.xJ
_1v..LSxgR45HzV/dWMI -I1?<:Q[}'W:P
_C1...3IJaLhgpP5yl2Q j;H@$Z
_5H0.PjD9w2E.ud.LTIs 7CmnUws(=h*pn;d0=QM9Oj=I
