#!/usr/bin/perl

package eBay::API::XML::DataType::ShippingPackageDetailsType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ShippingPackageDetailsType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::ShippingPackageDetailsType

=head1 DESCRIPTION

Details about type of package used to ship an item.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::ShippingPackageDetailsType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::Enum::ShippingPackageCodeType;


my @gaProperties = ( [ 'Default', 'xs:boolean', '', '', '' ]
	, [ 'Description', 'xs:string', '', '', '' ]
	, [ 'PackageID', 'xs:int', '', '', '' ]
	, [ 'ShippingPackage', 'ns:ShippingPackageCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ShippingPackageCodeType', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setDefault()

Indicates if the package type is the default for the specified site.

#    Argument: 'xs:boolean'

=cut

sub setDefault {
  my $self = shift;
  $self->{'Default'} = shift
}

=head2 isDefault()

  Calls: GeteBayDetails
  Returned: Conditionally

#    Returns: 'xs:boolean'

=cut

sub isDefault {
  my $self = shift;
  return $self->{'Default'};
}


=head2 setDescription()

Full name of the shipping package for display purposes.

#    Argument: 'xs:string'

=cut

sub setDescription {
  my $self = shift;
  $self->{'Description'} = shift
}

=head2 getDescription()

  Calls: GeteBayDetails
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getDescription {
  my $self = shift;
  return $self->{'Description'};
}


=head2 setPackageID()

Numeric identifier.
Some applications use this ID to look up shipping packages more efficiently.

#    Argument: 'xs:int'

=cut

sub setPackageID {
  my $self = shift;
  $self->{'PackageID'} = shift
}

=head2 getPackageID()

  Calls: GeteBayDetails
  Returned: Conditionally

#    Returns: 'xs:int'

=cut

sub getPackageID {
  my $self = shift;
  return $self->{'PackageID'};
}


=head2 setShippingPackage()

Value used for the shipping package.
For a list of valid values that you can cache for future use, call GeteBayDetails
with DetailName set to ShippingPackageDetails.

#    Argument: 'ns:ShippingPackageCodeType'

=cut

sub setShippingPackage {
  my $self = shift;
  $self->{'ShippingPackage'} = shift
}

=head2 getShippingPackage()

  Calls: GeteBayDetails
  Returned: Conditionally

#    Returns: 'ns:ShippingPackageCodeType'

=cut

sub getShippingPackage {
  my $self = shift;
  return $self->{'ShippingPackage'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
