#!/usr/bin/perl

package eBay::API::XML::DataType::ShipmentType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ShipmentType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::ShipmentType

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::ShipmentType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::AddressType;
use eBay::API::XML::DataType::AmountType;
use eBay::API::XML::DataType::ItemTransactionIDType;
use eBay::API::XML::DataType::MeasureType;
use eBay::API::XML::DataType::Enum::ShipmentDeliveryStatusCodeType;
use eBay::API::XML::DataType::Enum::ShipmentStatusCodeType;
use eBay::API::XML::DataType::Enum::ShippingCarrierCodeType;
use eBay::API::XML::DataType::Enum::ShippingFeatureCodeType;
use eBay::API::XML::DataType::Enum::ShippingPackageCodeType;


my @gaProperties = ( [ 'DeliveryDate', 'xs:dateTime', '', '', '' ]
	, [ 'DeliveryStatus', 'ns:ShipmentDeliveryStatusCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ShipmentDeliveryStatusCodeType', '' ]
	, [ 'EstimatedDeliveryDate', 'xs:dateTime', '', '', '' ]
	, [ 'InsuredValue', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'ItemTransactionID', 'ns:ItemTransactionIDType', '1'
	     ,'eBay::API::XML::DataType::ItemTransactionIDType', '1' ]
	, [ 'PackageDepth', 'ns:MeasureType', ''
	     ,'eBay::API::XML::DataType::MeasureType', '1' ]
	, [ 'PackageLength', 'ns:MeasureType', ''
	     ,'eBay::API::XML::DataType::MeasureType', '1' ]
	, [ 'PackageWidth', 'ns:MeasureType', ''
	     ,'eBay::API::XML::DataType::MeasureType', '1' ]
	, [ 'PayPalShipmentID', 'xs:string', '', '', '' ]
	, [ 'PostageTotal', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'PrintedTime', 'xs:dateTime', '', '', '' ]
	, [ 'RefundGrantedTime', 'xs:dateTime', '', '', '' ]
	, [ 'RefundRequestedTime', 'xs:dateTime', '', '', '' ]
	, [ 'ShipFromAddress', 'ns:AddressType', ''
	     ,'eBay::API::XML::DataType::AddressType', '1' ]
	, [ 'ShipmentID', 'xs:long', '', '', '' ]
	, [ 'ShipmentTrackingNumber', 'xs:string', '', '', '' ]
	, [ 'ShippingAddress', 'ns:AddressType', ''
	     ,'eBay::API::XML::DataType::AddressType', '1' ]
	, [ 'ShippingCarrierUsed', 'ns:ShippingCarrierCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ShippingCarrierCodeType', '' ]
	, [ 'ShippingFeature', 'ns:ShippingFeatureCodeType', '1'
	     ,'eBay::API::XML::DataType::Enum::ShippingFeatureCodeType', '' ]
	, [ 'ShippingPackage', 'ns:ShippingPackageCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ShippingPackageCodeType', '' ]
	, [ 'ShippingServiceUsed', 'xs:token', '', '', '' ]
	, [ 'Status', 'ns:ShipmentStatusCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ShipmentStatusCodeType', '' ]
	, [ 'WeightMajor', 'ns:MeasureType', ''
	     ,'eBay::API::XML::DataType::MeasureType', '1' ]
	, [ 'WeightMinor', 'ns:MeasureType', ''
	     ,'eBay::API::XML::DataType::MeasureType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setDeliveryDate()

Revise only

#    Argument: 'xs:dateTime'

=cut

sub setDeliveryDate {
  my $self = shift;
  $self->{'DeliveryDate'} = shift
}

=head2 getDeliveryDate()

#    Returns: 'xs:dateTime'

=cut

sub getDeliveryDate {
  my $self = shift;
  return $self->{'DeliveryDate'};
}


=head2 setDeliveryStatus()

Revise only

#    Argument: 'ns:ShipmentDeliveryStatusCodeType'

=cut

sub setDeliveryStatus {
  my $self = shift;
  $self->{'DeliveryStatus'} = shift
}

=head2 getDeliveryStatus()

#    Returns: 'ns:ShipmentDeliveryStatusCodeType'

=cut

sub getDeliveryStatus {
  my $self = shift;
  return $self->{'DeliveryStatus'};
}


=head2 setEstimatedDeliveryDate()

#    Argument: 'xs:dateTime'

=cut

sub setEstimatedDeliveryDate {
  my $self = shift;
  $self->{'EstimatedDeliveryDate'} = shift
}

=head2 getEstimatedDeliveryDate()

#    Returns: 'xs:dateTime'

=cut

sub getEstimatedDeliveryDate {
  my $self = shift;
  return $self->{'EstimatedDeliveryDate'};
}


=head2 setInsuredValue()

#    Argument: 'ns:AmountType'

=cut

sub setInsuredValue {
  my $self = shift;
  $self->{'InsuredValue'} = shift
}

=head2 getInsuredValue()

#    Returns: 'ns:AmountType'

=cut

sub getInsuredValue {
  my $self = shift;
  return $self->_getDataTypeInstance( 'InsuredValue'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setItemTransactionID()

#    Argument: reference to an array  
                      of 'ns:ItemTransactionIDType'

=cut

sub setItemTransactionID {
  my $self = shift;
  $self->{'ItemTransactionID'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getItemTransactionID()

#    Returns: reference to an array  
                      of 'ns:ItemTransactionIDType'

=cut

sub getItemTransactionID {
  my $self = shift;
  return $self->_getDataTypeArray('ItemTransactionID');
}


=head2 setPackageDepth()

Depth dimension of the package needed to ship the item after it is sold.
For calculated shipping only.

#    Argument: 'ns:MeasureType'

=cut

sub setPackageDepth {
  my $self = shift;
  $self->{'PackageDepth'} = shift
}

=head2 getPackageDepth()

#    Returns: 'ns:MeasureType'

=cut

sub getPackageDepth {
  my $self = shift;
  return $self->_getDataTypeInstance( 'PackageDepth'
		,'eBay::API::XML::DataType::MeasureType');
}


=head2 setPackageLength()

Length dimension of the package needed to ship the item after it is sold.
For calculated shipping only.

#    Argument: 'ns:MeasureType'

=cut

sub setPackageLength {
  my $self = shift;
  $self->{'PackageLength'} = shift
}

=head2 getPackageLength()

#    Returns: 'ns:MeasureType'

=cut

sub getPackageLength {
  my $self = shift;
  return $self->_getDataTypeInstance( 'PackageLength'
		,'eBay::API::XML::DataType::MeasureType');
}


=head2 setPackageWidth()

Width dimension of the package needed to ship the item after it is sold.
For calculated shipping only.

#    Argument: 'ns:MeasureType'

=cut

sub setPackageWidth {
  my $self = shift;
  $self->{'PackageWidth'} = shift
}

=head2 getPackageWidth()

#    Returns: 'ns:MeasureType'

=cut

sub getPackageWidth {
  my $self = shift;
  return $self->_getDataTypeInstance( 'PackageWidth'
		,'eBay::API::XML::DataType::MeasureType');
}


=head2 setPayPalShipmentID()

#    Argument: 'xs:string'

=cut

sub setPayPalShipmentID {
  my $self = shift;
  $self->{'PayPalShipmentID'} = shift
}

=head2 getPayPalShipmentID()

#    Returns: 'xs:string'

=cut

sub getPayPalShipmentID {
  my $self = shift;
  return $self->{'PayPalShipmentID'};
}


=head2 setPostageTotal()

#    Argument: 'ns:AmountType'

=cut

sub setPostageTotal {
  my $self = shift;
  $self->{'PostageTotal'} = shift
}

=head2 getPostageTotal()

#    Returns: 'ns:AmountType'

=cut

sub getPostageTotal {
  my $self = shift;
  return $self->_getDataTypeInstance( 'PostageTotal'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setPrintedTime()

#    Argument: 'xs:dateTime'

=cut

sub setPrintedTime {
  my $self = shift;
  $self->{'PrintedTime'} = shift
}

=head2 getPrintedTime()

#    Returns: 'xs:dateTime'

=cut

sub getPrintedTime {
  my $self = shift;
  return $self->{'PrintedTime'};
}


=head2 setRefundGrantedTime()

Revise only

#    Argument: 'xs:dateTime'

=cut

sub setRefundGrantedTime {
  my $self = shift;
  $self->{'RefundGrantedTime'} = shift
}

=head2 getRefundGrantedTime()

#    Returns: 'xs:dateTime'

=cut

sub getRefundGrantedTime {
  my $self = shift;
  return $self->{'RefundGrantedTime'};
}


=head2 setRefundRequestedTime()

Revise only

#    Argument: 'xs:dateTime'

=cut

sub setRefundRequestedTime {
  my $self = shift;
  $self->{'RefundRequestedTime'} = shift
}

=head2 getRefundRequestedTime()

#    Returns: 'xs:dateTime'

=cut

sub getRefundRequestedTime {
  my $self = shift;
  return $self->{'RefundRequestedTime'};
}


=head2 setShipFromAddress()

The address from which the item is being shipped.

#    Argument: 'ns:AddressType'

=cut

sub setShipFromAddress {
  my $self = shift;
  $self->{'ShipFromAddress'} = shift
}

=head2 getShipFromAddress()

#    Returns: 'ns:AddressType'

=cut

sub getShipFromAddress {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ShipFromAddress'
		,'eBay::API::XML::DataType::AddressType');
}


=head2 setShipmentID()

#    Argument: 'xs:long'

=cut

sub setShipmentID {
  my $self = shift;
  $self->{'ShipmentID'} = shift
}

=head2 getShipmentID()

#    Returns: 'xs:long'

=cut

sub getShipmentID {
  my $self = shift;
  return $self->{'ShipmentID'};
}


=head2 setShipmentTrackingNumber()

The tracking number associated with the shipment. The format of the shipment
tracking number must be consistent with the specified ShippingCarrierUsed.

  Calls: CompleteSale
  RequiredInput: No

#    Argument: 'xs:string'

=cut

sub setShipmentTrackingNumber {
  my $self = shift;
  $self->{'ShipmentTrackingNumber'} = shift
}

=head2 getShipmentTrackingNumber()

#    Returns: 'xs:string'

=cut

sub getShipmentTrackingNumber {
  my $self = shift;
  return $self->{'ShipmentTrackingNumber'};
}


=head2 setShippingAddress()

The address to which the item is to be shipped.

#    Argument: 'ns:AddressType'

=cut

sub setShippingAddress {
  my $self = shift;
  $self->{'ShippingAddress'} = shift
}

=head2 getShippingAddress()

#    Returns: 'ns:AddressType'

=cut

sub getShippingAddress {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ShippingAddress'
		,'eBay::API::XML::DataType::AddressType');
}


=head2 setShippingCarrierUsed()

The shipping carrier used.

  Calls: CompleteSale
  RequiredInput: No
  OnlyTheseValues: USPS, UPS

#    Argument: 'ns:ShippingCarrierCodeType'

=cut

sub setShippingCarrierUsed {
  my $self = shift;
  $self->{'ShippingCarrierUsed'} = shift
}

=head2 getShippingCarrierUsed()

#    Returns: 'ns:ShippingCarrierCodeType'

=cut

sub getShippingCarrierUsed {
  my $self = shift;
  return $self->{'ShippingCarrierUsed'};
}


=head2 setShippingFeature()

#    Argument: reference to an array  
                      of 'ns:ShippingFeatureCodeType'

=cut

sub setShippingFeature {
  my $self = shift;
  $self->{'ShippingFeature'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getShippingFeature()

#    Returns: reference to an array  
                      of 'ns:ShippingFeatureCodeType'

=cut

sub getShippingFeature {
  my $self = shift;
  return $self->_getDataTypeArray('ShippingFeature');
}


=head2 setShippingPackage()

The size of the package used to ship the item(s). See ShippingPackageCodeType
for its possible values. Input.

#    Argument: 'ns:ShippingPackageCodeType'

=cut

sub setShippingPackage {
  my $self = shift;
  $self->{'ShippingPackage'} = shift
}

=head2 getShippingPackage()

#    Returns: 'ns:ShippingPackageCodeType'

=cut

sub getShippingPackage {
  my $self = shift;
  return $self->{'ShippingPackage'};
}


=head2 setShippingServiceUsed()

The size of the package used to ship the item(s). See ShippingPackageCodeType
for its possible values. Input.

#    Argument: 'xs:token'

=cut

sub setShippingServiceUsed {
  my $self = shift;
  $self->{'ShippingServiceUsed'} = shift
}

=head2 getShippingServiceUsed()

#    Returns: 'xs:token'

=cut

sub getShippingServiceUsed {
  my $self = shift;
  return $self->{'ShippingServiceUsed'};
}


=head2 setStatus()

Status, for revise only

#    Argument: 'ns:ShipmentStatusCodeType'

=cut

sub setStatus {
  my $self = shift;
  $self->{'Status'} = shift
}

=head2 getStatus()

#    Returns: 'ns:ShipmentStatusCodeType'

=cut

sub getStatus {
  my $self = shift;
  return $self->{'Status'};
}


=head2 setWeightMajor()

See the documentation regarding "Working with Item Weights".
The 'unit' attribute can have a value of lbs.

#    Argument: 'ns:MeasureType'

=cut

sub setWeightMajor {
  my $self = shift;
  $self->{'WeightMajor'} = shift
}

=head2 getWeightMajor()

#    Returns: 'ns:MeasureType'

=cut

sub getWeightMajor {
  my $self = shift;
  return $self->_getDataTypeInstance( 'WeightMajor'
		,'eBay::API::XML::DataType::MeasureType');
}


=head2 setWeightMinor()

See the documentation regarding "Working with Item Weights".
The 'unit' attribute is optional and assumed to be the
minor compared to the value of 'unit' in WeightMajor.

#    Argument: 'ns:MeasureType'

=cut

sub setWeightMinor {
  my $self = shift;
  $self->{'WeightMinor'} = shift
}

=head2 getWeightMinor()

#    Returns: 'ns:MeasureType'

=cut

sub getWeightMinor {
  my $self = shift;
  return $self->_getDataTypeInstance( 'WeightMinor'
		,'eBay::API::XML::DataType::MeasureType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
